/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.DatasetDataTable;
import org.opensourcephysics.tools.DatasetStatisticsTable;
import org.opensourcephysics.tools.ToolsRes;

public class DatasetTab
extends JPanel {
    protected final Dataset original;
    protected HighlightableDataset dataset = new HighlightableDataset();
    protected HighlightableDataset displayData = new HighlightableDataset();
    protected JSplitPane[] splitPanes;
    protected Plot plot;
    protected DatasetDataTable dataTable;
    protected DatasetStatisticsTable statsTable;
    protected DatasetCurveFitter curveFitter;
    protected String[] shapeNames;
    protected int[] shapeNumbers;
    protected JSpinner shapeSpinner;
    protected JSpinner sizeSpinner;
    protected JCheckBox markerCheckBox;
    protected JCheckBox lineCheckBox;
    protected JCheckBox fitCheckBox;
    protected JCheckBox statsCheckBox;
    protected JButton markerColorButton;
    protected JButton lineColorButton;
    protected JButton fitColorButton;
    protected int buttonHeight = 28;
    protected SelectionBox selectionBox = new SelectionBox();
    protected Point zoomPoint;
    static /* synthetic */ Class class$org$opensourcephysics$display$Dataset;
    static /* synthetic */ Class class$org$opensourcephysics$display$FunctionDrawer;

    public DatasetTab(Dataset data) {
        this.original = data;
        XMLControlElement xml = new XMLControlElement(this.original);
        xml.loadObject(this.dataset, true, true);
        this.createGUI();
    }

    protected Dataset getDataset() {
        this.original.setMarkerShape(this.dataset.getMarkerShape());
        this.original.setMarkerSize(this.dataset.getMarkerSize());
        this.original.setConnected(this.dataset.isConnected());
        this.original.setLineColor(this.dataset.getLineColor());
        this.original.setMarkerColor(this.dataset.getFillColor(), this.dataset.getEdgeColor());
        return this.original;
    }

    protected void updateData() {
        XMLControlElement xml = new XMLControlElement(this.original);
        xml.loadObject(this.dataset, true, true);
        this.refresh();
        this.dataTable.refreshTable();
    }

    protected void createGUI() {
        this.setLayout(new BorderLayout());
        int paneCount = 3;
        this.splitPanes = new JSplitPane[paneCount];
        this.splitPanes[0] = new JSplitPane(1);
        this.splitPanes[0].setResizeWeight(1.0);
        this.splitPanes[1] = new JSplitPane(0);
        this.splitPanes[1].setResizeWeight(1.0);
        this.splitPanes[2] = new JSplitPane(0);
        this.shapeNames = new String[]{ToolsRes.getString("Shape.Circle"), ToolsRes.getString("Shape.Square"), ToolsRes.getString("Shape.Pixel"), ToolsRes.getString("Shape.Bar"), ToolsRes.getString("Shape.Post"), ToolsRes.getString("Shape.Area")};
        this.shapeNumbers = new int[]{1, 2, 6, 7, 8, 5};
        SpinnerListModel model = new SpinnerListModel(this.shapeNames);
        this.shapeSpinner = new JSpinner(model);
        this.shapeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerShape.ToolTip"));
        Dimension dim = this.shapeSpinner.getPreferredSize();
        this.shapeSpinner.setMaximumSize(new Dimension(dim.width + 20, 100));
        this.shapeSpinner.setPreferredSize(new Dimension(dim.width + 10, dim.height));
        int shape = this.dataset.getMarkerShape();
        for (int i = 0; i < this.shapeNumbers.length; ++i) {
            if (this.shapeNumbers[i] != shape) continue;
            this.shapeSpinner.setValue(this.shapeNames[i]);
        }
        this.shapeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                String shape = DatasetTab.this.shapeSpinner.getValue().toString();
                for (int i = 0; i < DatasetTab.this.shapeNames.length; ++i) {
                    if (!DatasetTab.this.shapeNames[i].equals(shape)) continue;
                    DatasetTab.this.dataset.setMarkerShape(DatasetTab.this.shapeNumbers[i]);
                    DatasetTab.this.refresh();
                }
            }
        });
        SpinnerNumberModel sizemodel = new SpinnerNumberModel(2, 1, 6, 1);
        this.sizeSpinner = new JSpinner(sizemodel);
        this.sizeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerSize.ToolTip"));
        dim = this.sizeSpinner.getPreferredSize();
        this.sizeSpinner.setMaximumSize(new Dimension(dim.width, 100));
        this.sizeSpinner.setMinimumSize(new Dimension(dim.width, 100));
        this.sizeSpinner.setValue(new Integer(this.dataset.getMarkerSize()));
        this.sizeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int size = (Integer)DatasetTab.this.sizeSpinner.getValue();
                DatasetTab.this.dataset.setMarkerSize(size);
                DatasetTab.this.refresh();
            }
        });
        this.markerCheckBox = new JCheckBox(ToolsRes.getString("Checkbox.Markers.Label"));
        boolean hasMarker = this.dataset.getMarkerShape() != 0;
        this.markerCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Markers.ToolTip"));
        this.markerCheckBox.setSelected(hasMarker);
        this.markerCheckBox.setOpaque(false);
        this.markerCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DatasetTab.this.markerCheckBox.isSelected()) {
                    String shape = DatasetTab.this.shapeSpinner.getValue().toString();
                    for (int i = 0; i < DatasetTab.this.shapeNames.length; ++i) {
                        if (!DatasetTab.this.shapeNames[i].equals(shape)) continue;
                        DatasetTab.this.dataset.setMarkerShape(DatasetTab.this.shapeNumbers[i]);
                        break;
                    }
                } else {
                    DatasetTab.this.dataset.setMarkerShape(0);
                }
                DatasetTab.this.refresh();
            }
        });
        this.lineCheckBox = new JCheckBox(ToolsRes.getString("Checkbox.Lines.Label"));
        this.lineCheckBox.setSelected(this.dataset.isConnected());
        this.lineCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Lines.ToolTip"));
        this.lineCheckBox.setOpaque(false);
        this.lineCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatasetTab.this.dataset.setConnected(DatasetTab.this.lineCheckBox.isSelected());
                DatasetTab.this.refresh();
            }
        });
        AbstractAction colorAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Color color;
                JButton button = (JButton)e.getSource();
                String s = ToolsRes.getString("ColorChooser.Marker.Title");
                if (button == DatasetTab.this.lineColorButton) {
                    s = ToolsRes.getString("ColorChooser.Line.Title");
                }
                if (button == DatasetTab.this.fitColorButton) {
                    s = ToolsRes.getString("ColorChooser.Fit.Title");
                }
                if ((color = JColorChooser.showDialog(null, s, button.getBackground())) != null) {
                    if (button == DatasetTab.this.markerColorButton) {
                        Color fill = new Color(color.getRed(), color.getGreen(), color.getBlue(), 100);
                        Color edge = color;
                        DatasetTab.this.dataset.setMarkerColor(fill, edge);
                    } else if (button == DatasetTab.this.lineColorButton) {
                        DatasetTab.this.dataset.setLineColor(color);
                    } else if (button == DatasetTab.this.fitColorButton) {
                        DatasetTab.this.curveFitter.setColor(color);
                    }
                    DatasetTab.this.refresh();
                }
            }
        };
        this.markerColorButton = this.createButton(ToolsRes.getString("Button.MarkerColor.Label"), this.buttonHeight);
        this.markerColorButton.setToolTipText(ToolsRes.getString("Button.MarkerColor.ToolTip"));
        this.markerColorButton.addActionListener(colorAction);
        this.lineColorButton = this.createButton(ToolsRes.getString("Button.LineColor.Label"), this.buttonHeight);
        this.lineColorButton.setToolTipText(ToolsRes.getString("Button.LineColor.ToolTip"));
        this.lineColorButton.addActionListener(colorAction);
        this.fitColorButton = this.createButton(ToolsRes.getString("Button.FitColor.Label"), this.buttonHeight);
        this.fitColorButton.setToolTipText(ToolsRes.getString("Button.FitColor.ToolTip"));
        this.fitColorButton.addActionListener(colorAction);
        AbstractAction statsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                boolean vis = DatasetTab.this.statsCheckBox.isSelected();
                DatasetTab.this.splitPanes[2].setDividerLocation(vis ? DatasetTab.this.statsTable.getHeight() + 4 : 0);
            }
        };
        this.statsCheckBox = new JCheckBox(ToolsRes.getString("Checkbox.Statistics.Label"), false);
        this.statsCheckBox.setOpaque(false);
        this.statsCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        this.statsCheckBox.addActionListener(statsAction);
        AbstractAction fitAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DatasetTab.this.splitPanes[1].setDividerSize(DatasetTab.this.splitPanes[2].getDividerSize());
                DatasetTab.this.splitPanes[1].setDividerLocation(1.0);
                DatasetTab.this.plot.removeDrawables(class$org$opensourcephysics$display$FunctionDrawer == null ? (class$org$opensourcephysics$display$FunctionDrawer = DatasetTab.class$("org.opensourcephysics.display.FunctionDrawer")) : class$org$opensourcephysics$display$FunctionDrawer);
                boolean vis = DatasetTab.this.fitCheckBox.isSelected();
                DatasetTab.this.splitPanes[1].setEnabled(vis);
                if (vis) {
                    int max = DatasetTab.this.splitPanes[1].getDividerLocation();
                    int h = DatasetTab.this.curveFitter.getPreferredSize().height;
                    DatasetTab.this.splitPanes[1].setDividerSize(DatasetTab.this.splitPanes[0].getDividerSize());
                    DatasetTab.this.splitPanes[1].setDividerLocation(max - h);
                    DatasetTab.this.plot.addDrawable(DatasetTab.this.curveFitter.getDrawer());
                }
                DatasetTab.this.refresh();
            }
        };
        this.fitCheckBox = new JCheckBox(ToolsRes.getString("Checkbox.Fits.Label"), false);
        this.fitCheckBox.setOpaque(false);
        this.fitCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Fits.ToolTip"));
        this.fitCheckBox.addActionListener(fitAction);
        this.plot = new Plot(this.dataset);
        this.plot.addDrawable(this.dataset);
        this.plot.setTitle(this.dataset.getName());
        this.plot.addDrawable(this.selectionBox);
        MouseInputAdapter mouseSelector = new MouseInputAdapter(){
            ArrayList rowsInside = new ArrayList();

            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                int mask = 4096;
                boolean rightClick = e.isPopupTrigger() || (((InputEvent)e).getModifiersEx() & mask) == mask || e.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1;
                DatasetTab.this.selectionBox.xstart = p.x;
                DatasetTab.this.selectionBox.ystart = p.y;
                this.rowsInside.clear();
                if (rightClick) {
                    if (DatasetTab.this.selectionBox.isZoomable()) {
                        DatasetTab.this.plot.zoomInItem.setText(ToolsRes.getString("MenuItem.ZoomToBox"));
                    } else {
                        DatasetTab.this.zoomPoint = e.getPoint();
                        DatasetTab.this.plot.zoomInItem.setText(ToolsRes.getString("MenuItem.ZoomIn"));
                    }
                } else {
                    DatasetTab.this.selectionBox.setSize(0, 0);
                }
                if (!(e.isControlDown() || e.isShiftDown() || rightClick)) {
                    DatasetTab.this.dataTable.clearSelection();
                }
            }

            public void mouseDragged(MouseEvent e) {
                boolean rightButton;
                int mask = 4096;
                boolean bl = rightButton = (((InputEvent)e).getModifiersEx() & mask) == mask || e.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1;
                if (rightButton) {
                    return;
                }
                HighlightableDataset data = DatasetTab.this.dataTable.getData();
                Point mouse = e.getPoint();
                DatasetTab.this.selectionBox.visible = true;
                DatasetTab.this.selectionBox.setSize(mouse.x - DatasetTab.this.selectionBox.xstart, mouse.y - DatasetTab.this.selectionBox.ystart);
                double[] xpoints = data.getXPoints();
                double[] ypoints = data.getYPoints();
                for (int i = 0; i < xpoints.length; ++i) {
                    double xp = DatasetTab.this.plot.xToPix(xpoints[i]);
                    double yp = DatasetTab.this.plot.yToPix(ypoints[i]);
                    Integer index = new Integer(i);
                    if (DatasetTab.this.selectionBox.contains(xp, yp)) {
                        if (this.rowsInside.contains(index)) continue;
                        this.rowsInside.add(index);
                        DatasetTab.this.dataTable.getSelectionModel().addSelectionInterval(i, i);
                        continue;
                    }
                    if (!this.rowsInside.contains(index)) continue;
                    DatasetTab.this.dataTable.getSelectionModel().removeSelectionInterval(i, i);
                    ((AbstractCollection)this.rowsInside).remove(index);
                }
                DatasetTab.this.plot.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                DatasetTab.this.plot.repaint();
            }
        };
        this.plot.addMouseListener(mouseSelector);
        this.plot.addMouseMotionListener(mouseSelector);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorder(BorderFactory.createEtchedBorder());
        toolbar.addSeparator(new Dimension(4, 4));
        toolbar.add(this.markerCheckBox);
        toolbar.add(this.markerColorButton);
        toolbar.add(this.shapeSpinner);
        toolbar.add(this.sizeSpinner);
        toolbar.addSeparator();
        toolbar.add(this.lineCheckBox);
        toolbar.add(this.lineColorButton);
        toolbar.addSeparator();
        toolbar.add(this.fitCheckBox);
        toolbar.add(this.fitColorButton);
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.statsCheckBox);
        this.curveFitter = new DatasetCurveFitter(this.dataset);
        this.curveFitter.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("drawer")) {
                    DatasetTab.this.plot.removeDrawables(class$org$opensourcephysics$display$FunctionDrawer == null ? (class$org$opensourcephysics$display$FunctionDrawer = DatasetTab.class$("org.opensourcephysics.display.FunctionDrawer")) : class$org$opensourcephysics$display$FunctionDrawer);
                    DatasetTab.this.plot.addDrawable((FunctionDrawer)e.getNewValue());
                }
                DatasetTab.this.plot.repaint();
            }
        });
        this.dataTable = new DatasetDataTable(this.dataset);
        this.dataTable.setRowNumberVisible(true);
        this.dataTable.setColumnSelectionAllowed(false);
        JScrollPane dataScroller = new JScrollPane(this.dataTable);
        this.dataTable.refreshTable();
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
                DatasetTab.this.selectionBox.setSize(0, 0);
                DatasetTab.this.refresh();
                String depVar = DatasetTab.this.displayData.getColumnName(1);
                String indepVar = DatasetTab.this.displayData.getColumnName(0);
                DatasetTab.this.curveFitter.equation.setText(depVar + " = " + DatasetTab.this.curveFitter.fit.getEquation(indepVar));
            }
        });
        this.dataTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (DatasetTab.this.dataTable.getSelectedColumn() == 0) {
                    DatasetTab.this.dataTable.removeRowSelectionInterval(0, DatasetTab.this.dataTable.getRowCount() - 1);
                    DatasetTab.this.dataTable.data.clearHighlights();
                }
            }
        });
        ListSelectionModel selectionModel = this.dataTable.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                try {
                    DatasetTab.this.curveFitter.setData(DatasetTab.this.dataTable.getWorkingData());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.statsTable = new DatasetStatisticsTable(this.dataTable);
        JScrollPane statsScroller = new JScrollPane(this.statsTable);
        this.add((Component)toolbar, "North");
        this.add((Component)this.splitPanes[0], "Center");
        this.splitPanes[0].setLeftComponent(this.splitPanes[1]);
        this.splitPanes[0].setRightComponent(this.splitPanes[2]);
        this.splitPanes[1].setTopComponent(this.plot);
        this.splitPanes[1].setBottomComponent(this.curveFitter);
        this.splitPanes[2].setTopComponent(statsScroller);
        this.splitPanes[2].setBottomComponent(dataScroller);
        this.splitPanes[0].setOneTouchExpandable(true);
        this.splitPanes[2].setDividerSize(2);
        this.splitPanes[2].setEnabled(false);
        this.splitPanes[1].setDividerSize(this.splitPanes[2].getDividerSize());
    }

    protected void init() {
        this.splitPanes[0].setDividerLocation(0.7);
        this.splitPanes[1].setDividerLocation(1.0);
        this.splitPanes[2].setDividerLocation(0);
    }

    protected JButton createButton(String text, final int h) {
        JButton button = new JButton(text){

            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.height = h;
                return dim;
            }
        };
        return button;
    }

    protected void refresh() {
        this.markerColorButton.setForeground(this.dataset.getEdgeColor());
        this.markerColorButton.setEnabled(this.markerCheckBox.isSelected());
        this.shapeSpinner.setEnabled(this.markerCheckBox.isSelected());
        this.sizeSpinner.setEnabled(this.markerCheckBox.isSelected());
        this.lineColorButton.setForeground(this.dataset.getLineColor());
        this.lineColorButton.setEnabled(this.lineCheckBox.isSelected());
        this.fitColorButton.setForeground(this.curveFitter.color);
        this.fitColorButton.setEnabled(this.fitCheckBox.isSelected());
        this.dataTable.dataset.setName(this.dataset.getName());
        this.curveFitter.setData(this.dataTable.getWorkingData());
        this.plot.removeDrawables(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = DatasetTab.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset);
        this.displayData = this.dataTable.getData();
        this.plot.addDrawable(this.displayData);
        if (this.fitCheckBox.isSelected()) {
            this.plot.removeDrawable(this.curveFitter.getDrawer());
            this.plot.addDrawable(this.curveFitter.getDrawer());
        }
        this.plot.setTitle(this.displayData.getName());
        this.plot.setXLabel(this.displayData.getColumnName(0));
        this.plot.setYLabel(this.displayData.getColumnName(1));
        this.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Plot
    extends PlottingPanel {
        JMenuItem zoomInItem;

        Plot(Dataset dataset) {
            super(dataset.getColumnName(0), dataset.getColumnName(1), "");
        }

        protected void zoomOut() {
            double dx = this.xmax - this.xmin;
            double dy = this.ymax - this.ymin;
            this.setPreferredMinMax(this.xmin - dx / 2.0, this.xmax + dx / 2.0, this.ymin - dy / 2.0, this.ymax + dy / 2.0);
            this.validImage = false;
            DatasetTab.this.selectionBox.setSize(0, 0);
            this.repaint();
        }

        protected void zoomIn() {
            int w = DatasetTab.this.selectionBox.getBounds().width;
            int h = DatasetTab.this.selectionBox.getBounds().height;
            if (DatasetTab.this.selectionBox.isZoomable()) {
                int x = DatasetTab.this.selectionBox.getBounds().x;
                int y = DatasetTab.this.selectionBox.getBounds().y;
                double xmin = this.pixToX(x);
                double xmax = this.pixToX(x + w);
                double ymax = this.pixToY(y);
                double ymin = this.pixToY(y + h);
                this.setPreferredMinMax(xmin, xmax, ymin, ymax);
                this.validImage = false;
                DatasetTab.this.selectionBox.setSize(0, 0);
                this.repaint();
            } else if (DatasetTab.this.zoomPoint != null) {
                double dx = this.xmax - this.xmin;
                double dy = this.ymax - this.ymin;
                double xcenter = this.pixToX(DatasetTab.this.zoomPoint.x);
                double ycenter = this.pixToY(DatasetTab.this.zoomPoint.y);
                this.setPreferredMinMax(xcenter - dx / 4.0, xcenter + dx / 4.0, ycenter - dy / 4.0, ycenter + dy / 4.0);
                this.validImage = false;
                DatasetTab.this.selectionBox.setSize(0, 0);
                this.repaint();
            }
        }

        protected void buildPopupmenu() {
            this.popupmenu.setEnabled(true);
            this.zoomInItem = new JMenuItem(ToolsRes.getString("MenuItem.ZoomIn"));
            this.zoomInItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((Plot)Plot.this).DatasetTab.this.plot.zoomIn();
                }
            });
            this.popupmenu.add(this.zoomInItem);
            JMenuItem item = new JMenuItem(ToolsRes.getString("MenuItem.ZoomOut"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((Plot)Plot.this).DatasetTab.this.plot.zoomOut();
                }
            });
            this.popupmenu.add(item);
            item = new JMenuItem(ToolsRes.getString("MenuItem.ZoomToFit"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((Plot)Plot.this).DatasetTab.this.plot.setAutoscaleX(true);
                    ((Plot)Plot.this).DatasetTab.this.plot.setAutoscaleY(true);
                    ((Plot)Plot.this).DatasetTab.this.selectionBox.setSize(0, 0);
                    DatasetTab.this.refresh();
                }
            });
            this.popupmenu.add(item);
            item = new JMenuItem(ToolsRes.getString("MenuItem.Scale"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ScaleInspector plotInspector = new ScaleInspector(Plot.this);
                    plotInspector.setLocationRelativeTo(Plot.this);
                    plotInspector.updateDisplay();
                    ((Component)plotInspector).setVisible(true);
                }
            });
            this.popupmenu.add(item);
            this.popupmenu.addSeparator();
            item = new JMenuItem(ToolsRes.getString("MenuItem.Snapshot"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Plot.this.snapshot();
                }
            });
            this.popupmenu.add(item);
            this.popupmenu.addSeparator();
            item = new JMenuItem(ToolsRes.getString("MenuItem.Inspect"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Plot.this.showInspector();
                }
            });
            this.popupmenu.add(item);
        }
    }

    class SelectionBox
    extends Rectangle
    implements Drawable {
        boolean visible = true;
        int xstart;
        int ystart;
        int zoomSize = 10;
        Color color = new Color(0, 255, 0, 127);

        SelectionBox() {
        }

        public void setSize(int w, int h) {
            int xoffset = Math.min(0, w);
            int yoffset = Math.min(0, h);
            w = Math.abs(w);
            h = Math.abs(h);
            super.setLocation(this.xstart + xoffset, this.ystart + yoffset);
            super.setSize(w, h);
        }

        public void draw(DrawingPanel drawingPanel, Graphics g) {
            if (this.visible) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(this.color);
                g2.draw(this);
            }
        }

        public boolean isZoomable() {
            return this.getBounds().width > this.zoomSize && this.getBounds().height > this.zoomSize;
        }
    }
}

