/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.border.TitledBorder;
import javax.swing.event.SwingPropertyChangeSupport;

public class FontSizer {
    static Object levelObj = new FontSizer();
    static PropertyChangeSupport support = new SwingPropertyChangeSupport(levelObj);
    static int level;
    static double levelFactor;
    static Map fontMap;

    private FontSizer() {
    }

    public static void setLevel(int n) {
        level = Math.abs(n);
        support.firePropertyChange("level", null, new Integer(level));
    }

    public static int getLevel() {
        return level;
    }

    public static void levelUp() {
        support.firePropertyChange("level", null, new Integer(++level));
    }

    public static void levelDown() {
        --level;
        level = Math.max(level, 0);
        support.firePropertyChange("level", null, new Integer(level));
    }

    public static void setFonts(Object obj, int level) {
        double factor = FontSizer.getFactor(level);
        if (obj instanceof Container) {
            FontSizer.setFontFactor((Container)obj, factor);
        } else if (obj instanceof TitledBorder) {
            FontSizer.setFontFactor((TitledBorder)obj, factor);
        } else if (obj instanceof Component) {
            FontSizer.setFontFactor((Component)obj, factor);
        }
    }

    public static Font getResizedFont(Font font, int level) {
        return FontSizer.getResizedFont(font, FontSizer.getFactor(level));
    }

    public static Font getResizedFont(Font font, double factor) {
        if (font == null) {
            return null;
        }
        Font base = (Font)fontMap.get(font);
        if (base == null) {
            base = font;
            fontMap.put(font, base);
        }
        float size = (float)((double)base.getSize() * factor);
        font = base.deriveFont(size);
        fontMap.put(font, base);
        return font;
    }

    public static double getFactor(int level) {
        double factor = 1.0;
        for (int i = 0; i < level; ++i) {
            factor *= levelFactor;
        }
        return factor;
    }

    public static void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (property.equals("level")) {
            support.addPropertyChangeListener(property, listener);
        }
    }

    public static void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        support.removePropertyChangeListener(property, listener);
    }

    private static void setFontFactor(Container c, double factor) {
        Font font = FontSizer.getResizedFont(c.getFont(), factor);
        if (c instanceof JMenu) {
            FontSizer.setMenuFont((JMenu)c, font);
        } else {
            c.setFont(font);
            for (int i = 0; i < c.getComponentCount(); ++i) {
                Component co = c.getComponent(i);
                if (co instanceof Container) {
                    FontSizer.setFontFactor((Container)co, factor);
                    continue;
                }
                FontSizer.setFontFactor(co, factor);
            }
        }
        if (c != null) {
            c.repaint();
        }
    }

    private static void setFontFactor(Component c, double factor) {
        Font font = FontSizer.getResizedFont(c.getFont(), factor);
        c.setFont(font);
    }

    private static void setFontFactor(TitledBorder b, double factor) {
        Font font = FontSizer.getResizedFont(b.getTitleFont(), factor);
        b.setTitleFont(font);
    }

    private static void setMenuFont(JMenu m, Font font) {
        m.setFont(font);
        for (int i = 0; i < m.getMenuComponentCount(); ++i) {
            m.getMenuComponent(i).setFont(font);
            if (!(m.getMenuComponent(i) instanceof JMenu)) continue;
            FontSizer.setMenuFont((JMenu)m.getMenuComponent(i), font);
        }
    }

    static {
        levelFactor = 1.35;
        fontMap = new HashMap();
    }
}

