/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.tools.EncryptionTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.LaunchSaver;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class LaunchBuilder
extends Launcher {
    static final Color RED = new Color(255, 102, 102);
    static JFileChooser fileChooser;
    static FileFilter jarFileFilter;
    static FileFilter htmlFileFilter;
    static FileFilter allFileFilter;
    static int maxArgs;
    Action newTabSetAction;
    Action changeAction;
    Action newTabAction;
    Action addAction;
    Action cutAction;
    Action copyAction;
    Action pasteAction;
    Action importAction;
    Action saveAsAction;
    Action saveAction;
    Action saveAllAction;
    Action saveSetAsAction;
    Action moveUpAction;
    Action moveDownAction;
    Action openJarAction;
    Action searchJarAction;
    Action openArgAction;
    Action openURLAction;
    Action openTabAction;
    FocusListener focusListener;
    KeyListener keyListener;
    JTabbedPane editorTabs;
    JPanel displayPanel;
    JPanel launchPanel;
    JPanel authorPanel;
    ArrayList labels;
    JTextField titleField;
    JLabel titleLabel;
    JTextField passwordEditor;
    JLabel passwordLabel;
    JTextField nameField;
    JLabel nameLabel;
    JTextField tooltipField;
    JLabel tooltipLabel;
    TitledBorder htmlTitle;
    JTextField classField;
    JLabel classLabel;
    JTextField argField;
    JLabel argLabel;
    JSpinner argSpinner;
    JTextField jarField;
    JLabel jarLabel;
    JTextField urlField;
    JLabel urlLabel;
    JPanel urlPanel;
    JTextPane descriptionPane;
    JScrollPane descriptionScroller;
    TitledBorder descriptionTitle;
    JSplitPane displaySplitPane;
    JTextField authorField;
    JLabel authorLabel;
    JTextField keywordField;
    JLabel keywordLabel;
    JTextPane commentPane;
    JScrollPane commentScroller;
    TitledBorder commentTitle;
    TitledBorder optionsTitle;
    TitledBorder securityTitle;
    JCheckBox editorEnabledCheckBox;
    JCheckBox encryptCheckBox;
    JCheckBox onEditCheckBox;
    JCheckBox onLoadCheckBox;
    JCheckBox hideRootCheckBox;
    JCheckBox hiddenCheckBox;
    JCheckBox buttonViewCheckBox;
    JCheckBox singleVMCheckBox;
    JCheckBox showLogCheckBox;
    JCheckBox clearLogCheckBox;
    JCheckBox singletonCheckBox;
    JCheckBox singleAppCheckBox;
    JComboBox levelDropDown;
    String previousClassPath;
    JButton newTabButton;
    JButton addButton;
    JButton cutButton;
    JButton copyButton;
    JButton pasteButton;
    JButton moveUpButton;
    JButton moveDownButton;
    JMenuItem newItem;
    JMenuItem previewItem;
    JMenuItem saveNodeItem;
    JMenuItem saveNodeAsItem;
    JMenuItem saveSetAsItem;
    JMenuItem saveAllItem;
    JMenuItem importItem;
    JMenuItem openTabItem;
    JMenu toolsMenu;
    JMenuItem encryptionToolItem;
    JToolBar toolbar;
    LaunchSaver saver = new LaunchSaver(this);
    static /* synthetic */ Class class$org$opensourcephysics$tools$LaunchNode;
    static /* synthetic */ Class class$org$opensourcephysics$tools$Launcher;

    public LaunchBuilder() {
        OSPFrame.setAuthorMode(true);
    }

    public LaunchBuilder(String fileName) {
        super(fileName);
        OSPFrame.setAuthorMode(true);
    }

    public LaunchBuilder(boolean splash) {
        super(splash);
        OSPFrame.setAuthorMode(true);
    }

    public LaunchBuilder(String fileName, boolean splash) {
        super(fileName, splash);
        OSPFrame.setAuthorMode(true);
    }

    public static void main(String[] args) {
        String fileName = null;
        if (args != null && args.length != 0) {
            fileName = args[0];
        }
        LaunchBuilder builder = new LaunchBuilder(fileName);
        ((Component)builder.frame).setVisible(true);
    }

    public String save(LaunchNode node, String fileName) {
        if (node == null) {
            return null;
        }
        if (fileName == null || fileName.trim().equals("")) {
            return this.saveAs(node);
        }
        if (XML.getExtension(fileName) == null) {
            while (fileName.endsWith(".")) {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
            fileName = fileName + ".xml";
        }
        if (!this.saveOwnedNodes(node)) {
            return null;
        }
        OSPLog.fine(fileName);
        File file = new File(XML.getResolvedPath(fileName, Launcher.tabSetBasePath));
        String fullName = XML.forwardSlash(file.getAbsolutePath());
        String path = XML.getDirectoryPath(fullName);
        XML.createFolders(path);
        XMLControlElement control = new XMLControlElement(node);
        control.write(fullName);
        if (!control.canWrite) {
            OSPLog.info(LaunchRes.getString("Dialog.SaveFailed.Message") + " " + fullName);
            JOptionPane.showMessageDialog(null, LaunchRes.getString("Dialog.SaveFailed.Message") + " " + fileName, LaunchRes.getString("Dialog.SaveFailed.Title"), 2);
            return null;
        }
        node.setFileName(fileName);
        this.changedFiles.remove(node.getFileName());
        return fileName;
    }

    public String saveAs(LaunchNode node) {
        String name;
        Launcher.getXMLChooser().setFileFilter(Launcher.xmlFileFilter);
        if (node.getFileName() != null) {
            name = XML.getResolvedPath(node.getFileName(), Launcher.tabSetBasePath);
            Launcher.getXMLChooser().setSelectedFile(new File(name));
        } else {
            name = node.name;
            if (name.equals(LaunchRes.getString("NewNode.Name")) || name.equals(LaunchRes.getString("NewTab.Name"))) {
                name = LaunchRes.getString("NewFile.Name");
            }
            String path = XML.getResolvedPath(name + ".xml", Launcher.tabSetBasePath);
            Launcher.getXMLChooser().setSelectedFile(new File(path));
        }
        int result = Launcher.getXMLChooser().showDialog(null, LaunchRes.getString("FileChooser.SaveAs.Title"));
        if (result == 0) {
            File file = Launcher.getXMLChooser().getSelectedFile();
            String path = XML.forwardSlash(file.getParent());
            XML.createFolders(path);
            if (file.exists()) {
                String name2 = XML.forwardSlash(file.getAbsolutePath());
                name2 = XML.getPathRelativeTo(name2, Launcher.tabSetBasePath);
                if (this.getOpenPaths().contains(name2)) {
                    JOptionPane.showMessageDialog(this.frame, LaunchRes.getString("Dialog.DuplicateFileName.Message") + " \"" + name2 + "\"", LaunchRes.getString("Dialog.DuplicateFileName.Title"), 2);
                    return null;
                }
                int selected = JOptionPane.showConfirmDialog(this.frame, LaunchRes.getString("Dialog.ReplaceFile.Message") + " " + file.getName() + XML.NEW_LINE + LaunchRes.getString("Dialog.ReplaceFile.Question"), LaunchRes.getString("Dialog.ReplaceFile.Title"), 0);
                if (selected != 0) {
                    return null;
                }
            }
            path = XML.forwardSlash(file.getAbsolutePath());
            String fileName = XML.getPathRelativeTo(path, Launcher.tabSetBasePath);
            OSPFrame.chooserDir = XML.getDirectoryPath(path);
            Map clones = this.getClones(node);
            path = this.save(node, fileName);
            if (path != null) {
                if (node.isRoot()) {
                    for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                        LaunchPanel tab = (LaunchPanel)this.tabbedPane.getComponentAt(i);
                        if (tab.getRootNode() != node) continue;
                        this.tabbedPane.setTitleAt(i, node.toString());
                        break;
                    }
                }
                Iterator it = clones.keySet().iterator();
                while (it.hasNext()) {
                    LaunchPanel cloneTab = (LaunchPanel)it.next();
                    LaunchNode clone = (LaunchNode)clones.get(cloneTab);
                    clone.setFileName(node.getFileName());
                    if (clone != cloneTab.getRootNode()) continue;
                    int n = this.tabbedPane.indexOfComponent(cloneTab);
                    this.tabbedPane.setTitleAt(n, node.toString());
                }
                if (this.tabSetName != null) {
                    this.changedFiles.add(this.tabSetName);
                }
            }
            return path;
        }
        return null;
    }

    public boolean saveOwnedNodes(LaunchNode node) {
        if (node == null) {
            return false;
        }
        if (node.isSelfContained()) {
            return true;
        }
        LaunchNode[] nodes = node.getChildOwnedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].getChildOwnedNodes().length > 1 && !this.saveOwnedNodes(nodes[i])) {
                return false;
            }
            if (this.save(nodes[i], nodes[i].getFileName()) != null) continue;
            return false;
        }
        return true;
    }

    protected String saveTabSetAs() {
        this.saver.setBuilder(this);
        ((Component)this.saver).setVisible(true);
        if (!this.saver.isApproved()) {
            return null;
        }
        return this.saveTabSet();
    }

    protected String saveTabSet() {
        if (this.tabSetName.trim().equals("")) {
            return this.saveTabSetAs();
        }
        if (!this.isTabSetWritable()) {
            return this.saveTabSetAs();
        }
        if (!this.selfContained && !this.saveTabs()) {
            return null;
        }
        String fileName = XML.getResolvedPath(this.tabSetName, Launcher.tabSetBasePath);
        OSPLog.fine(fileName);
        File file = new File(fileName);
        fileName = XML.forwardSlash(file.getAbsolutePath());
        String path = XML.getDirectoryPath(fileName);
        XML.createFolders(path);
        Launcher.LaunchSet tabset = new Launcher.LaunchSet(this, this, this.tabSetName);
        XMLControlElement control = new XMLControlElement(tabset);
        if (control.write(fileName) == null) {
            return null;
        }
        this.changedFiles.clear();
        this.jarBasePath = null;
        if (this.spawner != null) {
            this.spawner.open(fileName);
            this.spawner.refreshGUI();
        }
        return fileName;
    }

    protected boolean saveTabs() {
        Component[] tabs = this.tabbedPane.getComponents();
        for (int i = 0; i < tabs.length; ++i) {
            LaunchPanel tab = (LaunchPanel)tabs[i];
            LaunchNode root = tab.getRootNode();
            if (root.getFileName() == null || root.getFileName().equals("")) continue;
            this.save(root, XML.getResolvedPath(root.getFileName(), Launcher.tabSetBasePath));
        }
        return true;
    }

    protected void refreshSelectedNode() {
        this.refreshNode(this.getSelectedNode());
    }

    protected void refreshNode(LaunchNode node) {
        boolean changed = false;
        if (node != null) {
            LaunchNode root;
            boolean change;
            String className;
            String input;
            String jarPath;
            LaunchNode parent;
            if (node.isSingleVM() != this.singleVMCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeVM"));
                parent = (LaunchNode)node.getParent();
                if (parent != null && parent.isSingleVM()) {
                    node.singleVM = false;
                    node.singleVMOff = !this.singleVMCheckBox.isSelected();
                } else {
                    node.singleVM = this.singleVMCheckBox.isSelected();
                    node.singleVMOff = false;
                }
                if (node.isSingleVM()) {
                    this.showLogCheckBox.setSelected(node.showLog);
                    this.clearLogCheckBox.setSelected(node.clearLog);
                    this.singleAppCheckBox.setSelected(node.isSingleApp());
                } else {
                    this.singletonCheckBox.setSelected(node.singleton);
                }
                changed = true;
            }
            if (node.isSingleVM() && node.showLog != this.showLogCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeShowLog"));
                node.showLog = this.showLogCheckBox.isSelected();
                changed = true;
            }
            if (node.isSingleVM() && node.isShowLog() && node.clearLog != this.clearLogCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeClearLog"));
                node.clearLog = this.clearLogCheckBox.isSelected();
                changed = true;
            }
            if (node.isSingleVM() && node.isSingleApp() != this.singleAppCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeSingleApp"));
                parent = (LaunchNode)node.getParent();
                if (parent != null && parent.isSingleApp()) {
                    node.singleApp = false;
                    node.singleAppOff = !this.singleAppCheckBox.isSelected();
                } else {
                    node.singleApp = this.singleAppCheckBox.isSelected();
                    node.singleAppOff = false;
                }
                changed = true;
            }
            if (node.singleton != this.singletonCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeSingleton"));
                node.singleton = this.singletonCheckBox.isSelected();
                changed = true;
            }
            if (node.hiddenInLauncher != this.hiddenCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeHidden"));
                node.hiddenInLauncher = this.hiddenCheckBox.isSelected();
                changed = true;
            }
            if (node.isButtonView() != this.buttonViewCheckBox.isSelected()) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeButtonView"));
                node.setButtonView(this.buttonViewCheckBox.isSelected());
                changed = true;
            }
            if (!node.name.equals(this.nameField.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeName"));
                node.name = this.nameField.getText();
                changed = true;
            }
            if (!node.tooltip.equals(this.tooltipField.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeTooltip"));
                node.tooltip = this.tooltipField.getText();
                changed = true;
            }
            if (!node.description.equals(this.descriptionPane.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeDesc"));
                node.description = this.descriptionPane.getText();
                changed = true;
            }
            int n = (Integer)this.argSpinner.getValue();
            String arg = this.argField.getText();
            if (!arg.equals("")) {
                node.setMinimumArgLength(n + 1);
            }
            if (node.args.length > n && !arg.equals(node.args[n])) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeArgs") + " " + n);
                node.args[n] = arg;
                if (arg.equals("")) {
                    node.setMinimumArgLength(1);
                }
                changed = true;
            }
            if ((jarPath = this.jarField.getText()).equals("") && node.classPath != null || !jarPath.equals("") && !jarPath.equals(node.classPath)) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodePath"));
                node.setClassPath(jarPath.equals("") ? null : jarPath);
                changed = true;
            }
            if ((input = this.urlField.getText()).equals("")) {
                input = null;
            }
            if (node.urlName != null && !node.urlName.equals(input) || input != null && !input.equals(node.urlName)) {
                node.setURL(input);
                changed = true;
            }
            if ((className = this.classField.getText()).equals("")) {
                if (node.launchClassName != null) {
                    node.launchClassName = null;
                    node.launchClass = null;
                    OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeLaunchClass"));
                    changed = true;
                }
            } else if ((!className.equals(node.launchClassName) || !className.equals("") && node.getLaunchClass() == null) && (change = node.setLaunchClass(className))) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeLaunchClass"));
                changed = true;
            }
            if (!node.getAuthor().equals(this.authorField.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeAuthor"));
                node.author = this.authorField.getText();
                changed = true;
            }
            if (!node.keywords.equals(this.keywordField.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeKeywords"));
                node.keywords = this.keywordField.getText();
                changed = true;
            }
            if (!node.comment.equals(this.commentPane.getText())) {
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeComment"));
                node.comment = this.commentPane.getText();
                changed = true;
            }
            if ((root = (LaunchNode)node.getRoot()) != null) {
                boolean edit;
                boolean hide = this.hideRootCheckBox.isSelected();
                if (hide != root.hiddenWhenRoot) {
                    root.hiddenWhenRoot = hide;
                    OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeRootHidden"));
                    changed = true;
                }
                if ((edit = this.editorEnabledCheckBox.isSelected()) != this.editorEnabled) {
                    this.editorEnabled = edit;
                    OSPLog.finest(LaunchRes.getString("Log.Message.ChangeNodeEditorEnabled"));
                    if (this.tabSetName != null) {
                        this.changedFiles.add(this.tabSetName);
                    }
                    this.refreshGUI();
                }
            }
            if (changed) {
                OSPLog.fine(LaunchRes.getString("Log.Message.ChangeNode") + " \"" + node.toString() + "\"");
                LaunchPanel tab = this.getSelectedTab();
                if (tab != null) {
                    tab.treeModel.nodeChanged(node);
                }
                if (node.getOwner() != null) {
                    this.changedFiles.add(node.getOwner().getFileName());
                } else {
                    this.changedFiles.add(this.tabSetName);
                }
                this.refreshClones(node);
                this.refreshGUI();
            }
        }
    }

    protected boolean addTab(LaunchNode root) {
        OSPLog.finest(root.toString());
        boolean added = super.addTab(root);
        if (added) {
            LaunchPanel tab = this.getSelectedTab();
            tab.showText = false;
            tab.textPane.setText(null);
            if (this.tabSetName == null) {
                this.tabSetName = LaunchRes.getString("Tabset.Name.New");
            }
            this.changedFiles.add(this.tabSetName);
            this.refreshGUI();
        }
        return added;
    }

    protected boolean removeSelectedTab() {
        if (this.tabbedPane.getTabCount() == 1) {
            boolean allRemoved;
            Launcher.LinkEdit edit = null;
            if (this.tabSetName != null && new File(this.tabSetName).exists()) {
                String[] args = new String[]{" "};
                edit = new Launcher.LinkEdit((Launcher)this, args);
            }
            if ((allRemoved = this.removeAllTabs()) && edit != null) {
                this.undoSupport.postEdit(edit);
            }
            return allRemoved;
        }
        LaunchPanel tab = (LaunchPanel)this.tabbedPane.getSelectedComponent();
        if (tab != null && !this.saveChanges(tab)) {
            return false;
        }
        boolean removed = super.removeSelectedTab();
        if (this.tabSetName != null) {
            this.changedFiles.add(this.tabSetName);
            this.refreshGUI();
        }
        return removed;
    }

    protected boolean saveChanges(LaunchPanel tab) {
        LaunchNode root = tab.getRootNode();
        int n = this.tabbedPane.indexOfComponent(tab);
        String name = n > -1 ? this.tabbedPane.getTitleAt(n) : Launcher.getDisplayName(root.getFileName());
        boolean changed = this.changedFiles.contains(root.getFileName());
        LaunchNode[] nodes = root.getAllOwnedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            changed = changed || this.changedFiles.contains(nodes[i].getFileName());
        }
        if (changed) {
            int selected = JOptionPane.showConfirmDialog(this.frame, LaunchRes.getString("Dialog.SaveChanges.Tab.Message") + " \"" + name + "\"" + XML.NEW_LINE + LaunchRes.getString("Dialog.SaveChanges.Question"), LaunchRes.getString("Dialog.SaveChanges.Title"), 1);
            if (selected == 2) {
                return false;
            }
            if (selected == 0) {
                this.save(root, root.getFileName());
            }
        }
        return true;
    }

    protected boolean removeAllTabs() {
        if (!this.saveAllChanges()) {
            return false;
        }
        return super.removeAllTabs();
    }

    protected boolean saveAllChanges() {
        if (!this.changedFiles.isEmpty() && this.tabbedPane.getTabCount() > 0) {
            String message = LaunchRes.getString("Dialog.SaveChanges.Tabset.Message");
            int selected = JOptionPane.showConfirmDialog(this.frame, message + "\"" + this.tabSetName + "\"" + XML.NEW_LINE + LaunchRes.getString("Dialog.SaveChanges.Question"), LaunchRes.getString("Dialog.SaveChanges.Title"), 1);
            if (selected == 2) {
                return false;
            }
            if (selected == 0) {
                if (this.tabSetName.equals(LaunchRes.getString("Tabset.Name.New")) || !this.saveAllItem.isEnabled()) {
                    this.saveTabSetAs();
                } else {
                    this.saveTabSet();
                }
            }
        }
        return true;
    }

    protected void refreshStringResources() {
        Rectangle2D rect;
        JLabel next;
        super.refreshStringResources();
        this.saver = new LaunchSaver(this);
        this.editorTabs.setTitleAt(0, LaunchRes.getString("Tab.Display"));
        this.editorTabs.setTitleAt(1, LaunchRes.getString("Tab.Launch"));
        this.editorTabs.setTitleAt(2, LaunchRes.getString("Tab.Author"));
        this.htmlTitle.setTitle(LaunchRes.getString("Label.HTML"));
        this.commentTitle.setTitle(LaunchRes.getString("Label.Comments"));
        this.descriptionTitle.setTitle(LaunchRes.getString("Label.Description"));
        this.optionsTitle.setTitle(LaunchRes.getString("Label.Options"));
        this.hiddenCheckBox.setText(LaunchRes.getString("Checkbox.Hidden"));
        this.buttonViewCheckBox.setText(LaunchRes.getString("Checkbox.ButtonView"));
        this.nameLabel.setText(LaunchRes.getString("Label.Name"));
        this.tooltipLabel.setText(LaunchRes.getString("Label.Tooltip"));
        this.urlLabel.setText(LaunchRes.getString("Label.URL"));
        this.jarLabel.setText(LaunchRes.getString("Label.Jar"));
        this.classLabel.setText(LaunchRes.getString("Label.Class"));
        this.argLabel.setText(LaunchRes.getString("Label.Args"));
        this.singleVMCheckBox.setText(LaunchRes.getString("Checkbox.SingleVM"));
        this.showLogCheckBox.setText(LaunchRes.getString("Checkbox.ShowLog"));
        this.clearLogCheckBox.setText(LaunchRes.getString("Checkbox.ClearLog"));
        this.singletonCheckBox.setText(LaunchRes.getString("Checkbox.Singleton"));
        this.singleAppCheckBox.setText(LaunchRes.getString("Checkbox.SingleApp"));
        this.authorLabel.setText(LaunchRes.getString("Label.Author"));
        this.keywordLabel.setText(LaunchRes.getString("Label.Keywords"));
        this.securityTitle.setTitle(LaunchRes.getString("Label.Security"));
        this.editorEnabledCheckBox.setText(LaunchRes.getString("Checkbox.EditorEnabled"));
        this.encryptCheckBox.setText(LaunchRes.getString("Checkbox.Encrypted"));
        this.passwordLabel.setText(LaunchRes.getString("Label.Password"));
        this.onLoadCheckBox.setText(LaunchRes.getString("Checkbox.PWLoad"));
        this.titleLabel.setText(LaunchRes.getString("Label.Title"));
        this.hideRootCheckBox.setText(LaunchRes.getString("Checkbox.HideRoot"));
        this.previewItem.setText(LaunchRes.getString("Menu.File.Preview"));
        this.encryptionToolItem.setText(LaunchRes.getString("MenuItem.EncryptionTool"));
        this.newItem.setText(LaunchRes.getString("Menu.File.New"));
        this.importItem.setText(LaunchRes.getString("Action.Import"));
        this.saveNodeItem.setText(LaunchRes.getString("Action.SaveNode"));
        this.saveNodeAsItem.setText(LaunchRes.getString("Action.SaveNodeAs"));
        this.saveAllItem.setText(LaunchRes.getString("Action.SaveAll"));
        this.openTabItem.setText(LaunchRes.getString("Action.OpenTab"));
        this.saveSetAsItem.setText(LaunchRes.getString("Action.SaveSetAs"));
        this.toolsMenu.setText(LaunchRes.getString("Menu.Tools"));
        this.newTabButton.setText(LaunchRes.getString("Action.New"));
        this.addButton.setText(LaunchRes.getString("Action.Add"));
        this.cutButton.setText(LaunchRes.getString("Action.Cut"));
        this.copyButton.setText(LaunchRes.getString("Action.Copy"));
        this.pasteButton.setText(LaunchRes.getString("Action.Paste"));
        this.moveUpButton.setText(LaunchRes.getString("Action.Up"));
        this.moveDownButton.setText(LaunchRes.getString("Action.Down"));
        this.labels.clear();
        this.labels.add(this.nameLabel);
        this.labels.add(this.tooltipLabel);
        this.labels.add(this.urlLabel);
        FontRenderContext frc = new FontRenderContext(null, false, false);
        Font font = this.nameLabel.getFont();
        int w = 0;
        Iterator it = ((AbstractList)this.labels).iterator();
        while (it.hasNext()) {
            JLabel next2 = (JLabel)it.next();
            Rectangle2D rect2 = font.getStringBounds(next2.getText() + " ", frc);
            w = Math.max(w, (int)rect2.getWidth() + 1);
        }
        Dimension labelSize = new Dimension(w, 20);
        Iterator it2 = ((AbstractList)this.labels).iterator();
        while (it2.hasNext()) {
            next = (JLabel)it2.next();
            next.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            next.setPreferredSize(labelSize);
            next.setHorizontalAlignment(11);
        }
        this.labels.clear();
        this.labels.add(this.jarLabel);
        this.labels.add(this.classLabel);
        this.labels.add(this.argLabel);
        w = 0;
        it2 = ((AbstractList)this.labels).iterator();
        while (it2.hasNext()) {
            next = (JLabel)it2.next();
            rect = font.getStringBounds(next.getText() + " ", frc);
            w = Math.max(w, (int)rect.getWidth() + 1);
        }
        labelSize = new Dimension(w, 20);
        it2 = ((AbstractList)this.labels).iterator();
        while (it2.hasNext()) {
            next = (JLabel)it2.next();
            next.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            next.setPreferredSize(labelSize);
            next.setHorizontalAlignment(11);
        }
        this.labels.clear();
        this.labels.add(this.authorLabel);
        this.labels.add(this.keywordLabel);
        w = 0;
        it2 = ((AbstractList)this.labels).iterator();
        while (it2.hasNext()) {
            next = (JLabel)it2.next();
            rect = font.getStringBounds(next.getText() + " ", frc);
            w = Math.max(w, (int)rect.getWidth() + 1);
        }
        labelSize = new Dimension(w, 20);
        it2 = ((AbstractList)this.labels).iterator();
        while (it2.hasNext()) {
            next = (JLabel)it2.next();
            next.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            next.setPreferredSize(labelSize);
            next.setHorizontalAlignment(11);
        }
    }

    protected void refreshGUI() {
        if (this.previousNode != null) {
            LaunchNode prev = this.previousNode;
            this.previousNode = null;
            this.refreshNode(prev);
        }
        if (this.newNodeSelected) {
            this.argSpinner.setValue(new Integer(0));
            this.newNodeSelected = false;
        }
        this.titleField.setText(this.title);
        this.titleField.setBackground(Color.white);
        super.refreshGUI();
        String theTitle = this.frame.getTitle();
        if (this.title != null) {
            theTitle = !this.changedFiles.isEmpty() ? theTitle + " [" + this.tabSetName + "*]" : theTitle + " [" + this.tabSetName + "]";
        } else if (!this.changedFiles.isEmpty()) {
            if (this.tabbedPane.getTabCount() == 0) {
                this.changedFiles.clear();
            } else {
                theTitle = theTitle + "*";
            }
        }
        this.frame.setTitle(theTitle);
        LaunchNode node = this.getSelectedNode();
        if (node != null) {
            String path;
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                LaunchNode root = this.getTab(i).getRootNode();
                this.tabbedPane.setTitleAt(i, root.toString());
            }
            this.hiddenCheckBox.setSelected(node.isHiddenInLauncher());
            boolean parentHidden = node.getParent() != null && ((LaunchNode)node.getParent()).isHiddenInLauncher();
            this.hiddenCheckBox.setEnabled(!parentHidden);
            this.nameField.setText(node.toString());
            this.nameField.setBackground(Color.white);
            this.tooltipField.setText(node.tooltip);
            this.tooltipField.setBackground(Color.white);
            this.descriptionPane.setText(node.description);
            this.descriptionPane.setBackground(Color.white);
            this.urlField.setText(node.urlName);
            this.urlField.setBackground(node.url == null && node.urlName != null ? RED : Color.white);
            JEditorPane html = this.getSelectedTab().textPane;
            if (node.url != null && html.getPage() != node.url) {
                try {
                    if (node.url.getContent() != null) {
                        html.setPage(node.url);
                    }
                }
                catch (IOException ex) {
                    html.setText(null);
                }
            } else if (node.url == null) {
                if (LaunchPanel.defaultType != null) {
                    html.setContentType(LaunchPanel.defaultType);
                }
                html.setText(null);
            }
            if (!(path = node.getClassPath()).equals(this.previousClassPath)) {
                boolean success = this.getClassChooser().setPath(path);
                this.searchJarAction.setEnabled(success);
            }
            this.previousClassPath = node.getClassPath();
            this.jarField.setText(node.classPath);
            this.jarField.setBackground(node.classPath != null && !this.getClassChooser().isLoaded(node.classPath) ? RED : Color.white);
            this.classField.setText(node.launchClassName);
            this.classField.setBackground(node.getLaunchClass() == null && node.launchClassName != null ? RED : Color.white);
            int n = (Integer)this.argSpinner.getValue();
            if (node.args.length > n) {
                this.argField.setText(node.args[n]);
            } else {
                this.argField.setText("");
            }
            boolean xmlArg = this.argField.getText().endsWith(".xml");
            Resource res = null;
            if (xmlArg) {
                res = ResourceLoader.getResource(this.argField.getText());
                this.argField.setBackground(res == null ? RED : Color.white);
            } else {
                this.argField.setBackground(Color.white);
            }
            LaunchNode parent = (LaunchNode)node.getParent();
            this.singletonCheckBox.setEnabled(parent == null || !parent.isSingleton());
            this.singletonCheckBox.setSelected(node.isSingleton());
            this.singleVMCheckBox.setSelected(node.isSingleVM());
            if (node.isSingleVM()) {
                this.showLogCheckBox.setEnabled(parent == null || !parent.isShowLog());
                this.showLogCheckBox.setSelected(node.isShowLog());
                this.clearLogCheckBox.setEnabled(parent == null || !parent.isClearLog());
                this.clearLogCheckBox.setSelected(node.isClearLog());
                this.singleAppCheckBox.setEnabled(true);
                this.singleAppCheckBox.setSelected(node.isSingleApp());
            } else {
                this.showLogCheckBox.setEnabled(false);
                this.showLogCheckBox.setSelected(false);
                this.clearLogCheckBox.setEnabled(false);
                this.clearLogCheckBox.setSelected(false);
                this.singleAppCheckBox.setEnabled(false);
                this.singleAppCheckBox.setSelected(false);
            }
            this.levelDropDown.setVisible(node.isShowLog());
            this.clearLogCheckBox.setVisible(node.isShowLog());
            if (this.levelDropDown.isVisible()) {
                boolean useAll = parent == null || !parent.isShowLog();
                this.levelDropDown.setEnabled(false);
                this.levelDropDown.removeAllItems();
                for (int i = 0; i < OSPLog.levels.length; ++i) {
                    if (!useAll && OSPLog.levels[i].intValue() > parent.getLogLevel().intValue()) continue;
                    this.levelDropDown.addItem(OSPLog.levels[i]);
                }
                this.levelDropDown.setSelectedItem(node.getLogLevel());
                this.levelDropDown.setEnabled(true);
            }
            this.authorField.setText(node.getAuthor());
            this.authorField.setBackground(Color.white);
            this.keywordField.setText(node.keywords);
            this.keywordField.setBackground(Color.white);
            this.commentPane.setText(node.comment);
            this.commentPane.setBackground(Color.white);
            boolean hasPW = this.password != null && !this.password.equals("");
            this.onLoadCheckBox.setEnabled(hasPW);
            this.onLoadCheckBox.setSelected(hasPW && this.pwRequiredToLoad);
            this.encryptCheckBox.setSelected(this.password != null);
            this.passwordEditor.setEnabled(this.encryptCheckBox.isSelected());
            this.passwordLabel.setEnabled(this.encryptCheckBox.isSelected());
            this.passwordEditor.setText(this.password);
            this.passwordEditor.setBackground(Color.white);
        }
        this.fileMenu.removeAll();
        this.fileMenu.add(this.newItem);
        if (this.undoManager.canUndo()) {
            this.fileMenu.add(this.backItem);
        }
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.openItem);
        if (this.openFromJarMenu != null) {
            this.fileMenu.add(this.openFromJarMenu);
        }
        LaunchPanel tab = this.getSelectedTab();
        boolean isZipped = this.jarBasePath != null && !this.jarBasePath.equals("");
        this.saveAllItem.setEnabled(!isZipped && this.isTabSetWritable());
        if (tab != null) {
            this.fileMenu.add(this.importItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.closeTabItem);
            this.fileMenu.add(this.closeAllItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.previewItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.saveAllItem);
            this.fileMenu.add(this.saveSetAsItem);
            this.frame.getContentPane().add((Component)this.toolbar, "North");
            tab.dataPanel.add((Component)this.editorTabs, "Center");
            tab.textScroller.setBorder(this.htmlTitle);
            this.displaySplitPane.setTopComponent(tab.textScroller);
            if (this.getRootNode().getChildCount() == 0) {
                this.getRootNode().hiddenWhenRoot = false;
                this.hideRootCheckBox.setEnabled(false);
            } else {
                this.hideRootCheckBox.setEnabled(node == null || !node.isButtonView());
            }
            boolean rootVisible = !this.getRootNode().hiddenWhenRoot;
            this.hideRootCheckBox.setSelected(!rootVisible);
            tab.tree.setRootVisible(rootVisible);
            if (this.getSelectedNode() == null && !rootVisible) {
                tab.setSelectedNode((LaunchNode)this.getRootNode().getChildAt(0));
            }
            this.buttonViewCheckBox.setSelected(node != null && node.isButtonView());
            this.buttonViewCheckBox.setEnabled(rootVisible);
            this.editorEnabledCheckBox.setSelected(this.editorEnabled);
        } else {
            this.frame.getContentPane().remove(this.toolbar);
        }
        if (this.exitItem != null) {
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.exitItem);
        }
        for (int k = 0; k < this.tabbedPane.getTabCount(); ++k) {
            LaunchNode root = this.getTab(k).getRootNode();
            if (root.getFileName() != null) {
                this.tabbedPane.setIconAt(k, this.getFileIcon(root));
                this.tabbedPane.setToolTipTextAt(k, LaunchRes.getString("ToolTip.FileName") + " \"" + root.getFileName() + "\"");
                continue;
            }
            this.tabbedPane.setIconAt(k, null);
            this.tabbedPane.setToolTipTextAt(k, null);
        }
    }

    protected void createGUI(boolean splash) {
        Launcher.wInit = 600;
        Launcher.hInit = 540;
        this.labels = new ArrayList();
        super.createGUI(splash);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent e) {
                OSPFrame.setAuthorMode(true);
            }

            public void windowActivated(WindowEvent e) {
                OSPFrame.setAuthorMode(true);
            }

            public void windowOpened(WindowEvent e) {
                if (LaunchBuilder.this.getSelectedNode() != null) {
                    LaunchBuilder.this.getSelectedTab().textPane.setContentType(LaunchPanel.defaultType);
                    LaunchBuilder.this.getSelectedTab().textPane.setText(null);
                    LaunchBuilder.this.refreshGUI();
                }
            }
        });
        this.tabbedPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                LaunchBuilder.this.refreshGUI();
            }
        });
        String imageFile = "/org/opensourcephysics/resources/tools/images/whitefile.gif";
        Launcher.whiteFileIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/ghostfile.gif";
        Launcher.ghostFileIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/redfile.gif";
        Launcher.redFileIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/yellowfile.gif";
        Launcher.yellowFileIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/whitefolder.gif";
        Launcher.whiteFolderIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/redfolder.gif";
        Launcher.redFolderIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/greenfolder.gif";
        Launcher.greenFolderIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/yellowfolder.gif";
        Launcher.yellowFolderIcon = ResourceLoader.getIcon(imageFile);
        this.createActions();
        this.titleField = new JTextField();
        this.titleField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String text = LaunchBuilder.this.titleField.getText();
                    if (text.equals("")) {
                        text = null;
                    }
                    if (text != LaunchBuilder.this.title) {
                        LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                    }
                    LaunchBuilder.this.title = text;
                    LaunchBuilder.this.refreshGUI();
                } else {
                    LaunchBuilder.this.titleField.setBackground(Color.yellow);
                }
            }
        });
        this.titleField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String text = LaunchBuilder.this.titleField.getText();
                if (text.equals("")) {
                    text = null;
                }
                if (text != LaunchBuilder.this.title) {
                    LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                }
                LaunchBuilder.this.title = text;
                LaunchBuilder.this.refreshGUI();
            }
        });
        this.nameField = new JTextField();
        this.nameField.addKeyListener(this.keyListener);
        this.nameField.addFocusListener(this.focusListener);
        this.tooltipField = new JTextField();
        this.tooltipField.addKeyListener(this.keyListener);
        this.tooltipField.addFocusListener(this.focusListener);
        this.htmlTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.HTML"));
        this.classField = new JTextField();
        this.classField.addKeyListener(this.keyListener);
        this.classField.addFocusListener(this.focusListener);
        this.argField = new JTextField();
        this.argField.addKeyListener(this.keyListener);
        this.argField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                XMLControlElement control;
                if ((e.isPopupTrigger() || e.getButton() == 3 || e.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1) && (control = new XMLControlElement()).read(LaunchBuilder.this.argField.getText()) != null) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item = new JMenuItem(LaunchRes.getString("MenuItem.EncryptionTool"));
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            EncryptionTool tool = EncryptionTool.getTool();
                            tool.open((this).LaunchBuilder.this.argField.getText());
                            tool.setVisible(true);
                        }
                    });
                    popup.add(item);
                    popup.show(LaunchBuilder.this.argField, e.getX(), e.getY() + 8);
                }
            }
        });
        this.argField.addFocusListener(this.focusListener);
        this.jarField = new JTextField();
        this.jarField.addKeyListener(this.keyListener);
        this.jarField.addFocusListener(this.focusListener);
        this.urlField = new JTextField();
        this.urlField.addKeyListener(this.keyListener);
        this.urlField.addFocusListener(this.focusListener);
        this.keywordField = new JTextField();
        this.keywordField.addKeyListener(this.keyListener);
        this.keywordField.addFocusListener(this.focusListener);
        this.authorField = new JTextField();
        this.authorField.addKeyListener(this.keyListener);
        this.authorField.addFocusListener(this.focusListener);
        this.commentPane = new JTextPane();
        this.commentPane.addKeyListener(this.keyListener);
        this.commentPane.addFocusListener(this.focusListener);
        this.commentScroller = new JScrollPane(this.commentPane);
        this.commentTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Comments"));
        this.commentScroller.setBorder(this.commentTitle);
        this.descriptionPane = new JTextPane();
        this.descriptionPane.addKeyListener(this.keyListener);
        this.descriptionPane.addFocusListener(this.focusListener);
        this.descriptionScroller = new JScrollPane(this.descriptionPane);
        this.descriptionTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Description"));
        this.descriptionScroller.setBorder(this.descriptionTitle);
        this.displaySplitPane = new JSplitPane(0){

            public void setDividerLocation(int loc) {
                super.setDividerLocation(loc);
                double divider = this.getDividerLocation();
                this.setName("" + (divider /= (double)(this.getHeight() - this.getDividerSize())));
            }

            public void setTopComponent(Component comp) {
                int prev = this.getLastDividerLocation();
                String divider = this.getName();
                super.setTopComponent(comp);
                if (divider != null) {
                    double loc = Double.parseDouble(divider);
                    loc = Math.max(0.0, loc);
                    loc = Math.min(1.0, loc);
                    this.setDividerLocation(loc);
                    this.setLastDividerLocation(prev);
                    Runnable runner = new Runnable(){

                        public void run() {
                            JViewport view = (this).LaunchBuilder.this.descriptionScroller.getViewport();
                            view.setViewPosition(new Point(0, 0));
                        }
                    };
                    SwingUtilities.invokeLater(runner);
                }
            }
        };
        this.displaySplitPane.setBottomComponent(this.descriptionScroller);
        this.displaySplitPane.setOneTouchExpandable(true);
        this.displaySplitPane.setResizeWeight(0.5);
        this.hiddenCheckBox = new JCheckBox();
        this.hiddenCheckBox.addActionListener(this.changeAction);
        this.hiddenCheckBox.setContentAreaFilled(false);
        this.hiddenCheckBox.setAlignmentX(0.0f);
        this.buttonViewCheckBox = new JCheckBox();
        this.buttonViewCheckBox.addActionListener(this.changeAction);
        this.buttonViewCheckBox.setContentAreaFilled(false);
        this.buttonViewCheckBox.setAlignmentX(0.0f);
        JPanel displayPanel = new JPanel(new BorderLayout());
        JToolBar nameBar = new JToolBar();
        nameBar.setFloatable(false);
        this.nameLabel = new JLabel();
        this.labels.add(this.nameLabel);
        nameBar.add(this.nameLabel);
        nameBar.add(this.nameField);
        nameBar.add(this.hiddenCheckBox);
        displayPanel.add((Component)nameBar, "North");
        JPanel tooltipPanel = new JPanel(new BorderLayout());
        displayPanel.add((Component)tooltipPanel, "Center");
        JToolBar tooltipBar = new JToolBar();
        tooltipBar.setFloatable(false);
        this.tooltipLabel = new JLabel();
        this.labels.add(this.tooltipLabel);
        tooltipBar.add(this.tooltipLabel);
        tooltipBar.add(this.tooltipField);
        tooltipPanel.add((Component)tooltipBar, "North");
        this.urlPanel = new JPanel(new BorderLayout());
        tooltipPanel.add((Component)this.urlPanel, "Center");
        JToolBar urlBar = new JToolBar();
        urlBar.setFloatable(false);
        this.urlLabel = new JLabel();
        this.labels.add(this.urlLabel);
        urlBar.add(this.urlLabel);
        urlBar.add(this.urlField);
        urlBar.add(this.openURLAction);
        this.urlPanel.add((Component)urlBar, "North");
        this.urlPanel.add((Component)this.displaySplitPane, "Center");
        JPanel launchPanel = new JPanel(new BorderLayout());
        JToolBar jarBar = new JToolBar();
        jarBar.setFloatable(false);
        this.jarLabel = new JLabel();
        this.labels.add(this.jarLabel);
        jarBar.add(this.jarLabel);
        jarBar.add(this.jarField);
        jarBar.add(this.openJarAction);
        launchPanel.add((Component)jarBar, "North");
        JPanel classPanel = new JPanel(new BorderLayout());
        launchPanel.add((Component)classPanel, "Center");
        JToolBar classBar = new JToolBar();
        classBar.setFloatable(false);
        this.classLabel = new JLabel();
        this.labels.add(this.classLabel);
        classBar.add(this.classLabel);
        classBar.add(this.classField);
        classBar.add(this.searchJarAction);
        classPanel.add((Component)classBar, "North");
        JPanel argPanel = new JPanel(new BorderLayout());
        classPanel.add((Component)argPanel, "Center");
        JToolBar argBar = new JToolBar();
        argBar.setFloatable(false);
        this.argLabel = new JLabel();
        this.labels.add(this.argLabel);
        argBar.add(this.argLabel);
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, maxArgs - 1, 1);
        this.argSpinner = new JSpinner(model);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.argSpinner);
        this.argSpinner.setEditor(editor);
        this.argSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (LaunchBuilder.this.argField.getBackground() == Color.yellow) {
                    LaunchBuilder.this.refreshSelectedNode();
                } else {
                    LaunchBuilder.this.refreshGUI();
                }
            }
        });
        argBar.add(this.argSpinner);
        argBar.add(this.argField);
        argBar.add(this.openArgAction);
        argPanel.add((Component)argBar, "North");
        JPanel optionsPanel = new JPanel(new BorderLayout());
        argPanel.add((Component)optionsPanel, "Center");
        JToolBar optionsBar = new JToolBar();
        optionsBar.setFloatable(false);
        this.singleVMCheckBox = new JCheckBox();
        this.singleVMCheckBox.addActionListener(this.changeAction);
        this.singleVMCheckBox.setContentAreaFilled(false);
        this.singleVMCheckBox.setAlignmentX(0.0f);
        this.showLogCheckBox = new JCheckBox();
        this.showLogCheckBox.addActionListener(this.changeAction);
        this.showLogCheckBox.setContentAreaFilled(false);
        this.showLogCheckBox.setAlignmentX(0.0f);
        this.clearLogCheckBox = new JCheckBox();
        this.clearLogCheckBox.addActionListener(this.changeAction);
        this.clearLogCheckBox.setContentAreaFilled(false);
        this.clearLogCheckBox.setAlignmentX(0.0f);
        this.singletonCheckBox = new JCheckBox();
        this.singletonCheckBox.addActionListener(this.changeAction);
        this.singletonCheckBox.setContentAreaFilled(false);
        this.singletonCheckBox.setAlignmentX(0.0f);
        this.singleAppCheckBox = new JCheckBox();
        this.singleAppCheckBox.addActionListener(this.changeAction);
        this.singleAppCheckBox.setContentAreaFilled(false);
        this.singleAppCheckBox.setAlignmentX(0.0f);
        this.levelDropDown = new JComboBox<Level>(OSPLog.levels);
        this.levelDropDown.setMaximumSize(this.levelDropDown.getMinimumSize());
        this.levelDropDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LaunchNode node;
                if (LaunchBuilder.this.levelDropDown.isEnabled() && (node = LaunchBuilder.this.getSelectedNode()) != null) {
                    node.setLogLevel((Level)LaunchBuilder.this.levelDropDown.getSelectedItem());
                }
            }
        });
        Box checkBoxPanel = Box.createVerticalBox();
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        bar.add(this.singletonCheckBox);
        bar.add(Box.createHorizontalGlue());
        checkBoxPanel.add(bar);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        bar.add(this.singleVMCheckBox);
        bar.add(Box.createHorizontalGlue());
        checkBoxPanel.add(bar);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        bar.add(this.singleAppCheckBox);
        bar.add(Box.createHorizontalGlue());
        checkBoxPanel.add(bar);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.add(this.showLogCheckBox);
        bar.add(Box.createHorizontalStrut(4));
        bar.add(this.levelDropDown);
        bar.add(Box.createHorizontalStrut(4));
        bar.add(this.clearLogCheckBox);
        bar.add(Box.createHorizontalGlue());
        bar.setAlignmentX(0.0f);
        checkBoxPanel.add(bar);
        this.optionsTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Options"));
        Border recess = BorderFactory.createLoweredBevelBorder();
        optionsBar.setBorder(BorderFactory.createCompoundBorder(recess, this.optionsTitle));
        optionsBar.add(checkBoxPanel);
        optionsPanel.add((Component)optionsBar, "North");
        JPanel authorPanel = new JPanel(new BorderLayout());
        JToolBar authorBar = new JToolBar();
        authorPanel.add((Component)authorBar, "North");
        authorBar.setFloatable(false);
        this.authorLabel = new JLabel();
        this.labels.add(this.authorLabel);
        authorBar.add(this.authorLabel);
        authorBar.add(this.authorField);
        JPanel keywordPanel = new JPanel(new BorderLayout());
        authorPanel.add((Component)keywordPanel, "Center");
        JToolBar keywordBar = new JToolBar();
        keywordPanel.add((Component)keywordBar, "North");
        keywordBar.setFloatable(false);
        this.keywordLabel = new JLabel();
        this.labels.add(this.keywordLabel);
        keywordBar.add(this.keywordLabel);
        keywordBar.add(this.keywordField);
        JPanel securityPanel = new JPanel(new BorderLayout());
        keywordPanel.add((Component)securityPanel, "Center");
        JToolBar securityBar = new JToolBar();
        securityBar.setFloatable(false);
        securityPanel.add((Component)securityBar, "North");
        this.securityTitle = BorderFactory.createTitledBorder(LaunchRes.getString("Label.Security"));
        securityBar.setBorder(BorderFactory.createCompoundBorder(recess, this.securityTitle));
        Box securityBox = Box.createVerticalBox();
        securityBar.add(securityBox);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        this.editorEnabledCheckBox = new JCheckBox();
        this.editorEnabledCheckBox.addActionListener(this.changeAction);
        this.editorEnabledCheckBox.setContentAreaFilled(false);
        this.editorEnabledCheckBox.setAlignmentX(0.0f);
        bar.add(this.editorEnabledCheckBox);
        bar.add(Box.createHorizontalGlue());
        securityBox.add(bar);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        this.encryptCheckBox = new JCheckBox();
        this.encryptCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (LaunchBuilder.this.encryptCheckBox.isSelected() && LaunchBuilder.this.password == null) {
                    LaunchBuilder.this.password = "";
                } else if (!LaunchBuilder.this.encryptCheckBox.isSelected()) {
                    LaunchBuilder.this.password = null;
                }
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangeEncrypted"));
                if (LaunchBuilder.this.tabSetName != null) {
                    LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                }
                LaunchBuilder.this.refreshGUI();
            }
        });
        this.encryptCheckBox.setContentAreaFilled(false);
        bar.add(this.encryptCheckBox);
        bar.add(Box.createHorizontalGlue());
        securityBox.add(bar);
        bar = new JToolBar();
        bar.setFloatable(false);
        bar.setAlignmentX(0.0f);
        this.passwordLabel = new JLabel();
        this.passwordLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        bar.add(this.passwordLabel);
        this.passwordEditor = new JTextField();
        this.passwordEditor.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String text = LaunchBuilder.this.passwordEditor.getText();
                    if (!(!text.equals("") || LaunchBuilder.this.encryptCheckBox.isSelected() && LaunchBuilder.this.encryptCheckBox.isEnabled())) {
                        text = null;
                    }
                    if (text != LaunchBuilder.this.password) {
                        LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                    }
                    LaunchBuilder.this.password = text;
                    LaunchBuilder.this.refreshGUI();
                } else {
                    LaunchBuilder.this.passwordEditor.setBackground(Color.yellow);
                }
            }
        });
        bar.add(this.passwordEditor);
        bar.add(Box.createHorizontalGlue());
        this.onLoadCheckBox = new JCheckBox();
        this.onLoadCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LaunchBuilder.this.pwRequiredToLoad = LaunchBuilder.this.onLoadCheckBox.isSelected();
                OSPLog.finest(LaunchRes.getString("Log.Message.ChangePWRequirement"));
                if (LaunchBuilder.this.tabSetName != null) {
                    LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                }
                LaunchBuilder.this.refreshGUI();
            }
        });
        this.onLoadCheckBox.setContentAreaFilled(false);
        bar.add(this.onLoadCheckBox);
        securityBox.add(bar);
        securityPanel.add((Component)this.commentScroller, "Center");
        this.editorTabs = new JTabbedPane(1);
        this.editorTabs.addTab(LaunchRes.getString("Tab.Display"), displayPanel);
        this.editorTabs.addTab(LaunchRes.getString("Tab.Launch"), launchPanel);
        this.editorTabs.addTab(LaunchRes.getString("Tab.Author"), authorPanel);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.frame.getContentPane().add((Component)this.toolbar, "North");
        this.newTabButton = new JButton(this.newTabAction);
        this.toolbar.add(this.newTabButton);
        this.addButton = new JButton(this.addAction);
        this.toolbar.add(this.addButton);
        this.cutButton = new JButton(this.cutAction);
        this.toolbar.add(this.cutButton);
        this.copyButton = new JButton(this.copyAction);
        this.toolbar.add(this.copyButton);
        this.pasteButton = new JButton(this.pasteAction);
        this.toolbar.add(this.pasteButton);
        this.moveUpButton = new JButton(this.moveUpAction);
        this.toolbar.add(this.moveUpButton);
        this.moveDownButton = new JButton(this.moveDownAction);
        this.toolbar.add(this.moveDownButton);
        this.titleLabel = new JLabel(LaunchRes.getString("Label.Title"));
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.toolbar.add(this.titleLabel);
        this.toolbar.add(this.titleField);
        this.toolbar.add(this.buttonViewCheckBox);
        this.hideRootCheckBox = new JCheckBox();
        this.hideRootCheckBox.addActionListener(this.changeAction);
        this.hideRootCheckBox.setContentAreaFilled(false);
        this.toolbar.add(this.hideRootCheckBox);
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.newItem = new JMenuItem(this.newTabSetAction);
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, mask));
        this.previewItem = new JMenuItem();
        this.previewItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String base = Launcher.tabSetBasePath;
                LaunchBuilder.this.previewing = true;
                Launcher.LaunchSet set = new Launcher.LaunchSet(LaunchBuilder.this, LaunchBuilder.this, LaunchBuilder.this.tabSetName);
                XMLControlElement control = new XMLControlElement(set);
                control.setValue("filename", LaunchBuilder.this.tabSetName);
                Launcher launcher = new Launcher(control.toXML());
                Point p = LaunchBuilder.this.frame.getLocation();
                ((Component)launcher.frame).setLocation(p.x + 24, p.y + 24);
                ((Component)launcher.frame).setVisible(true);
                launcher.frame.setDefaultCloseOperation(2);
                Launcher.tabSetBasePath = base;
                LaunchBuilder.this.previewing = false;
                launcher.password = LaunchBuilder.this.password;
                launcher.previewing = true;
                launcher.spawner = LaunchBuilder.this;
                launcher.refreshGUI();
            }
        });
        this.importItem = new JMenuItem(this.importAction);
        this.saveNodeItem = new JMenuItem(this.saveAction);
        this.saveNodeAsItem = new JMenuItem(this.saveAsAction);
        this.saveAllItem = new JMenuItem(this.saveAllAction);
        this.openTabItem = new JMenuItem(this.openTabAction);
        this.saveAllItem.setAccelerator(KeyStroke.getKeyStroke(83, mask));
        this.saveSetAsItem = new JMenuItem(this.saveSetAsAction);
        this.toolsMenu = new JMenu();
        this.frame.getJMenuBar().add((Component)this.toolsMenu, 2);
        this.encryptionToolItem = new JMenuItem();
        this.toolsMenu.add(this.encryptionToolItem);
        this.encryptionToolItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncryptionTool.getTool().setVisible(true);
            }
        });
        this.tabbedPane.removeMouseListener(this.tabListener);
        this.tabListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (LaunchBuilder.this.contentPane.getTopLevelAncestor() != LaunchBuilder.this.frame) {
                    return;
                }
                if (e.isPopupTrigger() || e.getButton() == 3 || e.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item = new JMenuItem(LaunchRes.getString("MenuItem.Close"));
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            LaunchBuilder.this.removeSelectedTab();
                        }
                    });
                    popup.add(item);
                    popup.addSeparator();
                    item = new JMenuItem(LaunchRes.getString("Menu.File.SaveAs"));
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            LaunchNode node = LaunchBuilder.this.getSelectedTab().getRootNode();
                            if (LaunchBuilder.this.saveAs(node) != null) {
                                int i = (this).LaunchBuilder.this.tabbedPane.getSelectedIndex();
                                (this).LaunchBuilder.this.tabbedPane.setTitleAt(i, node.toString());
                            }
                            LaunchBuilder.this.refreshGUI();
                        }
                    });
                    popup.add(item);
                    final int i = LaunchBuilder.this.tabbedPane.getSelectedIndex();
                    if (i > 0 || i < LaunchBuilder.this.tabbedPane.getTabCount() - 1) {
                        popup.addSeparator();
                    }
                    if (i < LaunchBuilder.this.tabbedPane.getTabCount() - 1) {
                        item = new JMenuItem(LaunchRes.getString("Popup.MenuItem.MoveUp"));
                        item.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                LaunchPanel tab = LaunchBuilder.this.getSelectedTab();
                                LaunchNode root = tab.getRootNode();
                                LaunchBuilder.super.removeSelectedTab();
                                (this).LaunchBuilder.this.tabbedPane.insertTab(Launcher.getDisplayName(root.getFileName()), null, tab, null, i + 1);
                                (this).LaunchBuilder.this.tabbedPane.setSelectedComponent(tab);
                                (this).LaunchBuilder.this.tabs.add(i + 1, tab);
                            }
                        });
                        popup.add(item);
                    }
                    if (i > 0) {
                        item = new JMenuItem(LaunchRes.getString("Popup.MenuItem.MoveDown"));
                        item.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                LaunchPanel tab = LaunchBuilder.this.getSelectedTab();
                                LaunchNode root = tab.getRootNode();
                                LaunchBuilder.super.removeSelectedTab();
                                (this).LaunchBuilder.this.tabbedPane.insertTab(Launcher.getDisplayName(root.getFileName()), null, tab, null, i - 1);
                                (this).LaunchBuilder.this.tabbedPane.setSelectedComponent(tab);
                                (this).LaunchBuilder.this.tabs.add(i - 1, tab);
                            }
                        });
                        popup.add(item);
                    }
                    popup.show(LaunchBuilder.this.tabbedPane, e.getX(), e.getY() + 8);
                }
            }
        };
        this.tabbedPane.addMouseListener(this.tabListener);
        this.frame.pack();
        this.displaySplitPane.setDividerLocation(0.7);
    }

    protected void setFontLevel(int level) {
        final int prev = this.displaySplitPane.getLastDividerLocation();
        final String divider = this.displaySplitPane.getName();
        FontSizer.setFonts(this.htmlTitle, level);
        FontSizer.setFonts(this.commentTitle, level);
        FontSizer.setFonts(this.descriptionTitle, level);
        FontSizer.setFonts(this.optionsTitle, level);
        FontSizer.setFonts(this.securityTitle, level);
        super.setFontLevel(level);
        if (divider != null) {
            Runnable runner = new Runnable(){

                public void run() {
                    double loc = Double.parseDouble(divider);
                    loc = Math.max(0.0, loc);
                    loc = Math.min(1.0, loc);
                    LaunchBuilder.this.displaySplitPane.setDividerLocation(loc);
                    LaunchBuilder.this.displaySplitPane.setLastDividerLocation(prev);
                }
            };
            SwingUtilities.invokeLater(runner);
        }
    }

    protected void createActions() {
        String imageFile = "/org/opensourcephysics/resources/tools/images/open.gif";
        ImageIcon openIcon = new ImageIcon((class$org$opensourcephysics$tools$Launcher == null ? (class$org$opensourcephysics$tools$Launcher = LaunchBuilder.class$("org.opensourcephysics.tools.Launcher")) : class$org$opensourcephysics$tools$Launcher).getResource(imageFile));
        this.openJarAction = new AbstractAction(null, openIcon){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = LaunchBuilder.getJARChooser();
                int result = chooser.showOpenDialog(null);
                if (result == 0) {
                    File file = chooser.getSelectedFile();
                    String newJar = XML.getRelativePath(file.getPath());
                    String jars = LaunchBuilder.this.jarField.getText();
                    if (jars.indexOf(newJar) > -1) {
                        newJar = null;
                    }
                    if (!jars.equals("")) {
                        jars = jars + ";";
                    }
                    if (newJar != null) {
                        LaunchBuilder.this.jarField.setText(jars + newJar);
                    }
                    OSPFrame.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.searchJarAction.setEnabled(true);
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.searchJarAction = new AbstractAction(null, openIcon){

            public void actionPerformed(ActionEvent e) {
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                if (node != null && LaunchBuilder.this.getClassChooser().chooseClassFor(node)) {
                    if (node.getOwner() != null) {
                        LaunchBuilder.this.changedFiles.add(node.getOwner().getFileName());
                    } else {
                        LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                    }
                    LaunchBuilder.this.refreshClones(node);
                    LaunchBuilder.this.refreshGUI();
                }
            }
        };
        this.searchJarAction.setEnabled(false);
        this.openArgAction = new AbstractAction(null, openIcon){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = LaunchBuilder.getFileChooser();
                int result = chooser.showOpenDialog(null);
                if (result == 0) {
                    File file = chooser.getSelectedFile();
                    LaunchBuilder.this.argField.setText(XML.getRelativePath(file.getPath()));
                    OSPFrame.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.openURLAction = new AbstractAction(null, openIcon){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = LaunchBuilder.getHTMLChooser();
                int result = chooser.showOpenDialog(null);
                if (result == 0) {
                    File file = chooser.getSelectedFile();
                    LaunchBuilder.this.urlField.setText(XML.getRelativePath(file.getPath()));
                    OSPFrame.chooserDir = XML.getDirectoryPath(file.getPath());
                    LaunchBuilder.this.refreshSelectedNode();
                }
            }
        };
        this.openTabAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                String tabName = node.toString();
                for (int i = 0; i < LaunchBuilder.this.tabbedPane.getComponentCount(); ++i) {
                    if (!LaunchBuilder.this.tabbedPane.getTitleAt(i).equals(tabName)) continue;
                    LaunchBuilder.this.tabbedPane.setSelectedIndex(i);
                    return;
                }
                XMLControlElement control = new XMLControlElement(node);
                XMLControlElement cloneControl = new XMLControlElement(control);
                LaunchNode clone = (LaunchNode)cloneControl.loadObject(null);
                clone.setFileName(node.getFileName());
                LaunchBuilder.this.addTab(clone);
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.changeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LaunchBuilder.this.refreshSelectedNode();
            }
        };
        this.newTabSetAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Launcher.LinkEdit edit = null;
                if (LaunchBuilder.this.tabSetName != null && new File(LaunchBuilder.this.tabSetName).exists()) {
                    String[] args = new String[]{" "};
                    edit = new Launcher.LinkEdit((Launcher)LaunchBuilder.this, args);
                }
                if (LaunchBuilder.this.removeAllTabs()) {
                    if (edit != null) {
                        LaunchBuilder.this.undoSupport.postEdit(edit);
                    }
                    LaunchNode root = new LaunchNode(LaunchRes.getString("NewTab.Name"));
                    LaunchBuilder.this.addTab(root);
                }
            }
        };
        this.addAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LaunchNode newNode = new LaunchNode(LaunchRes.getString("NewNode.Name"));
                LaunchBuilder.this.addChildToSelectedNode(newNode);
            }
        };
        this.newTabAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LaunchNode root = new LaunchNode(LaunchRes.getString("NewTab.Name"));
                LaunchBuilder.this.addTab(root);
            }
        };
        this.cutAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LaunchBuilder.this.copyAction.actionPerformed(null);
                LaunchBuilder.this.removeSelectedNode();
            }
        };
        this.copyAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                if (node != null) {
                    XMLControlElement control = new XMLControlElement(node);
                    control.setValue("filename", node.getFileName());
                    StringSelection data = new StringSelection(control.toXML());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(data, data);
                }
            }
        };
        this.pasteAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable data = clipboard.getContents(null);
                    String dataString = (String)data.getTransferData(DataFlavor.stringFlavor);
                    if (dataString != null) {
                        XMLControlElement control = new XMLControlElement();
                        control.readXML(dataString);
                        if (control.getObjectClass() == (class$org$opensourcephysics$tools$LaunchNode == null ? (class$org$opensourcephysics$tools$LaunchNode = LaunchBuilder.class$("org.opensourcephysics.tools.LaunchNode")) : class$org$opensourcephysics$tools$LaunchNode)) {
                            String fileName = control.getString("filename");
                            LaunchNode newNode = (LaunchNode)control.loadObject(null);
                            newNode.setFileName(fileName);
                            LaunchBuilder.this.addChildToSelectedNode(newNode);
                        }
                    }
                }
                catch (UnsupportedFlavorException ex) {
                }
                catch (IOException ex) {
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
        };
        this.importAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Launcher.getXMLChooser().setFileFilter(Launcher.xmlFileFilter);
                int result = Launcher.getXMLChooser().showOpenDialog(null);
                if (result == 0) {
                    File file = Launcher.getXMLChooser().getSelectedFile();
                    String fileName = file.getAbsolutePath();
                    OSPFrame.chooserDir = XML.getDirectoryPath(file.getPath());
                    XMLControlElement control = new XMLControlElement(fileName);
                    if (control.failedToRead()) {
                        OSPLog.info(LaunchRes.getString("Log.Message.InvalidXML") + " " + fileName);
                        JOptionPane.showMessageDialog(null, LaunchRes.getString("Dialog.InvalidXML.Message") + " \"" + XML.getName(fileName) + "\"", LaunchRes.getString("Dialog.InvalidXML.Title"), 2);
                        return;
                    }
                    if (control.getObjectClass() == (class$org$opensourcephysics$tools$LaunchNode == null ? (class$org$opensourcephysics$tools$LaunchNode = LaunchBuilder.class$("org.opensourcephysics.tools.LaunchNode")) : class$org$opensourcephysics$tools$LaunchNode)) {
                        LaunchNode child = (LaunchNode)control.loadObject(null);
                        child.setFileName(fileName);
                        LaunchBuilder.this.addChildToSelectedNode(child);
                    } else {
                        OSPLog.info(LaunchRes.getString("Log.Message.NotLauncherFile") + " " + fileName);
                        JOptionPane.showMessageDialog(null, LaunchRes.getString("Dialog.NotLauncherFile.Message") + " \"" + XML.getName(fileName) + "\"", LaunchRes.getString("Dialog.NotLauncherFile.Title"), 2);
                    }
                }
            }
        };
        this.saveAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                if (node.getFileName() != null) {
                    LaunchBuilder.this.save(node, node.getFileName());
                    LaunchBuilder.this.refreshGUI();
                }
            }
        };
        this.saveAsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                LaunchNode parent = (LaunchNode)node.getParent();
                String fileName = LaunchBuilder.this.saveAs(node);
                if (fileName != null) {
                    LaunchBuilder.this.selfContained = false;
                    Enumeration<TreeNode> en = node.pathFromAncestorEnumeration(node.getRoot());
                    while (en.hasMoreElements()) {
                        LaunchNode next = (LaunchNode)en.nextElement();
                        next.setSelfContained(false);
                        next.parentSelfContained = false;
                    }
                    if (parent != null) {
                        if (parent.getOwner() != null) {
                            LaunchBuilder.this.changedFiles.add(parent.getOwner().getFileName());
                        }
                        LaunchBuilder.this.refreshClones(parent);
                    }
                }
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.saveAllAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (LaunchBuilder.this.tabSetName.equals(LaunchRes.getString("Tabset.Name.New"))) {
                    LaunchBuilder.this.saveTabSetAs();
                } else {
                    LaunchBuilder.this.saveTabSet();
                }
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.saveSetAsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LaunchBuilder.this.saveTabSetAs();
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.moveUpAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                if (node == null) {
                    return;
                }
                LaunchNode parent = (LaunchNode)node.getParent();
                if (parent == null) {
                    return;
                }
                int i = parent.getIndex(node);
                if (i > 0) {
                    LaunchBuilder.this.getSelectedTab().treeModel.removeNodeFromParent(node);
                    LaunchBuilder.this.getSelectedTab().treeModel.insertNodeInto(node, parent, i - 1);
                    LaunchBuilder.this.getSelectedTab().setSelectedNode(node);
                    if (parent.getOwner() != null) {
                        LaunchBuilder.this.changedFiles.add(parent.getOwner().getFileName());
                    } else {
                        LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                    }
                    LaunchBuilder.this.refreshGUI();
                }
            }
        };
        this.moveDownAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int end;
                LaunchNode node = LaunchBuilder.this.getSelectedNode();
                if (node == null) {
                    return;
                }
                LaunchNode parent = (LaunchNode)node.getParent();
                if (parent == null) {
                    return;
                }
                int i = parent.getIndex(node);
                if (i < (end = parent.getChildCount()) - 1) {
                    LaunchBuilder.this.getSelectedTab().treeModel.removeNodeFromParent(node);
                    LaunchBuilder.this.getSelectedTab().treeModel.insertNodeInto(node, parent, i + 1);
                    LaunchBuilder.this.getSelectedTab().setSelectedNode(node);
                    if (parent.getOwner() != null) {
                        LaunchBuilder.this.changedFiles.add(parent.getOwner().getFileName());
                    } else {
                        LaunchBuilder.this.changedFiles.add(LaunchBuilder.this.tabSetName);
                    }
                    LaunchBuilder.this.refreshGUI();
                }
            }
        };
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                LaunchBuilder.this.refreshSelectedNode();
                LaunchBuilder.this.refreshGUI();
            }
        };
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                JComponent comp = (JComponent)e.getSource();
                if (e.getKeyCode() == 10 && (comp != LaunchBuilder.this.descriptionPane && comp != LaunchBuilder.this.commentPane || e.isControlDown() || e.isShiftDown())) {
                    LaunchBuilder.this.refreshSelectedNode();
                    LaunchBuilder.this.refreshGUI();
                } else {
                    comp.setBackground(Color.yellow);
                }
            }
        };
    }

    protected void removeSelectedNode() {
        LaunchNode node = this.getSelectedNode();
        if (node == null || node.getParent() == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        LaunchNode parent = (LaunchNode)node.getParent();
        this.getSelectedTab().treeModel.removeNodeFromParent(node);
        this.getSelectedTab().setSelectedNode(parent);
        if (parent.getOwner() != null) {
            this.changedFiles.add(parent.getOwner().getFileName());
        } else {
            this.changedFiles.add(this.tabSetName);
        }
        this.refreshClones(parent);
        this.refreshGUI();
    }

    protected void addChildToSelectedNode(LaunchNode child) {
        LaunchNode parent = this.getSelectedNode();
        if (parent != null && child != null) {
            LaunchNode[] nodes = child.getAllOwnedNodes();
            for (int i = 0; i < nodes.length; ++i) {
                LaunchNode node = this.getSelectedTab().getClone(nodes[i]);
                if (node == null) continue;
                this.getSelectedTab().setSelectedNode(node);
                JOptionPane.showMessageDialog(this.frame, LaunchRes.getString("Dialog.DuplicateNode.Message") + " \"" + node + "\"", LaunchRes.getString("Dialog.DuplicateNode.Title"), 2);
                return;
            }
            this.getSelectedTab().treeModel.insertNodeInto(child, parent, parent.getChildCount());
            this.getSelectedTab().tree.scrollPathToVisible(new TreePath(child.getPath()));
            child.setLaunchClass(child.launchClassName);
            if (parent.getOwner() != null) {
                this.changedFiles.add(parent.getOwner().getFileName());
            } else {
                this.changedFiles.add(this.tabSetName);
            }
            this.refreshClones(parent);
            this.refreshGUI();
        }
    }

    protected void refreshClones(LaunchNode node) {
        Map clones = this.getClones(node);
        this.replaceClones(node, clones);
    }

    protected void replaceClones(LaunchNode node, Map clones) {
        if (clones.isEmpty()) {
            return;
        }
        XMLControlElement control = new XMLControlElement(node.getOwner());
        Iterator it = clones.keySet().iterator();
        while (it.hasNext()) {
            LaunchPanel tab = (LaunchPanel)it.next();
            LaunchNode clone = (LaunchNode)clones.get(tab);
            LaunchNode parent = (LaunchNode)clone.getParent();
            boolean expanded = tab.tree.isExpanded(new TreePath(clone.getPath()));
            if (parent != null) {
                int index = parent.getIndex(clone);
                tab.treeModel.removeNodeFromParent(clone);
                clone = (LaunchNode)new XMLControlElement(control).loadObject(null);
                clone.setFileName(node.getFileName());
                tab.treeModel.insertNodeInto(clone, parent, index);
            } else {
                clone = (LaunchNode)new XMLControlElement(control).loadObject(null);
                clone.setFileName(node.getFileName());
                tab.treeModel.setRoot(clone);
            }
            if (!expanded) continue;
            tab.tree.expandPath(new TreePath(clone.getPath()));
        }
    }

    protected Map getClones(LaunchNode node) {
        HashMap<LaunchPanel, LaunchNode> clones = new HashMap<LaunchPanel, LaunchNode>();
        if ((node = node.getOwner()) == null) {
            return clones;
        }
        Component[] tabs = this.tabbedPane.getComponents();
        for (int i = 0; i < tabs.length; ++i) {
            LaunchPanel tab = (LaunchPanel)tabs[i];
            LaunchNode clone = tab.getClone(node);
            if (clone == null || clone == node) continue;
            clones.put(tab, clone);
        }
        return clones;
    }

    protected void showAboutDialog() {
        String newline = XML.NEW_LINE;
        String aboutString = "LaunchBuilder " + Launcher.version + "   " + Launcher.releaseDate + newline + "Open Source Physics Project" + newline + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this.frame, aboutString, LaunchRes.getString("Help.About.Title") + " LaunchBuilder", 1);
    }

    protected static JFileChooser getJARChooser() {
        LaunchBuilder.getFileChooser().setFileFilter(jarFileFilter);
        return fileChooser;
    }

    protected static JFileChooser getHTMLChooser() {
        LaunchBuilder.getFileChooser().setFileFilter(htmlFileFilter);
        return fileChooser;
    }

    protected static JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(new File(OSPFrame.chooserDir));
            allFileFilter = fileChooser.getFileFilter();
            jarFileFilter = new FileFilter(){

                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = null;
                    String name = f.getName();
                    int i = name.lastIndexOf(46);
                    if (i > 0 && i < name.length() - 1) {
                        extension = name.substring(i + 1).toLowerCase();
                    }
                    return extension != null && extension.equals("jar");
                }

                public String getDescription() {
                    return LaunchRes.getString("FileChooser.JarFilter.Description");
                }
            };
            htmlFileFilter = new FileFilter(){

                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = null;
                    String name = f.getName();
                    int i = name.lastIndexOf(46);
                    if (i > 0 && i < name.length() - 1) {
                        extension = name.substring(i + 1).toLowerCase();
                    }
                    return extension != null && (extension.equals("htm") || extension.equals("html"));
                }

                public String getDescription() {
                    return LaunchRes.getString("FileChooser.HTMLFilter.Description");
                }
            };
        }
        fileChooser.removeChoosableFileFilter(jarFileFilter);
        fileChooser.removeChoosableFileFilter(htmlFileFilter);
        fileChooser.setFileFilter(allFileFilter);
        return fileChooser;
    }

    protected void handleMousePressed(MouseEvent e, LaunchPanel tab) {
        super.handleMousePressed(e, tab);
        if (e.isPopupTrigger() || e.getButton() == 3 || e.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1) {
            TreePath path = tab.tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            LaunchNode node = this.getSelectedNode();
            if (node == null) {
                return;
            }
            String fileName = node.getFileName();
            if (fileName != null && this.changedFiles.contains(fileName)) {
                if (this.popup.getComponentCount() != 0) {
                    this.popup.addSeparator();
                }
                this.popup.add(this.saveNodeItem);
            }
            if (this.popup.getComponentCount() != 0) {
                this.popup.addSeparator();
            }
            this.popup.add(this.saveNodeAsItem);
            if (!node.isRoot()) {
                this.popup.addSeparator();
                this.openTabItem.setText(LaunchRes.getString("Action.OpenTab"));
                this.popup.add(this.openTabItem);
            }
            this.popup.show(tab, e.getX() + 4, e.getY() + 12);
        }
    }

    protected void exit() {
        OSPFrame.setAuthorMode(false);
        if (!this.saveAllChanges()) {
            final int op = this.frame.getDefaultCloseOperation();
            this.frame.setDefaultCloseOperation(0);
            Runnable runner = new Runnable(){

                public void run() {
                    LaunchBuilder.this.frame.setDefaultCloseOperation(op);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        super.exit();
    }

    protected boolean isTabSetWritable() {
        boolean writable;
        String path = XML.getResolvedPath(this.tabSetName, Launcher.tabSetBasePath);
        Resource res = ResourceLoader.getResource(path);
        File file = res == null ? null : res.getFile();
        boolean bl = writable = file == null ? true : file.canWrite();
        if (!this.selfContained) {
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                LaunchNode root = this.getTab(i).getRootNode();
                writable = writable && this.isNodeWritable(root);
            }
        }
        return writable;
    }

    protected boolean isNodeWritable(LaunchNode node) {
        boolean writable;
        File file = node.getFile();
        boolean bl = writable = file == null ? true : file.canWrite();
        if (!node.isSelfContained()) {
            LaunchNode[] nodes = node.getChildOwnedNodes();
            for (int i = 0; i < nodes.length; ++i) {
                writable = writable && this.isNodeWritable(nodes[i]);
            }
        }
        return writable;
    }

    static {
        maxArgs = 4;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

