/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.Launcher;

public class LaunchPanel
extends JPanel {
    protected static String defaultType = "text";
    protected JTree tree;
    protected DefaultTreeModel treeModel;
    protected JSplitPane splitPane;
    protected JPanel dataPanel;
    protected JEditorPane textPane;
    protected JScrollPane textScroller;
    protected boolean showText = true;
    protected boolean showAllNodes;
    protected Map visibleNodeMap = new HashMap();

    public LaunchPanel(LaunchNode rootNode, Launcher launcher) {
        this.showAllNodes = launcher instanceof LaunchBuilder;
        this.createGUI();
        this.createTree(rootNode);
        this.setSelectedNode(rootNode);
    }

    public void setSelectedNode(LaunchNode node) {
        if (node == null) {
            return;
        }
        this.tree.setSelectionPath(new TreePath(node.getPath()));
    }

    public LaunchNode getSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (LaunchNode)path.getLastPathComponent();
    }

    public LaunchNode getRootNode() {
        return (LaunchNode)this.treeModel.getRoot();
    }

    protected LaunchNode getClone(LaunchNode node) {
        if (node.getFileName() == null) {
            return null;
        }
        Enumeration<TreeNode> e = this.getRootNode().breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            LaunchNode next = (LaunchNode)e.nextElement();
            if (!node.getFileName().equals(next.getFileName())) continue;
            return next;
        }
        return null;
    }

    protected void createGUI() {
        this.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane();
        this.add((Component)this.splitPane, "Center");
        this.dataPanel = new JPanel(new BorderLayout());
        this.splitPane.setRightComponent(this.dataPanel);
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        LaunchPanel.this.textPane.setPage(e.getURL());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.textScroller = new JScrollPane(this.textPane);
        this.dataPanel.add((Component)this.textScroller, "Center");
        this.splitPane.setDividerLocation(160);
    }

    protected void createTree(LaunchNode rootNode) {
        if (!this.showAllNodes) {
            VisibleNode visibleRoot = new VisibleNode(rootNode);
            this.visibleNodeMap.put(rootNode, visibleRoot);
            this.addVisibleNodes(visibleRoot);
        }
        this.treeModel = new LaunchTreeModel(rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setToolTipText("");
        this.tree.setRootVisible(!rootNode.hiddenWhenRoot);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                block7: {
                    LaunchNode node = LaunchPanel.this.getSelectedNode();
                    OSPLog.finer(LaunchRes.getString("Log.Message.NodeSelected") + " " + node);
                    if (node != null) {
                        if (node.url != null) {
                            try {
                                if (node.url.getContent() != null) {
                                    LaunchPanel.this.textPane.setPage(node.url);
                                }
                                break block7;
                            }
                            catch (IOException ex) {
                                OSPLog.finest(LaunchRes.getString("Log.Message.BadURL") + " " + node.url);
                                if (LaunchPanel.this.showText) {
                                    LaunchPanel.this.textPane.setContentType(defaultType);
                                    LaunchPanel.this.textPane.setText(node.description);
                                }
                                break block7;
                            }
                        }
                        if (LaunchPanel.this.showText) {
                            LaunchPanel.this.textPane.setContentType(defaultType);
                            LaunchPanel.this.textPane.setText(node.description);
                        }
                    }
                }
            }
        });
        JScrollPane treeScroller = new JScrollPane(this.tree);
        this.splitPane.setLeftComponent(treeScroller);
    }

    private void addVisibleNodes(VisibleNode visibleParent) {
        int n = visibleParent.node.getChildCount();
        for (int i = 0; i < n; ++i) {
            LaunchNode child = (LaunchNode)visibleParent.node.getChildAt(i);
            if (child.isHiddenInLauncher()) continue;
            VisibleNode visibleChild = new VisibleNode(child);
            this.visibleNodeMap.put(child, visibleChild);
            visibleParent.add(visibleChild);
            this.addVisibleNodes(visibleChild);
        }
    }

    private class VisibleNode
    extends DefaultMutableTreeNode {
        LaunchNode node;

        VisibleNode(LaunchNode node) {
            this.node = node;
        }
    }

    class LaunchTreeModel
    extends DefaultTreeModel {
        LaunchTreeModel(LaunchNode root) {
            super(root);
        }

        public Object getChild(Object parent, int index) {
            VisibleNode visibleChild;
            if (LaunchPanel.this.showAllNodes) {
                return super.getChild(parent, index);
            }
            VisibleNode visibleParent = (VisibleNode)LaunchPanel.this.visibleNodeMap.get(parent);
            if (visibleParent != null && (visibleChild = (VisibleNode)visibleParent.getChildAt(index)) != null) {
                return visibleChild.node;
            }
            return null;
        }

        public int getChildCount(Object parent) {
            if (LaunchPanel.this.showAllNodes) {
                return super.getChildCount(parent);
            }
            VisibleNode visibleParent = (VisibleNode)LaunchPanel.this.visibleNodeMap.get(parent);
            if (visibleParent != null) {
                return visibleParent.getChildCount();
            }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            if (LaunchPanel.this.showAllNodes) {
                return super.getIndexOfChild(parent, child);
            }
            VisibleNode visibleParent = (VisibleNode)LaunchPanel.this.visibleNodeMap.get(parent);
            VisibleNode visibleChild = (VisibleNode)LaunchPanel.this.visibleNodeMap.get(child);
            if (visibleParent != null && visibleChild != null) {
                return visibleParent.getIndex(visibleChild);
            }
            return -1;
        }
    }
}

