/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JApplet;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.tools.Launcher;

class LaunchableClassMap
extends TreeMap {
    ClassLoader classLoader;
    String[] jarNames;
    boolean allLoaded = false;

    LaunchableClassMap(String[] jarNames) {
        this.jarNames = jarNames;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < jarNames.length; ++i) {
            try {
                urls.add(new URL("file:" + jarNames[i]));
                continue;
            }
            catch (MalformedURLException ex) {
                OSPLog.info(ex + " " + jarNames[i]);
            }
        }
        this.classLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]));
    }

    Class smartLoadClass(String name) throws ClassNotFoundException {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.getClass().getClassLoader().loadClass(name);
        }
    }

    void loadAllLaunchables() {
        if (this.allLoaded) {
            return;
        }
        JApplet applet = OSPFrame.applet;
        for (int i = 0; i < this.jarNames.length; ++i) {
            JarFile jar = null;
            try {
                if (applet == null) {
                    jar = new JarFile(this.jarNames[i]);
                } else {
                    String path = XML.getResolvedPath(this.jarNames[i], applet.getCodeBase().toExternalForm());
                    URL url = new URL("jar:" + path + "!/");
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    jar = conn.getJarFile();
                }
            }
            catch (IOException ex) {
                OSPLog.info(ex.getClass().getName() + ": " + ex.getMessage());
            }
            catch (SecurityException ex) {
                OSPLog.info(ex.getClass().getName() + ": " + ex.getMessage());
            }
            if (jar == null) continue;
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class") || name.indexOf("$") != -1) continue;
                name = name.substring(0, name.indexOf(".class"));
                int j = name.indexOf("/");
                while (j != -1) {
                    name = name.substring(0, j) + "." + name.substring(j + 1);
                    j = name.indexOf("/");
                }
                if (this.get(name) != null) continue;
                try {
                    Class next = this.smartLoadClass(name);
                    if (!Launcher.isLaunchable(next)) continue;
                    this.put(name, next);
                }
                catch (ClassNotFoundException ex) {
                }
                catch (NoClassDefFoundError err) {
                    OSPLog.info(err.toString());
                }
            }
        }
        this.allLoaded = true;
    }

    boolean includesJar(String jarName) {
        for (int i = 0; i < this.jarNames.length; ++i) {
            if (!this.jarNames[i].equals(jarName)) continue;
            return true;
        }
        return false;
    }

    Class getClass(String className) {
        Class type = (Class)this.get(className);
        if (type != null || this.allLoaded) {
            return type;
        }
        try {
            type = this.smartLoadClass(className);
            if (Launcher.isLaunchable(type)) {
                return type;
            }
        }
        catch (ClassNotFoundException ex) {
        }
        catch (NoClassDefFoundError err) {
            OSPLog.info(err.toString());
        }
        return null;
    }
}

