/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.RemoteJob;
import org.opensourcephysics.tools.Tool;

public class RemoteTool
extends UnicastRemoteObject
implements Tool {
    Tool child;
    Map replies = new HashMap();
    Map jobs = new HashMap();

    public RemoteTool(Tool tool) throws RemoteException {
        OSPLog.finest("Wrapping tool " + tool.getClass().getName());
        this.child = tool;
    }

    public void send(Job job, Tool replyTo) throws RemoteException {
        this.save(job, replyTo);
        job = this.convert(job);
        if (this.child.equals(replyTo)) {
            this.sendReplies(job);
        } else {
            this.forward(job);
        }
    }

    private void save(Job job, Tool tool) {
        if (tool == null || this.child.equals(tool)) {
            return;
        }
        HashSet<Tool> tools = (HashSet<Tool>)this.replies.get(job);
        if (tools == null) {
            tools = new HashSet<Tool>();
            this.replies.put(job, tools);
        }
        tools.add(tool);
    }

    private void sendReplies(Job job) throws RemoteException {
        Collection tools = (Collection)this.replies.get(job);
        if (tools == null) {
            return;
        }
        Iterator it = tools.iterator();
        while (it.hasNext()) {
            Tool tool = (Tool)it.next();
            tool.send(job, this);
        }
    }

    private void forward(Job job) throws RemoteException {
        this.child.send(job, this);
    }

    private Job convert(Job job) throws RemoteException {
        if (job instanceof LocalJob) {
            RemoteJob remote = new RemoteJob(job);
            this.jobs.put(remote, job);
            return remote;
        }
        Job obj = (Job)this.jobs.get(job);
        if (obj == null) {
            return job;
        }
        return obj;
    }
}

