/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.RemoteTool;
import org.opensourcephysics.tools.Tool;

public class Toolbox {
    protected static Map tools = new HashMap();
    protected static Registry registry;
    protected static int allowRMI;

    protected Toolbox() {
    }

    public static void addTool(String name, Tool tool) {
        tools.put(name, tool);
        OSPLog.fine("Added to toolbox: " + name);
    }

    public static boolean addRMITool(String name, Tool tool) {
        Toolbox.initRMI();
        if (allowRMI == 0) {
            return false;
        }
        try {
            RemoteTool remote = new RemoteTool(tool);
            registry.bind(name, remote);
            OSPLog.fine("Added to RMI registry: " + name);
            return true;
        }
        catch (Exception ex) {
            OSPLog.warning("RMI registration failed: " + name + " [" + ex + "]");
            return false;
        }
    }

    public static Tool getTool(String name) {
        if (tools.containsKey(name)) {
            Tool tool = (Tool)tools.get(name);
            OSPLog.fine("Found local tool: " + name);
            return tool;
        }
        Toolbox.initRMI();
        if (allowRMI == 0) {
            return null;
        }
        try {
            Tool tool = (Tool)registry.lookup(name);
            OSPLog.fine("Found RMI tool " + name);
            return new RemoteTool(tool);
        }
        catch (Exception ex) {
            OSPLog.info("RMI lookup failed: " + name + " [" + ex + "]");
            return null;
        }
    }

    private static void initRMI() {
        if (allowRMI == 0) {
            return;
        }
        int selection = JOptionPane.showConfirmDialog(null, "Initialize Remote Method Invocation?", "RMI Toolbox", 0, 3);
        if (selection != 0) {
            allowRMI = 0;
            return;
        }
        allowRMI = 1;
        if (registry == null) {
            try {
                registry = LocateRegistry.getRegistry(1099);
                registry.list();
            }
            catch (RemoteException ex) {
                try {
                    registry = LocateRegistry.createRegistry(1099);
                }
                catch (RemoteException ex1) {
                    OSPLog.info(ex1.getMessage());
                }
            }
        }
        if (System.getSecurityManager() == null) {
            try {
                String base = "file:" + System.getProperty("user.dir");
                System.setProperty("java.rmi.server.codebase", base + "/classes/");
                System.setProperty("java.security.policy", base + "/Remote.policy");
                System.setSecurityManager(new RMISecurityManager());
            }
            catch (Exception ex) {
                OSPLog.info(ex.getMessage());
            }
        }
    }

    static {
        allowRMI = -1;
    }
}

