/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.TableModelEvent;
import org.opensourcephysics.controls.OSPControl;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;
import org.opensourcephysics.controls.XMLTableModel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

public class TranslatorTool
extends OSPFrame
implements Tool {
    private static Dimension dim = new Dimension(320, 240);
    private static Map defaultProps = new HashMap();
    private static Map classes = new HashMap();
    private static Map associates = new HashMap();
    private static Set changed = new HashSet();
    private static Locale locale = Locale.getDefault();
    private XMLControl control = new XMLControlElement();
    private XMLTable table;
    private Class classType;
    private JPanel contentPane = new JPanel(new BorderLayout());
    private String fileExtension;
    private JLabel descriptionLabel;
    private JComboBox localeDropDown;
    private Icon saveIcon;
    private JButton saveButton;
    private JButton closeButton;
    private JButton helpButton;
    private static final TranslatorTool TOOL = new TranslatorTool();

    public static TranslatorTool getTool() {
        return TOOL;
    }

    private TranslatorTool() {
        String name = "TranslatorTool";
        this.setName(name);
        this.createGUI();
        this.refreshGUI();
        this.setLocale(ToolsRes.locale);
        Toolbox.addTool(name, this);
    }

    public void send(Job job, Tool replyTo) throws RemoteException {
    }

    public void setLocale(Locale locale) {
        if (locale == TranslatorTool.locale) {
            return;
        }
        TranslatorTool.locale = locale;
        this.showProperties(this.classType);
        if (this.localeDropDown != null) {
            int i;
            for (i = 0; i < this.localeDropDown.getItemCount(); ++i) {
                LocaleItem item = (LocaleItem)this.localeDropDown.getItemAt(i);
                if (item.loc.getLanguage().equals(locale.getLanguage())) break;
            }
            if (i == this.localeDropDown.getItemCount()) {
                this.localeDropDown.addItem(new LocaleItem(locale));
            }
            this.localeDropDown.setSelectedIndex(i);
            Map properties = TranslatorTool.getProperties(this.classType, locale);
            this.saveButton.setEnabled(changed.contains(properties));
            TranslatorTool.refreshAssociates(this.classType);
        }
    }

    public static void associate(Object obj, Class type) {
        if (obj == null) {
            return;
        }
        associates.put(obj, type);
    }

    public void showProperties(Class type) {
        if (type == null) {
            return;
        }
        this.classType = type;
        this.control.clearValues();
        this.fileExtension = "";
        String addon = locale.getLanguage();
        if (!addon.equals("")) {
            this.fileExtension = this.fileExtension + "_" + addon;
        }
        this.fileExtension = this.fileExtension + ".properties";
        Collection names = this.control.getPropertyNames();
        Iterator<Object> it = names.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            this.control.setValue(next, next);
        }
        Map properties = TranslatorTool.getProperties(type, locale);
        it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.control.setValue(key, properties.get(key));
        }
        Set keys = TranslatorTool.getDefaults(type).keySet();
        it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (keys.contains(key)) continue;
            this.table.setBackgroundColor(key, Color.PINK);
        }
        this.table.refresh();
        this.refreshGUI();
    }

    public static String getProperty(Class type, String key) {
        return TranslatorTool.getProperty(type, key, key, ToolsRes.locale);
    }

    public static String getProperty(Class type, String key, String defaultValue) {
        return TranslatorTool.getProperty(type, key, defaultValue, ToolsRes.locale);
    }

    public static String getProperty(Object obj, String key) {
        return TranslatorTool.getProperty(obj, key, key);
    }

    public static String getProperty(Object obj, String key, String defaultValue) {
        if (obj == null) {
            return defaultValue == null ? key : defaultValue;
        }
        Class type = (Class)associates.get(obj);
        return TranslatorTool.getProperty(type, key, defaultValue, ToolsRes.locale);
    }

    public static void removeProperty(Class type, String key) {
        if (type == null) {
            return;
        }
        TranslatorTool.getDefaults(type).remove(key);
        Map locales = (Map)classes.get(type);
        if (locales != null) {
            Iterator it = locales.keySet().iterator();
            while (it.hasNext()) {
                Map properties = (Map)locales.get(it.next());
                properties.remove(key);
                changed.add(properties);
            }
        }
        TOOL.showProperties(TranslatorTool.TOOL.classType);
        TranslatorTool.refreshAssociates(TranslatorTool.TOOL.classType);
    }

    public static void removeProperty(Object obj, String key) {
        Class type = (Class)associates.get(obj);
        TranslatorTool.removeProperty(type, key);
    }

    public static void addProperty(Class type, String key, String defaultValue) {
        Map locales;
        if (type == null || key == null) {
            return;
        }
        if (defaultValue == null) {
            defaultValue = key;
        }
        TranslatorTool.getDefaults(type).put(key, defaultValue);
        Map properties = TranslatorTool.getProperties(type, locale);
        if (properties.get(key) == null) {
            properties.put(key, defaultValue);
            changed.add(properties);
        }
        if ((locales = (Map)classes.get(type)) != null) {
            Iterator it = locales.keySet().iterator();
            while (it.hasNext()) {
                properties = (Map)locales.get(it.next());
                if (properties.get(key) != null) continue;
                properties.put(key, defaultValue);
                changed.add(properties);
            }
        }
        TOOL.showProperties(TranslatorTool.TOOL.classType);
        TranslatorTool.refreshAssociates(TranslatorTool.TOOL.classType);
    }

    private static String getProperty(Class type, String key, String defaultValue, Locale locale) {
        if (defaultValue == null) {
            defaultValue = key;
        }
        if (type == null) {
            return defaultValue;
        }
        if (!TranslatorTool.getDefaults(type).keySet().contains(key)) {
            TranslatorTool.addProperty(type, key, defaultValue);
        }
        Map properties = TranslatorTool.getProperties(type, locale);
        String value = (String)properties.get(key);
        return value;
    }

    private static String getPath(Class type) {
        if (type == null) {
            return null;
        }
        String path = type.getName();
        int i = path.indexOf(".");
        while (i != -1) {
            path = path.substring(0, i) + "/" + path.substring(i + 1);
            i = path.indexOf(".");
        }
        return path;
    }

    private static Map getDefaults(Class type) {
        TreeMap defaults = (TreeMap)defaultProps.get(type);
        if (defaults == null) {
            defaults = new TreeMap();
            defaultProps.put(type, defaults);
        }
        return defaults;
    }

    private static Map getProperties(Class type, Locale locale) {
        TreeMap properties;
        HashMap locales = (HashMap)classes.get(type);
        if (locales == null) {
            locales = new HashMap();
            classes.put(type, locales);
        }
        if ((properties = (TreeMap)locales.get(locale.getLanguage())) == null) {
            properties = new TreeMap();
            locales.put(locale.getLanguage(), properties);
            String path = TranslatorTool.getPath(type);
            Resource res = null;
            String lang = locale.getLanguage();
            if (!lang.equals("")) {
                res = ResourceLoader.getResource(path + "_" + lang + ".properties");
            }
            if (res == null) {
                res = ResourceLoader.getResource(path + ".properties");
            }
            if (res != null) {
                OSPLog.finer(res.getAbsolutePath());
                TranslatorTool.readProperties(res.openReader(), properties);
            } else {
                Map defaults = TranslatorTool.getDefaults(type);
                Iterator it = defaults.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    Object val = defaults.get(key);
                    properties.put(key, val);
                }
                changed.add(properties);
            }
        }
        return properties;
    }

    private static void readProperties(BufferedReader input, Map map) {
        try {
            String next = input.readLine();
            while (next != null) {
                int i = next.indexOf("=");
                if (i > -1) {
                    String key = next.substring(0, i);
                    String val = next.substring(i + 1);
                    map.put(key, val);
                }
                next = input.readLine();
            }
        }
        catch (IOException ex) {
            return;
        }
    }

    private String save(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return null;
        }
        int n = fileName.lastIndexOf("/");
        if (n < 0) {
            n = fileName.lastIndexOf("\\");
        }
        if (n > 0) {
            String dir = fileName.substring(0, n + 1);
            File file = new File(dir);
            if (!file.exists()) {
                XML.createFolders(dir);
            }
            if (!file.exists()) {
                return null;
            }
        }
        StringBuffer content = new StringBuffer();
        String s = XML.stripExtension(fileName);
        content.append("# This is the " + s + ".properties file" + XML.NEW_LINE + XML.NEW_LINE);
        Iterator it = this.control.getPropertyNames().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String alias = this.control.getString(key);
            content.append(key + "=" + alias + XML.NEW_LINE);
        }
        File file = new File(fileName);
        try {
            if (file.exists() && !file.canWrite()) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Tool.Dialog.ReadOnlyFile"));
                return null;
            }
            FileOutputStream stream = new FileOutputStream(file);
            Charset charset = Charset.forName("UTF-8");
            Writer out = new OutputStreamWriter((OutputStream)stream, charset);
            out = new BufferedWriter(out);
            out.write(content.toString());
            out.flush();
            out.close();
            if (file.exists()) {
                OSPLog.finest(file.getAbsolutePath());
                changed.remove(TranslatorTool.getProperties(this.classType, locale));
                this.saveButton.setEnabled(false);
                return file.getAbsolutePath();
            }
        }
        catch (IOException ex) {
            OSPLog.warning(ex.getMessage());
        }
        return null;
    }

    private void createGUI() {
        XMLTableModel model = new XMLTableModel(this.control){

            public String getColumnName(int column) {
                return column == 0 ? ToolsRes.getString("TranslatorTool.ColumnTitle.Property") : ToolsRes.getString("TranslatorTool.ColumnTitle.PropValue");
            }
        };
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Locale locale = (Locale)e.getNewValue();
                if (locale != null) {
                    TranslatorTool.this.setLocale(locale);
                }
            }
        });
        this.contentPane.setPreferredSize(dim);
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(1);
        this.table = new XMLTable(model);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() || e.getButton() == 3 || e.isControlDown() && System.getProperty("os.name").indexOf("Mac") > -1) {
                    for (int i = 0; i < TranslatorTool.this.table.getRowCount(); ++i) {
                        Rectangle rect = TranslatorTool.this.table.getCellRect(i, 0, true);
                        if (!rect.contains(e.getX(), e.getY())) continue;
                        TranslatorTool.this.table.setRowSelectionInterval(i, i);
                        final String name = (String)TranslatorTool.this.table.getValueAt(i, 0);
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem removeItem = new JMenuItem(ToolsRes.getString("TranslatorTool.Popup.MenuItem.Remove") + " \"" + name + "\"");
                        popup.add(removeItem);
                        removeItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent ae) {
                                TranslatorTool.removeProperty(TranslatorTool.this.classType, name);
                            }
                        });
                        popup.show(TranslatorTool.this.table, e.getX(), e.getY() + 8);
                    }
                }
            }
        });
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Object val = e.getNewValue();
                if (val instanceof TableModelEvent) {
                    TableModelEvent event = (TableModelEvent)val;
                    int row = event.getFirstRow();
                    if (row < 0) {
                        return;
                    }
                    Map properties = TranslatorTool.getProperties(TranslatorTool.this.classType, locale);
                    String key = (String)TranslatorTool.this.table.getValueAt(row, 0);
                    String alias = (String)TranslatorTool.this.table.getValueAt(row, 1);
                    if (alias != null && !alias.equals("")) {
                        properties.put(key, alias);
                    } else {
                        TranslatorTool.this.table.setValueAt(key, row, 1);
                        properties.put(key, key);
                    }
                    TranslatorTool.refreshAssociates(TranslatorTool.this.classType);
                    changed.add(properties);
                    TranslatorTool.this.saveButton.setEnabled(true);
                }
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.contentPane.add((Component)toolbar, "North");
        JScrollPane tableScroller = new JScrollPane(this.table);
        this.contentPane.add((Component)tableScroller, "Center");
        JToolBar buttonbar = new JToolBar();
        buttonbar.setFloatable(false);
        this.contentPane.add((Component)buttonbar, "South");
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 6));
        toolbar.add(this.descriptionLabel);
        this.localeDropDown = new JComboBox();
        LocaleItem selectedItem = new LocaleItem(locale);
        this.localeDropDown.addItem(selectedItem);
        Locale[] locales = OSPFrame.getDefaultLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (locales[i].getDisplayLanguage().equals(locale.getDisplayLanguage())) continue;
            this.localeDropDown.addItem(new LocaleItem(locales[i]));
        }
        this.localeDropDown.setSelectedItem(selectedItem);
        this.localeDropDown.setEditable(true);
        this.localeDropDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object next = TranslatorTool.this.localeDropDown.getSelectedItem();
                if (next instanceof LocaleItem) {
                    ToolsRes.setLocale(((LocaleItem)next).loc);
                } else if (!next.equals("")) {
                    ToolsRes.setLocale(new Locale(next.toString()));
                }
            }
        });
        toolbar.add(this.localeDropDown);
        this.helpButton = new JButton();
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String htmlFile = "/org/opensourcephysics/resources/tools/html/translator_tool_help.html";
                TextFrame frame = new TextFrame(htmlFile);
                ((Component)frame).setSize(800, 600);
                ((Component)frame).setVisible(true);
            }
        });
        buttonbar.add(this.helpButton);
        String imageFile = "/org/opensourcephysics/resources/tools/images/save.gif";
        this.saveIcon = ResourceLoader.getIcon(imageFile);
        this.saveButton = new JButton(this.saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TranslatorTool.this.save(TranslatorTool.getPath(TranslatorTool.this.classType) + TranslatorTool.this.fileExtension);
            }
        });
        this.saveButton.setEnabled(false);
        buttonbar.add(Box.createHorizontalGlue());
        buttonbar.add(this.saveButton);
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TranslatorTool.this.setVisible(false);
            }
        });
        buttonbar.add(this.closeButton);
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(x, y);
    }

    protected void refreshGUI() {
        String title = ToolsRes.getString("TranslatorTool.Title");
        String fileName = XML.getName(TranslatorTool.getPath(this.classType));
        title = title + " " + fileName;
        this.setTitle(title);
        fileName = fileName + this.fileExtension;
        if (this.classType != null) {
            Map properties = TranslatorTool.getProperties(this.classType, locale);
            this.saveButton.setEnabled(changed.contains(properties));
        }
        this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.saveButton.setText(ToolsRes.getString("TranslatorTool.Button.Save"));
        this.saveButton.setToolTipText(ToolsRes.getString("TranslatorTool.Button.Save.ToolTip") + fileName);
        this.closeButton.setText(ToolsRes.getString("Tool.Button.Close"));
        this.closeButton.setToolTipText(ToolsRes.getString("Tool.Button.Close.ToolTip"));
        this.descriptionLabel.setText(ToolsRes.getString("TranslatorTool.Label.Description"));
        this.table.refresh();
    }

    private static void refreshAssociates(Class type) {
        Iterator it = associates.keySet().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!associates.get(obj).equals(type)) continue;
            if (obj instanceof XMLTable) {
                ((XMLTable)obj).refresh();
                continue;
            }
            if (!(obj instanceof OSPControl)) continue;
            ((OSPControl)obj).propertyChange(new PropertyChangeEvent(TOOL, "translation", null, null));
        }
    }

    private class LocaleItem {
        Locale loc;
        String language;

        LocaleItem(Locale locale) {
            this.loc = locale;
            this.language = this.loc.getDisplayLanguage(this.loc);
            if (this.language.equals(Locale.getDefault().getDisplayLanguage(this.loc))) {
                this.language = this.language + " (" + ToolsRes.getString("TranslatorTool.Language.Default") + ")";
            }
        }

        public String toString() {
            return this.language;
        }
    }
}

