/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.RCDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import com.tlabs.dcolt.ColumnDoubleMatrix1D;
import com.tlabs.dcolt.DynamicDoubleFactory2D;
import com.tlabs.dcolt.ProxiedMatrix;
import com.tlabs.dcolt.ProxyDirectImplementation;
import com.tlabs.dcolt.SelectedDynamicDoubleMatrix2D;
import org.apache.log4j.Logger;

public abstract class DynamicDoubleMatrix2D
extends DoubleMatrix2D
implements ProxiedMatrix {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tlabs$dcolt$DynamicDoubleMatrix2D == null ? (class$com$tlabs$dcolt$DynamicDoubleMatrix2D = DynamicDoubleMatrix2D.class$("com.tlabs.dcolt.DynamicDoubleMatrix2D")) : class$com$tlabs$dcolt$DynamicDoubleMatrix2D));
    protected volatile transient boolean diskMode = false;
    private volatile transient int batch;
    private transient ProxiedMatrix batchCache = null;
    private DynamicDoubleMatrix2D viewRef;
    static /* synthetic */ Class class$com$tlabs$dcolt$DynamicDoubleMatrix2D;

    protected DynamicDoubleMatrix2D() {
    }

    public void setDiskMode() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " going on disk"));
        }
        this.diskMode = true;
        this.internalSetDiskMode();
    }

    public void setMemoryMode() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " going in memory"));
        }
        this.diskMode = false;
        this.batch = 0;
        if (this.batchCache != null) {
            this.batchCache.setMemoryMode();
            this.batchCache = null;
        }
        this.internalSetMemoryMode();
    }

    public boolean isDiskMode() {
        return this.diskMode;
    }

    public abstract void logBatchState();

    protected ProxiedMatrix logCacheState() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " cache: " + DynamicDoubleFactory2D.identityToString(this.batchCache) + " [" + this.batch + "]"));
        }
        return this.batchCache;
    }

    public abstract void extendTo(int var1, int var2);

    public void endBatchOperation() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " end of batch operation"));
        }
        if (this.diskMode && --this.batch == 0) {
            if (this.batchCache != null) {
                this.batchCache.endBatchOperation();
            }
            this.batchCache = null;
        }
        if (this.viewRef != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " ending " + DynamicDoubleFactory2D.identityToString(this.viewRef) + " batch operation"));
            }
            this.viewRef.endBatchOperation();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " operating batch " + this.batch));
        }
    }

    public void prepareBatchOperation() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " beginning of batch operation"));
        }
        if (this.viewRef != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " preparing " + DynamicDoubleFactory2D.identityToString(this.viewRef) + " batch operation"));
            }
            this.viewRef.prepareBatchOperation();
        }
        if (this.diskMode) {
            ++this.batch;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " operating batch " + this.batch));
        }
    }

    protected void setCache(ProxiedMatrix store) {
        if (this.batch > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " requested to cache " + DynamicDoubleFactory2D.identityToString(store)));
            }
            if (this.batchCache != store) {
                if (this.batchCache != null) {
                    this.batchCache.endBatchOperation();
                }
                this.batchCache = store;
                if (this.batchCache != null) {
                    this.batchCache.prepareBatchOperation();
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " current cache " + DynamicDoubleFactory2D.identityToString(this.batchCache)));
            }
        }
    }

    protected void ensureStorage() {
        this.ensureStorage(this.rowZero + this.rows * this.rowStride, this.columnZero + this.columns * this.columnStride);
    }

    protected abstract void ensureStorage(int var1, int var2);

    protected abstract void internalSetDiskMode();

    protected abstract void internalSetMemoryMode();

    public boolean checkCoordinates(int row, int column) {
        return row >= 0 && row < this.rows && column >= 0 && column < this.columns;
    }

    public int cardinality() {
        this.prepareBatchOperation();
        int card = super.cardinality();
        this.endBatchOperation();
        return card;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleMatrix2D)) {
            return false;
        }
        DoubleMatrix2D mat = (DoubleMatrix2D)obj;
        this.prepareBatchOperation();
        if (mat instanceof ProxiedMatrix) {
            ((ProxiedMatrix)mat).prepareBatchOperation();
        }
        boolean b = super.equals(obj);
        this.endBatchOperation();
        if (mat instanceof ProxiedMatrix) {
            ((ProxiedMatrix)mat).endBatchOperation();
        }
        return b;
    }

    protected DoubleMatrix1D like1D(int size, int zero, int stride) {
        throw new InternalError("Should NEVER happen");
    }

    protected DoubleMatrix2D view() {
        DynamicDoubleMatrix2D doubleMatrix2D = (DynamicDoubleMatrix2D)super.view();
        doubleMatrix2D.viewRef = this;
        doubleMatrix2D.batchCache = null;
        doubleMatrix2D.batch = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " creating view " + DynamicDoubleFactory2D.identityToString(doubleMatrix2D)));
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix1D viewColumn(int column) {
        return new ColumnDoubleMatrix1D(this, column);
    }

    public DoubleMatrix1D viewRow(int row) {
        return this.viewDice().viewColumn(row);
    }

    public DoubleMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDynamicDoubleMatrix2D(this, rowOffsets, columnOffsets);
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (!this.diskMode && (B instanceof SparseDoubleMatrix2D || B instanceof RCDoubleMatrix2D)) {
            if (C == null) {
                this.prepareBatchOperation();
                DoubleMatrix2D doubleMatrix2D = B.zMult((DoubleMatrix2D)this, null, alpha, beta, !transposeB, true).viewDice();
                this.endBatchOperation();
                return doubleMatrix2D;
            }
            this.prepareBatchOperation();
            if (C instanceof ProxiedMatrix) {
                ((ProxiedMatrix)C).prepareBatchOperation();
            }
            B.zMult((DoubleMatrix2D)this, C.viewDice(), alpha, beta, !transposeB, true);
            this.endBatchOperation();
            if (C instanceof ProxiedMatrix) {
                ((ProxiedMatrix)C).endBatchOperation();
                if (C instanceof ProxyDirectImplementation) {
                    ((ProxyDirectImplementation)C).flagAsModified();
                }
            }
            return C;
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        int m = this.rows;
        int n = this.columns;
        int p = B.columns();
        if (C == null) {
            C = this.like(m, p);
            if (this.diskMode) {
                ((DynamicDoubleMatrix2D)C).setDiskMode();
            }
        }
        if (B.rows() != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree: " + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != m || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        this.prepareBatchOperation();
        if (C instanceof ProxiedMatrix) {
            ((DynamicDoubleMatrix2D)C).prepareBatchOperation();
        }
        super.zMult(B, C, alpha, beta, transposeA, transposeB);
        if (C instanceof ProxiedMatrix) {
            ((DynamicDoubleMatrix2D)C).endBatchOperation();
        }
        this.endBatchOperation();
        return C;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

