/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import com.tlabs.dcolt.StringVector;
import com.tlabs.util.Resource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SimpleStringVector
implements StringVector {
    private static Resource _res = Resource.getInstance();
    private String[] _rep;
    private int _lastpos;
    private int _maxpos;

    public SimpleStringVector(int size) {
        this._rep = new String[size];
        this._maxpos = size - 1;
        this._lastpos = -1;
    }

    public String get(int pos) {
        if (pos < 0 || pos > this._maxpos) {
            return null;
        }
        String val = this._rep[pos];
        return val == null ? "" : val;
    }

    public int indexOf(String s) {
        int i = this._rep.length;
        while (--i >= 0) {
            if (!s.equals(this._rep[i])) continue;
            return i;
        }
        return -1;
    }

    public void set(int pos, String st) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException(_res.getString("StringVector.NegativeIndex"));
        }
        if (pos > this._maxpos) {
            throw new IndexOutOfBoundsException(_res.getString("StringVector.IndexError"));
        }
        if (pos > this._lastpos) {
            this._lastpos = pos;
        }
        this.setQuick(pos, st);
    }

    private void setQuick(int pos, String st) {
        this._rep[pos] = st;
    }

    public void add(String st) {
        if (this._lastpos >= this._maxpos) {
            throw new IndexOutOfBoundsException(_res.getString("StringVector.IndexError"));
        }
        this.setQuick(++this._lastpos, st);
    }

    public void addAll(List list) {
        if (this._lastpos + list.size() > this._maxpos) {
            throw new IndexOutOfBoundsException(_res.getString("StringVector.IndexError"));
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.setQuick(++this._lastpos, (String)it.next());
        }
    }

    public List getAll() {
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i <= this._lastpos; ++i) {
            String val = this._rep[i];
            retList.add(val == null ? "" : val);
        }
        return retList;
    }

    public void setAll(List list) {
        if (list.size() > this._maxpos + 1) {
            throw new IndexOutOfBoundsException(_res.getString("StringVector.IndexError"));
        }
        this._lastpos = list.size() - 1;
        int pos = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.setQuick(pos++, (String)it.next());
        }
    }

    public int size() {
        return this._maxpos + 1;
    }

    public int getLastPos() {
        return this._lastpos;
    }

    public void clear() {
        this._lastpos = -1;
    }

    public void dispose() {
        this._rep = null;
    }

    public void prepareBatchReading() {
    }

    public void endBatchReading() {
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StringVector)) {
            return false;
        }
        StringVector o = (StringVector)obj;
        int i = this._rep.length;
        while (--i >= 0) {
            String s = this.get(i);
            String os = o.get(i);
            if ((s != null && os != null || s == os) && s.equals(os)) continue;
            return false;
        }
        return true;
    }
}

