/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.awt;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public class GridBags
extends GridBagConstraints
implements Cloneable {
    public GridBags() {
        this(0, 0);
    }

    public GridBags(int n, int n2) {
        this(n, n2, 1, 1);
    }

    public GridBags(int n, int n2, int n3, int n4) {
        this.gridx = n;
        this.gridy = n2;
        this.gridwidth = n3;
        this.gridheight = n4;
        this.ipadx = 0;
        this.ipady = 0;
        this.anchor = 10;
        this.weightx = 1.0;
        this.weighty = 1.0;
        this.fill = 1;
        this.insets = new Insets(2, 2, 2, 2);
    }

    public GridBags right() {
        GridBags gridBags = (GridBags)this.clone();
        ++gridBags.gridx;
        return gridBags;
    }

    public GridBags left() {
        GridBags gridBags = (GridBags)this.clone();
        gridBags.gridx = gridBags.gridx == 0 ? gridBags.gridx : gridBags.gridx - 1;
        return gridBags;
    }

    public GridBags up() {
        GridBags gridBags = (GridBags)this.clone();
        gridBags.gridy = gridBags.gridy == 0 ? gridBags.gridy : gridBags.gridy - 1;
        return gridBags;
    }

    public GridBags down() {
        GridBags gridBags = (GridBags)this.clone();
        ++gridBags.gridy;
        return gridBags;
    }

    public GridBags fill(int n) {
        GridBags gridBags = (GridBags)this.clone();
        gridBags.fill = n;
        return gridBags;
    }

    public final GridBags doubleWeight() {
        GridBags gridBags = (GridBags)this.clone();
        gridBags.weightx = Math.max(1.0, 2.0 * gridBags.weightx);
        gridBags.weighty = Math.max(1.0, 2.0 * gridBags.weighty);
        return gridBags;
    }

    public final GridBags halfWeight() {
        GridBags gridBags = (GridBags)this.clone();
        gridBags.weightx /= 2.0;
        if (gridBags.weightx < 0.01) {
            gridBags.weightx = 0.0;
        }
        gridBags.weighty /= 2.0;
        if (gridBags.weighty < 0.01) {
            gridBags.weighty = 0.0;
        }
        return gridBags;
    }

    public GridBags insets(int n) {
        return this.insets(n, n, n, n);
    }

    public GridBags insets(int n, int n2, int n3, int n4) {
        GridBags gridBags = (GridBags)this.clone();
        gridBags.insets = new Insets(n, n2, n3, n4);
        return gridBags;
    }

    public GridBags anchor(int n) {
        GridBags gridBags = (GridBags)this.clone();
        gridBags.anchor = n;
        return gridBags;
    }

    public GridBags weight(float f, float f2) {
        GridBags gridBags = (GridBags)this.clone();
        gridBags.weightx = f;
        gridBags.weighty = f2;
        return gridBags;
    }

    public GridBags moveTo(int n, int n2) {
        GridBags gridBags = (GridBags)this.clone();
        gridBags.gridx = n;
        gridBags.gridy = n2;
        return gridBags;
    }

    public static final GridBags full(int n, int n2, int n3, int n4) {
        return new GridBags(n, n2, n3, n4);
    }

    public static final GridBags full(int n, int n2) {
        return GridBags.full(n, n2, 1, 1);
    }

    public static final GridBags flat(int n, int n2, int n3, int n4) {
        GridBags gridBags = new GridBags(n, n2, n3, n4);
        gridBags.fill = 2;
        gridBags.weighty = 0.0;
        return gridBags;
    }

    public static final GridBags flat(int n, int n2) {
        return GridBags.flat(n, n2, 1, 1);
    }

    public static final GridBags tall(int n, int n2, int n3, int n4) {
        GridBags gridBags = new GridBags(n, n2, n3, n4);
        gridBags.fill = 3;
        gridBags.weightx = 0.0;
        return gridBags;
    }

    public static final GridBags tall(int n, int n2) {
        return GridBags.tall(n, n2, 1, 1);
    }

    public static final GridBags tight(int n, int n2, int n3, int n4) {
        GridBags gridBags = new GridBags(n, n2, n3, n4);
        gridBags.weightx = 0.0;
        gridBags.weighty = 0.0;
        gridBags.fill = 0;
        return gridBags;
    }

    public static final GridBags tight(int n, int n2) {
        return GridBags.tight(n, n2, 1, 1);
    }

    public static final GridBags remainder(int n, int n2) {
        return new GridBags(n, n2, 0, 0);
    }

    public static final GridBags remainderX(int n, int n2, int n3) {
        return new GridBags(n, n2, 0, n3);
    }

    public static final GridBags remainderY(int n, int n2, int n3) {
        return new GridBags(n, n2, n3, 0);
    }

    public Object clone() {
        return (GridBags)super.clone();
    }
}

