/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

class FileLineRepeat
implements Runnable {
    private BufferedReader in1;
    private BufferedWriter out;

    FileLineRepeat(File file, File file2) throws IOException {
        this.in1 = new BufferedReader(new FileReader(file));
        this.out = new BufferedWriter(new FileWriter(file2));
    }

    public void run() {
        String string = "";
        String string2 = null;
        try {
            while ((string = this.in1.readLine()) != null) {
                if (string.equals(string2)) {
                    this.out.write(string2);
                    this.out.newLine();
                }
                string2 = string;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("IO error : " + iOException);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected error : " + exception);
        }
    }

    public void close() {
        if (this.in1 != null) {
            try {
                this.in1.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final void usage() {
        System.out.println("FileLineRepeat toCompare output");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        FileLineRepeat fileLineRepeat = null;
        try {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException("Wrong number of argument");
            }
            fileLineRepeat = new FileLineRepeat(new File(stringArray[0]), new File(stringArray[1]));
            fileLineRepeat.run();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException);
            FileLineRepeat.usage();
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            System.exit(2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.exit(3);
        }
        finally {
            if (fileLineRepeat != null) {
                fileLineRepeat.close();
            }
        }
    }
}

