/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.io;

import com.tlabs.io.Streams;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class FileUtil {
    private static FileUtil _singleton = null;
    static /* synthetic */ Class class$com$tlabs$io$FileUtil;

    protected FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final FileUtil getInstance() {
        if (null == _singleton) {
            Class clazz = class$com$tlabs$io$FileUtil == null ? (class$com$tlabs$io$FileUtil = FileUtil.class$("com.tlabs.io.FileUtil")) : class$com$tlabs$io$FileUtil;
            synchronized (clazz) {
                if (null == _singleton) {
                    _singleton = new FileUtil();
                }
            }
        }
        return _singleton;
    }

    public int appendLine(String string, String string2) throws IOException {
        return this.insertLineAt(string, string2, -1);
    }

    public int appendLine(File file, String string) throws IOException {
        return this.insertLineAt(file, string, -1);
    }

    public int insertLineAt(String string, String string2, int n) throws IOException {
        return this.insertLineAt(new File(string), string2, n);
    }

    public int insertLineAt(File file, String string, int n) throws IOException {
        File file2 = new File(file.getAbsolutePath() + System.currentTimeMillis());
        this.checkRead(file);
        this.checkWrite(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string2 = null;
        int n2 = 0;
        int n3 = -1;
        while (null != (string2 = bufferedReader.readLine())) {
            if (n2 == n && n >= 0) {
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                n3 = n2;
            }
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            ++n2;
        }
        if (n < 0) {
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        bufferedReader.close();
        file.delete();
        this.renameFile(file2, file, false);
        return n3;
    }

    public int insertBefore(String string, String string2, String string3) throws IOException {
        return this.insertBefore(new File(string), string2, string3);
    }

    public int insertBefore(File file, String string, String string2) throws IOException {
        File file2 = new File(file.getAbsolutePath() + System.currentTimeMillis());
        this.checkRead(file);
        this.checkWrite(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string3 = null;
        int n = -1;
        int n2 = 0;
        while (null != (string3 = bufferedReader.readLine())) {
            if (string3.trim().equals(string2)) {
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                n = n2;
            }
            bufferedWriter.write(string3, 0, string3.length());
            bufferedWriter.newLine();
            ++n2;
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        bufferedReader.close();
        file.delete();
        this.renameFile(file2, file, false);
        return n;
    }

    public int insertAfter(String string, String string2, String string3) throws IOException {
        return this.insertAfter(new File(string), string2, string3);
    }

    public int insertAfter(File file, String string, String string2) throws IOException {
        File file2 = new File(file.getAbsolutePath() + System.currentTimeMillis());
        this.checkRead(file);
        this.checkWrite(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string3 = null;
        int n = -1;
        int n2 = 0;
        while (null != (string3 = bufferedReader.readLine())) {
            bufferedWriter.write(string3, 0, string3.length());
            bufferedWriter.newLine();
            ++n2;
            if (!string3.trim().equals(string2)) continue;
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            n = n2;
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        bufferedReader.close();
        file.delete();
        this.renameFile(file2, file, false);
        return n;
    }

    public int removeLine(String string, String string2) throws IOException {
        return this.removeLine(new File(string), string2);
    }

    public int removeLine(File file, String string) throws IOException {
        return this.removeLineImpl(file, string, true);
    }

    public int removeLineContaining(String string, String string2) throws IOException {
        return this.removeLineContaining(new File(string), string2);
    }

    public int removeLineContaining(File file, String string) throws IOException {
        return this.removeLineImpl(file, string, false);
    }

    private int removeLineImpl(File file, String string, boolean bl) throws IOException {
        File file2 = new File(file.getAbsolutePath() + System.currentTimeMillis());
        this.checkRead(file);
        this.checkWrite(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string2 = null;
        int n = -1;
        int n2 = 0;
        while (null != (string2 = bufferedReader.readLine())) {
            ++n2;
            String string3 = string2.trim();
            if (string3.equals(string) || string3.indexOf(string) >= 0 && !bl) {
                n = n2;
                continue;
            }
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        bufferedReader.close();
        file.delete();
        this.renameFile(file2, file, false);
        return n;
    }

    public final void renameFile(File file, File file2, boolean bl) throws IOException {
        File file3 = null;
        if (bl && file2.exists()) {
            file3 = new File(file2.getName() + "." + System.currentTimeMillis(), ".bak");
            if (file3.exists()) {
                file3.delete();
            }
            if (!file2.renameTo(file3)) {
                throw new IOException(this.getClass().getName() + ".renameFile() : cannot create backup file");
            }
        }
        if (file2.exists()) {
            throw new IOException(this.getClass().getName() + ".renameFile() : Destination file " + file2.getAbsolutePath() + " already exists. Cannot move");
        }
        if (file.renameTo(file2)) {
            if (null != file3) {
                file3.delete();
            }
        } else {
            if (null != file3) {
                file3.renameTo(file2);
            }
            throw new IOException(this.getClass().getName() + ".renameFile() : cannot move " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
        }
    }

    public File createUniqueDirectory(boolean bl) throws IOException {
        String string = System.getProperty("java.io.tmpdir", null);
        if (null == string) {
            throw new IOException(this.getClass().getName() + ".createUniqueTemporaryDirectory() : Unable to get System Properties for \"java.io.tmpdir\"");
        }
        return this.createUniqueDirectory(string, bl);
    }

    public File createUniqueDirectory(String string, boolean bl) throws IOException {
        File file;
        String string2 = string;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (!(file = new File(string2 = string2 + new String("" + System.currentTimeMillis()))).exists()) {
            file.mkdir();
            if (bl) {
                file.deleteOnExit();
            }
        }
        return file;
    }

    public void copy(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (file2.isDirectory()) {
                throw new IOException("cannot copy dir \"" + file + "\" (not implemented yet)");
            }
            throw new IOException("cannot copy dir \"" + file + "\" to file \"" + file2 + "\"");
        }
        if (file2.isDirectory()) {
            this.fileCopyToDir(file, file2);
        } else {
            this.fileCopy(file, file2);
        }
    }

    public boolean containsFiles(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException(file + " is not a directory");
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                return true;
            }
            if (!this.containsFiles(fileArray[i])) continue;
            return true;
        }
        return false;
    }

    public String translatePath(String string) {
        String string2 = string.replace('/', File.separatorChar);
        string2 = string.replace('\\', File.separatorChar);
        return string2;
    }

    public void deltree(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException(file + " does not exists");
        }
        if (!file.isDirectory()) {
            throw new IOException(file + " is not a directory");
        }
        FileUtil.deltreeImpl(file);
    }

    private static void deltreeImpl(File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtil.deltreeImpl(fileArray[i]);
            }
        }
        file.delete();
    }

    private void fileCopyToDir(File file, File file2) throws IOException {
        if (!file2.isDirectory()) {
            throw new IOException("target \"" + file2 + "\" is not a directory");
        }
        if (!file.isFile()) {
            throw new IOException("source \"" + file + "\" is not a file");
        }
        File file3 = new File(file2, file.getName());
        this.fileCopy(file, file3);
    }

    private void fileCopy(File file, File file2) throws IOException {
        if (file2.isDirectory()) {
            throw new IOException("target \"" + file2 + "\" is a directory");
        }
        if (file2.exists()) {
            throw new IOException("target \"" + file2 + "\" already exists");
        }
        file2.createNewFile();
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Streams.copy(fileInputStream, fileOutputStream);
        fileOutputStream.close();
        fileInputStream.close();
    }

    private void checkRead(File file) throws IOException {
        if (!file.canRead()) {
            throw new IOException(this.getClass().getName() + " : cannot read file " + file.getAbsolutePath());
        }
    }

    private void checkWrite(File file) throws IOException {
        if (!file.canWrite()) {
            throw new IOException(this.getClass().getName() + " : cannot write file " + file.getAbsolutePath());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

