/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.net.mail;

import com.tlabs.net.mail.MailSupportException;
import com.tlabs.net.mail.OctetStreamDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;

final class FileDataSource
extends OctetStreamDataSource {
    private String myContentType;
    private String mySimpleFilename;
    private Object myContent;

    public FileDataSource(String string) throws MailSupportException {
        this(new File(string));
    }

    public FileDataSource(File file) throws MailSupportException {
        if (null == file) {
            throw new MailSupportException("null file");
        }
        if (!file.exists()) {
            throw new MailSupportException(file.getAbsolutePath() + " does not exist");
        }
        if (file.isDirectory()) {
            throw new MailSupportException(file.getAbsolutePath() + " is a directory");
        }
        this.myContentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(file);
        this.mySimpleFilename = file.getAbsolutePath();
        int n = this.mySimpleFilename.lastIndexOf(File.separator);
        if (n >= 0) {
            this.mySimpleFilename = this.mySimpleFilename.substring(n + 1);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.setContent(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            throw new MailSupportException(iOException.getLocalizedMessage());
        }
    }

    public final String getContentType() {
        return this.myContentType;
    }

    public final String getName() {
        return this.mySimpleFilename;
    }
}

