/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.net.mail;

import com.tlabs.net.mail.FileDataSource;
import com.tlabs.net.mail.MailSupportEvent;
import com.tlabs.net.mail.MailSupportException;
import com.tlabs.net.mail.MailSupportListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public final class MailSupport {
    public static final String HOST = "mail.host";
    public static final String USER = "mail.user";
    public static final String PASSWORD = "mail.password";
    public static final String DEBUG = "mail.debug";
    public static final String PROTOCOL = "mail.protocol";
    public static final String MAIL_FROM = "mail.send.from";
    public static final String MAIL_TO = "mail.send.to";
    public static final String MAIL_CC = "mail.send.cc";
    public static final String MAIL_BCC = "mail.send.bcc";
    public static final String MAIL_SUBJECT = "mail.send.subject";
    public static final String MAIL_BODY = "mail.send.body";
    public static final String MAIL_ATTACHED = "mail.send.attached";
    public static final String MAIL_CONTENT_TYPE = "mail.send.content-type";
    public static final String MAIL_CONTENT_TYPE_DEFAULT = "text/plain";
    private static final String LIST_SEPARATOR = ",";
    private Session myMailSession;
    private Transport myTransport;
    private Map myListeners;
    private Properties myProperties = new Properties();

    public MailSupport() throws MailSupportException {
        this(System.getProperties());
    }

    public MailSupport(Properties properties) throws MailSupportException {
        String string = properties.getProperty(HOST, null);
        if (null == string) {
            throw new MissingPropertyException(HOST);
        }
        String string2 = properties.getProperty(PROTOCOL, "smtp");
        String string3 = properties.getProperty(USER, "");
        String string4 = properties.getProperty(PASSWORD, "");
        properties.put("mail." + string2 + ".host", string);
        this.myProperties.put(HOST, string);
        properties.put("mail." + string2 + ".user", string3);
        this.myProperties.put(USER, string3);
        properties.put("mail." + string2 + ".password", string4);
        this.myProperties.put(PASSWORD, string4);
        properties.put("mail.transport.protocol", string2);
        this.myProperties.put(PROTOCOL, string2);
        String string5 = properties.getProperty(DEBUG, new Boolean(false).toString());
        System.getProperties().setProperty(DEBUG, string5);
        try {
            this.myMailSession = Session.getInstance((Properties)properties, (Authenticator)new DefaultAuthentication(string3, string4));
            this.myTransport = this.myMailSession.getTransport(string2);
        }
        catch (MessagingException messagingException) {
            throw new MailSupportException(messagingException.getLocalizedMessage());
        }
        this.myListeners = new HashMap();
    }

    public final void addMailSupportListener(MailSupportListener mailSupportListener) {
        TransportAdapter transportAdapter = new TransportAdapter(mailSupportListener);
        this.myTransport.addTransportListener((TransportListener)transportAdapter);
        this.myListeners.put(mailSupportListener, transportAdapter);
    }

    public final void removeMailSupportListener(MailSupportListener mailSupportListener) {
        TransportListener transportListener = (TransportListener)this.myListeners.remove(mailSupportListener);
        if (null != transportListener) {
            this.myTransport.removeTransportListener(transportListener);
        }
    }

    public final String getUser() {
        return this.myProperties.getProperty(USER);
    }

    public final String getPassword() {
        return this.myProperties.getProperty(PASSWORD);
    }

    public final String getHost() {
        return this.myProperties.getProperty(HOST);
    }

    public final String getProtocol() {
        return this.myProperties.getProperty(PROTOCOL);
    }

    public static final void sendMail(String string, String string2, String string3, String string4, String string5) throws MailSupportException {
        MailSupport.sendMail(string, string2, string3, string4, string5, (String[])null);
    }

    public static final void sendMail(String string, String string2, String string3, String string4, String string5, String[] stringArray) throws MailSupportException {
        MailSupport.sendMail(string, string2, string3, string4, MAIL_CONTENT_TYPE_DEFAULT, string5, stringArray);
    }

    public static final void sendMail(String string, String string2, String string3, String string4, String string5, String string6) throws MailSupportException {
        MailSupport.sendMail(string, string2, string3, string4, string5, string6, null);
    }

    public static final void sendMail(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray) throws MailSupportException {
        StringBuffer stringBuffer = null;
        if (null != stringArray && stringArray.length > 0) {
            stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(LIST_SEPARATOR);
            }
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        Properties properties = new Properties();
        properties.put(HOST, string6);
        Properties properties2 = new Properties();
        properties2.put(MAIL_FROM, string);
        properties2.put(MAIL_TO, string2);
        properties2.put(MAIL_SUBJECT, string3);
        properties2.put(MAIL_BODY, string4);
        properties2.put(MAIL_CONTENT_TYPE, string5);
        if (null != stringBuffer) {
            properties2.put(MAIL_ATTACHED, stringBuffer.toString());
        }
        MailSupport mailSupport = new MailSupport(properties);
        mailSupport.sendMail(properties2);
        mailSupport.dispose();
    }

    public final Message sendMail(Properties properties) throws MailSupportException {
        return this.sendMail(properties, false);
    }

    public final Message sendMail(Properties properties, boolean bl) throws MailSupportException {
        try {
            Message message = this.createMessage(properties);
            MessageSender messageSender = new MessageSender(message);
            if (bl) {
                new Thread(messageSender).start();
            } else {
                messageSender.sendMessage();
            }
            return message;
        }
        catch (AddressException addressException) {
            throw new InvalidAddressException(addressException);
        }
        catch (MessagingException messagingException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println(messagingException.getLocalizedMessage());
            messagingException.printStackTrace(printWriter);
            Exception exception = messagingException.getNextException();
            while (null != exception) {
                if (exception instanceof MessagingException) {
                    if (null == (exception = ((MessagingException)((Object)exception)).getNextException())) continue;
                    exception.printStackTrace(printWriter);
                    continue;
                }
                exception = null;
            }
            printWriter.flush();
            String string = stringWriter.toString();
            printWriter.close();
            throw new MessageException(string);
        }
    }

    public void dispose() {
        if (this.myTransport.isConnected()) {
            try {
                this.myTransport.close();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        this.myListeners.clear();
    }

    protected Message createMessage(Properties properties) throws MailSupportException, MessagingException, AddressException {
        String string = properties.getProperty(MAIL_FROM);
        if (null == string) {
            throw new MissingParameterException(MAIL_FROM);
        }
        String string2 = properties.getProperty(MAIL_TO);
        if (null == string2) {
            throw new MissingParameterException(MAIL_TO);
        }
        String string3 = properties.getProperty(MAIL_CC, "");
        String string4 = properties.getProperty(MAIL_BCC, "");
        String string5 = properties.getProperty(MAIL_SUBJECT);
        if (null == string5) {
            throw new MissingParameterException(MAIL_SUBJECT);
        }
        String string6 = properties.getProperty(MAIL_BODY);
        if (null == string6) {
            throw new MissingParameterException(MAIL_BODY);
        }
        MimeMessage mimeMessage = new MimeMessage(this.getSession());
        String[] stringArray = MailSupport.toFilenames(properties.getProperty(MAIL_ATTACHED, ""));
        if (stringArray.length > 0) {
            MimeMultipart mimeMultipart = new MimeMultipart();
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(string6);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            for (int i = 0; i < stringArray.length; ++i) {
                MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
                FileDataSource fileDataSource = new FileDataSource(stringArray[i]);
                mimeBodyPart2.setDataHandler(new DataHandler((DataSource)fileDataSource));
                mimeBodyPart2.setFileName(fileDataSource.getName());
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
            }
            mimeMessage.setContent((Multipart)mimeMultipart);
        } else {
            mimeMessage.setContent((Object)string6, properties.getProperty(MAIL_CONTENT_TYPE, MAIL_CONTENT_TYPE_DEFAULT));
        }
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])MailSupport.toInternetAddress(string2));
        mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])MailSupport.toInternetAddress(string3));
        mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])MailSupport.toInternetAddress(string4));
        mimeMessage.setSubject(string5);
        mimeMessage.setSentDate(new Date());
        mimeMessage.setFrom((Address)new InternetAddress(string));
        mimeMessage.saveChanges();
        return mimeMessage;
    }

    protected Transport getTransport() {
        return this.myTransport;
    }

    protected Session getSession() {
        return this.myMailSession;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private static InternetAddress[] toInternetAddress(String string) throws MessagingException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, LIST_SEPARATOR);
        Vector<InternetAddress> vector = new Vector<InternetAddress>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            vector.addElement(new InternetAddress(string2));
        }
        return vector.toArray(new InternetAddress[vector.size()]);
    }

    private static String[] toFilenames(String string) throws MessagingException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, LIST_SEPARATOR);
        Vector<String> vector = new Vector<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            vector.addElement(string2);
        }
        return vector.toArray(new String[vector.size()]);
    }

    private class MessageSender
    implements Runnable {
        private Message myMessage;

        public MessageSender(Message message) {
            this.myMessage = message;
        }

        public void run() {
            try {
                this.sendMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage() throws MessagingException {
            Transport transport = MailSupport.this.getTransport();
            if (!transport.isConnected()) {
                Transport transport2 = transport;
                synchronized (transport2) {
                    if (!transport.isConnected()) {
                        transport.connect();
                    }
                }
            }
            transport.sendMessage(this.myMessage, this.myMessage.getAllRecipients());
        }
    }

    private class InvalidAddressException
    extends MailSupportException {
        public InvalidAddressException(AddressException addressException) {
            super(null == addressException.getRef() ? addressException.getLocalizedMessage() : addressException.getRef());
        }
    }

    private class MessageException
    extends MailSupportException {
        public MessageException(String string) {
            super(string);
        }
    }

    private class InvalidParameterException
    extends MailSupportException {
        public InvalidParameterException(String string) {
            super("Invalid Parameter : " + string);
        }
    }

    private class MissingParameterException
    extends MailSupportException {
        public MissingParameterException(String string) {
            super("Missing Parameter : " + string);
        }
    }

    private class MissingPropertyException
    extends MailSupportException {
        public MissingPropertyException(String string) {
            super("Missing Property : " + string);
        }
    }

    private class DefaultAuthentication
    extends Authenticator {
        private PasswordAuthentication myAuthentication;

        public DefaultAuthentication(String string, String string2) {
            this.myAuthentication = new PasswordAuthentication(string, string2);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.myAuthentication;
        }
    }

    private class TransportAdapter
    implements TransportListener {
        private MailSupportListener myListener;

        public TransportAdapter(MailSupportListener mailSupportListener) {
            this.myListener = mailSupportListener;
        }

        public void messagePartiallyDelivered(TransportEvent transportEvent) {
            this.myListener.messagePartiallyDelivered(new MailSupportEvent(transportEvent));
        }

        public void messageDelivered(TransportEvent transportEvent) {
            this.myListener.messageDelivered(new MailSupportEvent(transportEvent));
        }

        public void messageNotDelivered(TransportEvent transportEvent) {
            this.myListener.messageNotDelivered(new MailSupportEvent(transportEvent));
        }
    }
}

