/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.sql;

import com.tlabs.util.TraceObject;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class ConnectionPool
extends TraceObject {
    private static final String JDBC = "jdbc.";
    public static final String USER = "jdbc.user";
    public static final String PASSWORD = "jdbc.password";
    public static final String URL = "jdbc.url";
    public static final String DRIVER = "jdbc.driver";
    public static final String MIN_SIZE = "jdbc.poolminsize";
    public static final String MAX_SIZE = "jdbc.poolmaxsize";
    public static final String RECYCLE = "jdbc.poolrecycle";
    public static final String AUTOCOMMIT = "jdbc.autocommit";
    public static final String TRANSACTION_LEVEL = "jdbc.transaction";
    public static final String TRANSACTION_LEVEL_COMMITTED = "committed";
    public static final String TRANSACTION_LEVEL_UNCOMMITTED = "uncommitted";
    private static final int CONNECTION_RETRY_COUNT_DEFAULT = 10;
    private static final int CONNECTION_RETRY_DELAY_DEFAULT = 5000;
    private static final int RELEASE_RETRY_COUNT_DEFAULT = 3;
    private static final int RELEASE_RETRY_DELAY_DEFAULT = 10000;
    private static final int MINSIZE_DEFAULT = 1;
    private static final int MAXSIZE_DEFAULT = 10;
    private static final int RECYCLE_DEFAULT = 5;
    private static final boolean AUTOCOMMIT_DEFAULT = false;
    private static final int CONNECTION_TRANSACTION_DEFAULT = 1;
    private static final String LOG = "com.tlabs.SQL";
    private Properties myDriverProperties;
    private boolean myIsAvailable;
    private boolean myIsAutoCommitEnabled;
    private long myMaxConnectionAge;
    private int myTransactionLevel;
    private int myReleaseRetryCount = 3;
    private ConnectionPoolHelper myConnectionPool;
    private Hashtable myAllocatedConnections;

    private ConnectionPool(PoolPropertiesAdapter poolPropertiesAdapter) throws SQLException {
        this(poolPropertiesAdapter.driverClassname, poolPropertiesAdapter.jdbcURL, poolPropertiesAdapter.user, poolPropertiesAdapter.password, poolPropertiesAdapter.minConnections, poolPropertiesAdapter.maxConnections, poolPropertiesAdapter.recycle, poolPropertiesAdapter.isAutoCommitEnabled, poolPropertiesAdapter.transactionLevel);
    }

    public ConnectionPool(Properties properties) throws SQLException {
        this(new PoolPropertiesAdapter(properties));
        this.myDriverProperties.putAll((Map<?, ?>)ConnectionPool.getJDBCProperties(properties));
    }

    public ConnectionPool(String string, String string2, String string3, String string4, int n, int n2, double d, boolean bl, int n3) throws SQLException {
        super(LOG);
        try {
            boolean bl2 = false;
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            while (enumeration.hasMoreElements()) {
                if (!enumeration.nextElement().getClass().getName().equals(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                DriverManager.registerDriver((Driver)Class.forName(string).newInstance());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(classNotFoundException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException.getLocalizedMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new SQLException(instantiationException.getLocalizedMessage());
        }
        this.myDriverProperties = ConnectionPool.getJDBCProperties(System.getProperties());
        this.myDriverProperties.put(URL, string2);
        this.trace("Database server:" + string2);
        this.myDriverProperties.put(USER, string3);
        this.myDriverProperties.put(PASSWORD, string4);
        this.myMaxConnectionAge = (long)(d * 24.0 * 60.0 * 60.0 * 1000.0);
        this.trace("Connection max-age:" + this.myMaxConnectionAge);
        this.myIsAutoCommitEnabled = bl;
        this.trace("Connection autommit:" + this.myIsAutoCommitEnabled);
        this.trace("Connection transaction:" + n3);
        this.myTransactionLevel = n3;
        this.myAllocatedConnections = new Hashtable();
        this.myConnectionPool = new ConnectionPoolHelper(n, n2);
        this.myIsAvailable = true;
    }

    public Connection getConnection() {
        try {
            if (!this.isAvailable()) {
                this.log("Cannot get a connection : Pool not available (disposed)");
                return null;
            }
            ConnectionDescriptor connectionDescriptor = this.myConnectionPool.pop();
            if (null == connectionDescriptor) {
                return null;
            }
            PooledConnectionAdapter pooledConnectionAdapter = connectionDescriptor.getConnection();
            this.myAllocatedConnections.put(pooledConnectionAdapter, connectionDescriptor);
            this.trace("current=" + this.myConnectionPool.getAllocatedConnectionCount() + ";created=" + this.myConnectionPool.getCreatedConnectionCount());
            return pooledConnectionAdapter;
        }
        catch (SQLException sQLException) {
            this.log(sQLException);
            return null;
        }
    }

    private void freeConnection(PooledConnectionAdapter pooledConnectionAdapter) {
        try {
            ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)this.myAllocatedConnections.remove(pooledConnectionAdapter);
            if (null == connectionDescriptor) {
                this.trace("freeConnection() : this connection does not belong to the pool !(" + pooledConnectionAdapter + ")");
            } else {
                this.myConnectionPool.push(connectionDescriptor);
                this.trace("current=" + this.myConnectionPool.getAllocatedConnectionCount() + ";created=" + this.myConnectionPool.getCreatedConnectionCount());
            }
        }
        catch (SQLException sQLException) {
            this.log(sQLException);
        }
    }

    public void destroy() {
        try {
            this.destroy(10000);
        }
        catch (SQLException sQLException) {
            this.log("A non-fatal error occured during Pool release (error follows)");
            this.log(sQLException);
        }
    }

    public final boolean getAutoCommitEnabled() {
        return this.myIsAutoCommitEnabled;
    }

    public final boolean isAvailable() {
        return this.myIsAvailable;
    }

    private PooledConnectionAdapter createConnection() throws SQLException {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(this.getDatabaseURL(), this.myDriverProperties);
        }
        catch (SQLException sQLException) {
            this.trace("Could not create a connection using driver properties...trying default settings");
            connection = DriverManager.getConnection(this.getDatabaseURL(), this.getDatabaseLogin(), this.getDatabasePassword());
        }
        connection.setTransactionIsolation(this.getTransactionLevel());
        connection.setAutoCommit(this.getAutoCommitEnabled());
        return new PooledConnectionAdapter(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(int n) throws SQLException {
        this.trace("Disposing Connection Pool...");
        if (this.isAvailable()) {
            this.myIsAvailable = false;
            try {
                Object object;
                for (int i = 0; this.myAllocatedConnections.size() > 0 && i < 3; ++i) {
                    this.trace("Waiting for connections to be released (" + this.myAllocatedConnections.size() + " allocated connections");
                    object = this.myAllocatedConnections;
                    synchronized (object) {
                        this.myAllocatedConnections.wait(n);
                        continue;
                    }
                }
                if (this.myAllocatedConnections.size() > 0) {
                    object = this.myAllocatedConnections.elements();
                    while (object.hasMoreElements()) {
                        this.myConnectionPool.push((ConnectionDescriptor)object.nextElement());
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.trace("Interrupted while disposing Connection Pool - bruteforce cleanup");
            }
            this.myAllocatedConnections.clear();
            this.myConnectionPool.dispose();
            this.trace("Connection Pool disposed");
        }
    }

    public String getDatabaseURL() {
        return this.myDriverProperties.getProperty(URL);
    }

    public String getDatabaseLogin() {
        return this.myDriverProperties.getProperty(USER);
    }

    private String getDatabasePassword() {
        return this.myDriverProperties.getProperty(PASSWORD);
    }

    private long getMaxConnectionAge() {
        return this.myMaxConnectionAge;
    }

    private int getTransactionLevel() {
        return this.myTransactionLevel;
    }

    private static final Properties getJDBCProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(JDBC) || string.length() <= JDBC.length()) continue;
            properties2.put(string.substring(JDBC.length()), properties.getProperty(string));
        }
        return properties2;
    }

    private class ConnectionPoolHelper {
        private Vector myConnections;
        private int myCreatedConnectionCount;
        private int myAllocatedConnectionCount;
        private int myMinConnections;
        private int myMaxConnections;
        private int myConnectionRetry;
        private int myConnectionRetryDelay;

        public ConnectionPoolHelper(int n, int n2) throws SQLException, IllegalArgumentException {
            if (n2 <= 0 || n > n2) {
                throw new IllegalArgumentException("min=" + n + ";max=" + n2);
            }
            this.myConnections = new Vector();
            this.myMinConnections = n;
            this.myMaxConnections = n2;
            this.myCreatedConnectionCount = 0;
            this.myConnectionRetry = 10;
            this.myConnectionRetryDelay = 5000;
            this.init(this.myMinConnections);
        }

        public int getAllocatedConnectionCount() {
            return this.myAllocatedConnectionCount;
        }

        public int getCreatedConnectionCount() {
            return this.myCreatedConnectionCount;
        }

        public synchronized void dispose() {
            Enumeration enumeration = this.myConnections.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)enumeration.nextElement();
                try {
                    connectionDescriptor.getConnection().dispose();
                }
                catch (SQLException sQLException) {
                    ConnectionPool.this.trace("Error while closing a connection: " + sQLException.getLocalizedMessage());
                }
            }
            this.myConnections.clear();
        }

        public void release(ConnectionDescriptor connectionDescriptor) throws SQLException {
            connectionDescriptor.unlock();
            this.push(connectionDescriptor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionDescriptor pop() throws SQLException {
            Vector vector;
            int n;
            for (n = 0; ConnectionPool.this.isAvailable() && this.myAllocatedConnectionCount == this.myMaxConnections && n < this.myConnectionRetry; ++n) {
                vector = this.myConnections;
                synchronized (vector) {
                    try {
                        this.myConnections.wait(this.myConnectionRetryDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        ConnectionPool.this.log("Connection Pool interrupted");
                        return null;
                    }
                }
            }
            if (!ConnectionPool.this.isAvailable()) {
                ConnectionPool.this.log("Connection pool disposed");
                return null;
            }
            if (n == this.myConnectionRetry) {
                ConnectionPool.this.log("Connection pool exhausted (retry failed)");
                return null;
            }
            if (this.myAllocatedConnectionCount == this.myMaxConnections) {
                ConnectionPool.this.log("Connection pool exhausted (no more connections)");
                return null;
            }
            vector = this.myConnections;
            synchronized (vector) {
                if (this.myConnections.size() == 0) {
                    this.appendDescriptor();
                }
                ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)this.myConnections.remove(0);
                connectionDescriptor.lock();
                connectionDescriptor.recycle();
                ++this.myAllocatedConnectionCount;
                this.myConnections.notifyAll();
                return connectionDescriptor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void push(ConnectionDescriptor connectionDescriptor) throws SQLException {
            if (this.myConnections.size() == this.myMaxConnections) {
                throw new SQLException("Cannot add more connections");
            }
            Vector vector = this.myConnections;
            synchronized (vector) {
                connectionDescriptor.unlock();
                --this.myAllocatedConnectionCount;
                this.myConnections.add(connectionDescriptor);
                this.myConnections.notifyAll();
            }
        }

        private void traceWarnings() {
            for (int i = 0; i < this.myConnections.size(); ++i) {
                try {
                    Connection connection = (Connection)this.myConnections.get(i);
                    SQLWarning sQLWarning = connection.getWarnings();
                    if (null == sQLWarning) continue;
                    ConnectionPool.this.trace("Warnings on connection " + String.valueOf(i) + "(" + connection.toString() + "): " + sQLWarning);
                    connection.clearWarnings();
                    continue;
                }
                catch (SQLException sQLException) {
                    ConnectionPool.this.log("Cannot access warnings: " + sQLException);
                }
            }
        }

        private void init(int n) throws SQLException {
        }

        private void appendDescriptor() throws SQLException {
            if (this.myCreatedConnectionCount == this.myMaxConnections) {
                throw new SQLException("Maximum connection reached");
            }
            PooledConnectionAdapter pooledConnectionAdapter = ConnectionPool.this.createConnection();
            this.myConnections.add(new ConnectionDescriptor(pooledConnectionAdapter));
            ++this.myCreatedConnectionCount;
            ConnectionPool.this.trace(new Date() + "  Created connection " + pooledConnectionAdapter.toString());
        }
    }

    private class PooledConnectionAdapter
    implements Connection {
        private Connection myDelegateConnection;

        public PooledConnectionAdapter(Connection connection) {
            this.myDelegateConnection = connection;
        }

        public void setHoldability(int n) throws SQLException {
        }

        public int getHoldability() throws SQLException {
            return this.myDelegateConnection.getHoldability();
        }

        public Savepoint setSavepoint() throws SQLException {
            return this.myDelegateConnection.setSavepoint();
        }

        public Savepoint setSavepoint(String string) throws SQLException {
            return this.myDelegateConnection.setSavepoint(string);
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this.myDelegateConnection.rollback(savepoint);
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.myDelegateConnection.releaseSavepoint(savepoint);
        }

        public Statement createStatement(int n, int n2, int n3) throws SQLException {
            return this.myDelegateConnection.createStatement(n, n2, n3);
        }

        public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
            return this.myDelegateConnection.prepareStatement(string, n, n2, n3);
        }

        public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
            return this.myDelegateConnection.prepareCall(string, n, n2, n3);
        }

        public PreparedStatement prepareStatement(String string, int n) throws SQLException {
            return this.myDelegateConnection.prepareStatement(string, n);
        }

        public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
            return this.myDelegateConnection.prepareStatement(string, nArray);
        }

        public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
            return this.myDelegateConnection.prepareStatement(string, stringArray);
        }

        public void clearWarnings() throws SQLException {
            this.myDelegateConnection.clearWarnings();
        }

        public void close() throws SQLException {
            ConnectionPool.this.freeConnection(this);
        }

        public void commit() throws SQLException {
            this.myDelegateConnection.commit();
        }

        public Statement createStatement() throws SQLException {
            return this.myDelegateConnection.createStatement();
        }

        public Statement createStatement(int n, int n2) throws SQLException {
            return this.myDelegateConnection.createStatement(n, n2);
        }

        public boolean getAutoCommit() throws SQLException {
            return this.myDelegateConnection.getAutoCommit();
        }

        public String getCatalog() throws SQLException {
            return this.myDelegateConnection.getCatalog();
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            return this.myDelegateConnection.getMetaData();
        }

        public int getTransactionIsolation() throws SQLException {
            return this.myDelegateConnection.getTransactionIsolation();
        }

        public Map getTypeMap() throws SQLException {
            return this.myDelegateConnection.getTypeMap();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this.myDelegateConnection.getWarnings();
        }

        public boolean isClosed() throws SQLException {
            return this.myDelegateConnection.isClosed();
        }

        public boolean isReadOnly() throws SQLException {
            return this.myDelegateConnection.isReadOnly();
        }

        public String nativeSQL(String string) throws SQLException {
            return this.myDelegateConnection.nativeSQL(string);
        }

        public CallableStatement prepareCall(String string) throws SQLException {
            return this.myDelegateConnection.prepareCall(string);
        }

        public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
            return this.myDelegateConnection.prepareCall(string, n, n2);
        }

        public PreparedStatement prepareStatement(String string) throws SQLException {
            return this.myDelegateConnection.prepareStatement(string);
        }

        public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
            return this.myDelegateConnection.prepareStatement(string, n, n2);
        }

        public void rollback() throws SQLException {
            this.myDelegateConnection.rollback();
        }

        public void setAutoCommit(boolean bl) throws SQLException {
            this.myDelegateConnection.setAutoCommit(bl);
        }

        public void setCatalog(String string) throws SQLException {
            this.myDelegateConnection.setCatalog(string);
        }

        public void setReadOnly(boolean bl) throws SQLException {
            this.myDelegateConnection.setReadOnly(bl);
        }

        public void setTransactionIsolation(int n) throws SQLException {
            this.myDelegateConnection.setTransactionIsolation(n);
        }

        public void setTypeMap(Map map) throws SQLException {
            this.myDelegateConnection.setTypeMap(map);
        }

        void dispose() throws SQLException {
            this.myDelegateConnection.close();
            ConnectionPool.this.trace("Closed physical connection " + this.myDelegateConnection);
        }
    }

    private class ConnectionDescriptor {
        private int myStatus;
        private long myCreateTime;
        private long myLockTime;
        private PooledConnectionAdapter myConnection;

        public ConnectionDescriptor(PooledConnectionAdapter pooledConnectionAdapter) {
            this.myConnection = pooledConnectionAdapter;
            this.myStatus = 0;
            this.myLockTime = -1L;
            this.myCreateTime = new Date().getTime();
        }

        public long getLockTime() {
            return this.myLockTime;
        }

        public long getCreateTime() {
            return this.myCreateTime;
        }

        public PooledConnectionAdapter getConnection() throws SQLException {
            return this.myConnection;
        }

        public synchronized void lock() throws SQLException {
            this.myLockTime = new Date().getTime();
        }

        public synchronized void unlock() throws SQLException {
            this.myLockTime = -1L;
        }

        public synchronized void recycle() {
            boolean bl = false;
            try {
                if (null == this.myConnection || this.myConnection.isClosed()) {
                    bl = true;
                } else if (this.getAge() > ConnectionPool.this.getMaxConnectionAge()) {
                    bl = true;
                } else {
                    this.myConnection.createStatement().close();
                    bl = false;
                }
            }
            catch (SQLException sQLException) {
                bl = true;
            }
            if (bl) {
                try {
                    this.myConnection = ConnectionPool.this.createConnection();
                    this.myCreateTime = new Date().getTime();
                }
                catch (SQLException sQLException) {
                    ConnectionPool.this.log("Cannot recycle connection !" + this.myConnection);
                    ConnectionPool.this.log(sQLException);
                    this.myConnection = null;
                }
            }
        }

        public String toString() {
            return "ConnectionDescriptor [create=" + this.getCreateTime() + ";lock=" + this.getLockTime() + ";age=" + this.getAge() + "]";
        }

        private long getAge() {
            return System.currentTimeMillis() - this.getCreateTime();
        }
    }

    private static class PoolPropertiesAdapter {
        public String driverClassname = null;
        public String jdbcURL = null;
        public String user = null;
        public String password = null;
        public int transactionLevel;
        public int minConnections = -1;
        public int maxConnections = -1;
        public int recycle = -1;
        public boolean isAutoCommitEnabled;

        public PoolPropertiesAdapter(Properties properties) throws SQLException {
            this.driverClassname = properties.getProperty(ConnectionPool.DRIVER, null);
            if (null == this.driverClassname) {
                throw new SQLException("Missing jdbc.driver parameter");
            }
            this.jdbcURL = properties.getProperty(ConnectionPool.URL, null);
            if (null == this.jdbcURL) {
                throw new SQLException("Missing jdbc.url parameter");
            }
            this.user = properties.getProperty(ConnectionPool.USER, "");
            this.password = properties.getProperty(ConnectionPool.PASSWORD, "");
            this.minConnections = this.getPropertyInt(properties, ConnectionPool.MIN_SIZE, 1);
            this.maxConnections = this.getPropertyInt(properties, ConnectionPool.MAX_SIZE, 10);
            this.recycle = this.getPropertyInt(properties, ConnectionPool.RECYCLE, 5);
            this.isAutoCommitEnabled = this.getPropertyBoolean(properties, ConnectionPool.AUTOCOMMIT, false);
            this.transactionLevel = this.getTransactionLevel(properties);
        }

        private int getPropertyInt(Properties properties, String string, int n) {
            try {
                return Integer.parseInt(properties.getProperty(string, Integer.toString(n)));
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        private boolean getPropertyBoolean(Properties properties, String string, boolean bl) {
            String string2 = properties.getProperty(string, null);
            return null == string2 ? bl : new Boolean(string2);
        }

        private int getTransactionLevel(Properties properties) {
            String string = properties.getProperty(ConnectionPool.TRANSACTION_LEVEL);
            if (null == string) {
                return 1;
            }
            if ((string = string.trim().toLowerCase()).equalsIgnoreCase(ConnectionPool.TRANSACTION_LEVEL_COMMITTED)) {
                return 2;
            }
            if (string.equalsIgnoreCase(ConnectionPool.TRANSACTION_LEVEL_UNCOMMITTED)) {
                return 1;
            }
            return 1;
        }
    }
}

