/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;

public class SplashScreen
extends JDialog
implements ActionListener {
    private static int TIMER_DELAY = 3000;
    private JLabel _label;
    private ImageIcon _imageIcon;
    private Timer _timer = null;

    public SplashScreen(Image image) {
        this(new ImageIcon(image), TIMER_DELAY, null);
    }

    public SplashScreen(Image image, int n) {
        this(new ImageIcon(image), n, null);
    }

    public SplashScreen(Image image, String string) {
        this(new ImageIcon(image), TIMER_DELAY, string);
    }

    public SplashScreen(ImageIcon imageIcon) {
        this(imageIcon, TIMER_DELAY, null);
    }

    public SplashScreen(ImageIcon imageIcon, int n) {
        this(imageIcon, n, null);
    }

    public SplashScreen(ImageIcon imageIcon, int n, String string) {
        this._imageIcon = imageIcon;
        this._label = new JLabel(string, imageIcon, 0);
        this._label.setVerticalTextPosition(3);
        this._label.setHorizontalTextPosition(0);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SplashScreen.this.dispose();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._label, "Center");
        this._timer = new Timer(n, this);
        this._timer.setInitialDelay(n);
        this._timer.start();
        this.pack();
    }

    public final Dimension getMinimumSize() {
        if (null == this._imageIcon) {
            return super.getMinimumSize();
        }
        return new Dimension(this._imageIcon.getIconWidth(), this._imageIcon.getIconHeight());
    }

    public final void show() {
        this.centerOnScreen();
        super.toFront();
        super.show();
    }

    private final void centerOnScreen() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }

    public final void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
            super.dispose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._timer) {
            this._timer.removeActionListener(this);
            this._timer.stop();
            this._timer = null;
            this.dispose();
        }
    }
}

