/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.swing;

import com.tlabs.swing.SwingWorker;
import com.tlabs.swing.TAction;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public abstract class TRunnableAction
extends TAction
implements Runnable {
    private Throwable _lastError = null;
    private Component _parent = null;

    public TRunnableAction(String string) {
        this(string, null, null);
    }

    public TRunnableAction(String string, Component component) {
        this(string, null, component);
    }

    public TRunnableAction(String string, Icon icon) {
        this(string, icon, null);
    }

    public TRunnableAction(String string, Icon icon, Component component) {
        super(string, icon);
        this._parent = component;
    }

    public abstract void run();

    public void actionPerformed(ActionEvent actionEvent) {
        this.setParentEnabled(false);
        this.invokeAction();
    }

    public void finished() {
        this.setLastError(null);
        this.setParentEnabled(true);
    }

    public final Throwable getLastError() {
        return this._lastError;
    }

    protected final void setLastError(Throwable throwable) {
        Throwable throwable2 = this._lastError;
        this._lastError = throwable;
        this.firePropertyChange("error", throwable2, throwable);
    }

    protected boolean invokeAction() {
        if (!this.isEnabled()) {
            this.setLastError(new IllegalArgumentException(this.getClass().getName() + " : Action disabled."));
            return false;
        }
        try {
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    TRunnableAction.this.run();
                    return "";
                }

                public void finished() {
                    TRunnableAction.this.finished();
                }
            };
            swingWorker.start();
        }
        catch (Exception exception) {
            this.setLastError(exception);
            this.setParentEnabled(true);
            return false;
        }
        return true;
    }

    private void setParentEnabled(boolean bl) {
        if (null == this._parent) {
            return;
        }
        this._parent.setEnabled(bl);
        this._parent.setCursor(new Cursor(bl ? 0 : 3));
    }
}

