/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.swing.themes;

import com.tlabs.util.debug.Debug;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class ColorTheme
extends DefaultMetalTheme {
    private static final int COLOR_SIZE = 3;
    private ColorUIResource _black;
    private ColorUIResource _white;
    private ColorUIResource[] _primaries;
    private ColorUIResource[] _secondaries;
    private String _themeName;
    private Properties _resource = null;

    public ColorTheme(String string, Properties properties) {
        this(string);
        this.initColors(properties);
    }

    protected ColorTheme(String string) {
        this._themeName = string;
        this._primaries = new ColorUIResource[3];
        this._secondaries = new ColorUIResource[3];
    }

    private void initColors(Properties properties) {
        this._resource = properties;
        this._primaries[0] = super.getPrimary1();
        this._primaries[1] = super.getPrimary2();
        this._primaries[2] = super.getPrimary3();
        this._secondaries[0] = super.getSecondary1();
        this._secondaries[1] = super.getSecondary2();
        this._secondaries[2] = super.getSecondary3();
        this._black = super.getBlack();
        this._white = super.getWhite();
        if (this._resource.size() > 0) {
            ColorUIResource colorUIResource;
            int n;
            String string = null;
            for (n = 0; n < 3; ++n) {
                string = this._resource.getProperty(this.getName() + "_primary" + (n + 1), "");
                colorUIResource = this.parseColor(string);
                if (null == colorUIResource) continue;
                this._primaries[n] = colorUIResource;
            }
            for (n = 0; n < 3; ++n) {
                string = this._resource.getProperty(this.getName() + "_secondary" + (n + 1), "");
                colorUIResource = this.parseColor(string);
                if (null == colorUIResource) continue;
                this._secondaries[n] = colorUIResource;
            }
            ColorUIResource colorUIResource2 = this.parseColor(this._resource.getProperty(this.getName() + "_black", ""));
            if (null != colorUIResource2) {
                this._black = colorUIResource2;
            }
            if (null != (colorUIResource2 = this.parseColor(this._resource.getProperty(this.getName() + "_white", "")))) {
                this._white = colorUIResource2;
            }
        }
    }

    public String getName() {
        return this._themeName;
    }

    protected ColorUIResource getWhite() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_white", ""));
        return null == colorUIResource ? super.getWhite() : colorUIResource;
    }

    protected ColorUIResource getBlack() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_black", ""));
        return null == colorUIResource ? super.getBlack() : colorUIResource;
    }

    protected ColorUIResource getPrimary1() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_primary1", ""));
        return null == colorUIResource ? super.getPrimary1() : colorUIResource;
    }

    protected ColorUIResource getPrimary2() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_primary2", ""));
        return null == colorUIResource ? super.getPrimary2() : colorUIResource;
    }

    protected ColorUIResource getPrimary3() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_primary3", ""));
        return null == colorUIResource ? super.getPrimary3() : colorUIResource;
    }

    protected ColorUIResource getSecondary1() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_secondary1", ""));
        return null == colorUIResource ? super.getSecondary1() : colorUIResource;
    }

    protected ColorUIResource getSecondary2() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_secondary2", ""));
        return null == colorUIResource ? super.getSecondary2() : colorUIResource;
    }

    protected ColorUIResource getSecondary3() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_secondary3", ""));
        return null == colorUIResource ? super.getSecondary3() : colorUIResource;
    }

    public ColorUIResource getAcceleratorForeground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_accelerator.foreground", ""));
        return null == colorUIResource ? super.getAcceleratorForeground() : colorUIResource;
    }

    public ColorUIResource getAcceleratorSelectedForeground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_accelerator.foreground.selected", ""));
        return null == colorUIResource ? super.getAcceleratorSelectedForeground() : colorUIResource;
    }

    public ColorUIResource getControl() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_control", ""));
        return null == colorUIResource ? super.getControl() : colorUIResource;
    }

    public ColorUIResource getControlDarkShadow() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_control.darkshadow", ""));
        return null == colorUIResource ? super.getControlDarkShadow() : colorUIResource;
    }

    public ColorUIResource getControlDisabled() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_control.disabled", ""));
        return null == colorUIResource ? super.getControlDisabled() : colorUIResource;
    }

    public ColorUIResource getControlHighlight() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_control.highlight", ""));
        return null == colorUIResource ? super.getControlHighlight() : colorUIResource;
    }

    public ColorUIResource getControlInfo() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_control.info", ""));
        return null == colorUIResource ? super.getControlInfo() : colorUIResource;
    }

    public ColorUIResource getControlShadow() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_control.shadow", ""));
        return null == colorUIResource ? super.getControlShadow() : colorUIResource;
    }

    public ColorUIResource getControlTextColor() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_text.color", ""));
        return null == colorUIResource ? super.getControlTextColor() : colorUIResource;
    }

    public ColorUIResource getDesktopColor() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_desktop", ""));
        return null == colorUIResource ? super.getDesktopColor() : colorUIResource;
    }

    public ColorUIResource getFocusColor() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_focus", ""));
        return null == colorUIResource ? super.getFocusColor() : colorUIResource;
    }

    public ColorUIResource getHighlightedTextColor() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_text.highlight", ""));
        return null == colorUIResource ? super.getHighlightedTextColor() : colorUIResource;
    }

    public ColorUIResource getInactiveControlTextColor() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_text.inactivecontrol", ""));
        return null == colorUIResource ? super.getInactiveControlTextColor() : colorUIResource;
    }

    public ColorUIResource getInactiveSystemTextColor() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_text.inactivesystem,", ""));
        return null == colorUIResource ? super.getInactiveSystemTextColor() : colorUIResource;
    }

    public ColorUIResource getMenuBackground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_menu.background", ""));
        return null == colorUIResource ? super.getMenuBackground() : colorUIResource;
    }

    public ColorUIResource getMenuDisabledForeground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_menu.foreground.disabled", ""));
        return null == colorUIResource ? super.getMenuDisabledForeground() : colorUIResource;
    }

    public ColorUIResource getMenuForeground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_menu.foreground", ""));
        return null == colorUIResource ? super.getMenuForeground() : colorUIResource;
    }

    public ColorUIResource getMenuSelectedBackground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_menu.background.selected", ""));
        return null == colorUIResource ? super.getMenuSelectedBackground() : colorUIResource;
    }

    public ColorUIResource getMenuSelectedForeground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_menu.foreground.selected", ""));
        return null == colorUIResource ? super.getMenuSelectedForeground() : colorUIResource;
    }

    public ColorUIResource getPrimaryControl() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_control.primary", ""));
        return null == colorUIResource ? super.getPrimaryControl() : colorUIResource;
    }

    public ColorUIResource getPrimaryControlDarkShadow() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_control.primary.darkshadow", ""));
        return null == colorUIResource ? super.getPrimaryControlDarkShadow() : colorUIResource;
    }

    public ColorUIResource getPrimaryControlHighlight() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_control.primary.highlight", ""));
        return null == colorUIResource ? super.getPrimaryControlHighlight() : colorUIResource;
    }

    public ColorUIResource getPrimaryControlInfo() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_control.primary.info", ""));
        return null == colorUIResource ? super.getPrimaryControlInfo() : colorUIResource;
    }

    public ColorUIResource getPrimaryControlShadow() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_control.primary.shadow", ""));
        return null == colorUIResource ? super.getPrimaryControlShadow() : colorUIResource;
    }

    public ColorUIResource getSeparatorBackground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_separator.background", ""));
        return null == colorUIResource ? super.getSeparatorBackground() : colorUIResource;
    }

    public ColorUIResource getSeparatorForeground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_separator.foreground", ""));
        return null == colorUIResource ? super.getSeparatorForeground() : colorUIResource;
    }

    public ColorUIResource getSystemTextColor() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_text.systemcolor", ""));
        return null == colorUIResource ? super.getSystemTextColor() : colorUIResource;
    }

    public ColorUIResource getTextHighlightColor() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_text.highlight", ""));
        return null == colorUIResource ? super.getTextHighlightColor() : colorUIResource;
    }

    public ColorUIResource getUserTextColor() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_text.usercolor", ""));
        return null == colorUIResource ? super.getUserTextColor() : colorUIResource;
    }

    public ColorUIResource getWindowBackground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_window.background", ""));
        return null == colorUIResource ? super.getWindowBackground() : colorUIResource;
    }

    public ColorUIResource getWindowTitleBackground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_window.title.background", ""));
        return null == colorUIResource ? super.getWindowTitleBackground() : colorUIResource;
    }

    public ColorUIResource getWindowTitleForeground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_window.title.foreground", ""));
        return null == colorUIResource ? super.getWindowTitleForeground() : colorUIResource;
    }

    public ColorUIResource getWindowTitleInactiveBackground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_window.title.background.inactive", ""));
        return null == colorUIResource ? super.getWindowTitleInactiveBackground() : colorUIResource;
    }

    public ColorUIResource getWindowTitleInactiveForeground() {
        ColorUIResource colorUIResource = this.parseColor(this._resource.getProperty(this.getName() + "_window.title.foreground.inactive", ""));
        return null == colorUIResource ? super.getWindowTitleInactiveForeground() : colorUIResource;
    }

    private ColorUIResource parseColor(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.countTokens() == 0) {
                return null;
            }
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n3 = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            Debug.log("", "Unable to parse color : \"" + string + "\" - Using Default.");
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            Debug.log("", "Unable to parse color : \"" + string + "\" - Using Default.");
            return null;
        }
        return new ColorUIResource(n, n3, n2);
    }

    private FontUIResource parseFont(String string) {
        return null;
    }
}

