/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public final class Maps {
    private static final String DUMP_TAB = "    ";
    private static final String DUMP_START_TABLE = "--------- START TABLE Key={0} Level={1} Size={2}--------";
    private static final String DUMP_END_TABLE = "--------- END TABLE Key={0} Level={1}--------";
    private static final String DUMP_START_LIST = "--------- START LIST Key={0} Level={1} Size={2}--------";
    private static final String DUMP_END_LIST = "--------- END LIST Key={0} Level={1}--------";
    private static Comparator myDumpComparator = new DumpComparator();

    public static Map prefixKeys(Map map, String string, boolean bl) throws IllegalArgumentException {
        if (null == map) {
            throw new IllegalArgumentException("null map");
        }
        if (null == string || string.length() == 0) {
            throw new IllegalArgumentException("null or empty prefix");
        }
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            if (k instanceof String) {
                hashMap.put(string + (String)k, v);
                continue;
            }
            if (bl) continue;
            hashMap.put((String)k, v);
        }
        return hashMap;
    }

    public static Map prefixKeys(Map map, String string) throws IllegalArgumentException {
        return Maps.prefixKeys(map, string, false);
    }

    public static Map unprefixKeys(Map map, String string) throws IllegalArgumentException {
        return Maps.unprefixKeys(map, string, false);
    }

    public static Map unprefixKeys(Map map, String string, boolean bl) throws IllegalArgumentException {
        if (null == map) {
            throw new IllegalArgumentException("null map");
        }
        if (null == string || string.length() == 0) {
            throw new IllegalArgumentException("null or empty prefix");
        }
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            if (k instanceof String) {
                String string2 = (String)k;
                if (string2.startsWith(string)) {
                    string2 = string2.substring(string.length());
                    hashMap.put(string2, v);
                    continue;
                }
                if (bl) continue;
                hashMap.put(string2, v);
                continue;
            }
            if (bl) continue;
            hashMap.put((String)k, v);
        }
        return hashMap;
    }

    public static final List tokenize(String string, String string2) {
        if (null == string) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList;
    }

    public static final String tokenize(List list, String string) {
        if (null == list) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            object = null == object ? null : object.toString();
            stringBuffer.append(object);
            if (i >= list.size() - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static final Map stringify(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            if (v instanceof Map) {
                hashMap.put(k, Maps.stringify((Map)v));
                continue;
            }
            if (v instanceof List) {
                hashMap.put(k, Maps.stringify((List)v));
                continue;
            }
            hashMap.put(k, null == v ? null : v.toString());
        }
        return hashMap;
    }

    public static final List stringify(List list) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Map) {
                linkedList.add(Maps.stringify((Map)e));
                continue;
            }
            if (e instanceof List) {
                linkedList.add(Maps.stringify((List)e));
                continue;
            }
            linkedList.add(null == e ? null : e.toString());
        }
        return linkedList;
    }

    public static void dump(Map map) {
        Maps.dump(map, (OutputStream)System.out);
    }

    public static void dump(Map map, Writer writer) {
        try {
            BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
            Maps.dump(map, bufferedWriter, 0, null);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void dump(Map map, OutputStream outputStream) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            Maps.dump(map, bufferedWriter, 0, null);
            bufferedWriter.flush();
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void dump(List list) {
        Maps.dump(list, (OutputStream)System.out);
    }

    public static void dump(List list, Writer writer) {
        try {
            BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
            Maps.dump(list, bufferedWriter, 0, null);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void dump(List list, OutputStream outputStream) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            Maps.dump(list, bufferedWriter, 0, null);
            bufferedWriter.flush();
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String toString(Map map) {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            Maps.dump(map, bufferedWriter, 0, null);
            bufferedWriter.flush();
            bufferedWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String toString(List list) {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            Maps.dump(list, bufferedWriter, 0, null);
            bufferedWriter.flush();
            bufferedWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public static void toXML(Map map, Writer writer) throws IOException {
        Maps.toXML(map, writer, "map");
    }

    public static void toXML(List list, Writer writer) throws IOException {
        Maps.toXML(list, writer, "list");
    }

    public static void toXML(Map map, OutputStream outputStream) throws IOException {
        Maps.toXML(map, outputStream, "map");
    }

    public static void toXML(List list, OutputStream outputStream) throws IOException {
        Maps.toXML(list, outputStream, "list");
    }

    public static void toXML(Map map, OutputStream outputStream, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        Maps.toXML(map, (Writer)outputStreamWriter, string);
        outputStreamWriter.close();
    }

    public static void toXML(List list, OutputStream outputStream, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        Maps.toXML(list, (Writer)outputStreamWriter, string);
        outputStreamWriter.close();
    }

    public static String toXML(Map map) {
        try {
            StringWriter stringWriter = new StringWriter();
            Maps.toXML(map, (Writer)stringWriter);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public static String toXML(List list) {
        try {
            StringWriter stringWriter = new StringWriter();
            Maps.toXML(list, (Writer)stringWriter);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public static void toXML(List list, Writer writer, String string) throws IOException {
        writer.write("<" + string + ">\n");
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof List) {
                Maps.toXML((List)e, writer, string + "-entry");
                continue;
            }
            if (e instanceof Map) {
                Maps.toXML((Map)e, writer, string + "-entry");
                continue;
            }
            writer.write("<" + i + ">" + (null == e ? "" : e.toString()) + "</" + i + ">\n");
        }
        writer.write("</" + string + ">\n");
        writer.flush();
    }

    public static void toXML(Map map, Writer writer, String string) throws IOException {
        writer.write("<" + string + ">\n");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            if (v instanceof List) {
                Maps.toXML((List)v, writer, k.toString());
                continue;
            }
            if (v instanceof Map) {
                Maps.toXML((Map)v, writer, k.toString());
                continue;
            }
            writer.write("<" + k.toString() + ">" + (null == v ? "" : v.toString()) + "</" + k.toString() + ">\n");
        }
        writer.write("</" + string + ">\n");
        writer.flush();
    }

    public static Object get(Map map, Object object, Object object2) {
        Object v = map.get(object);
        return null == v ? object2 : v;
    }

    public static Object get(Map map, Object object) {
        return map.get(object);
    }

    public static Map sort(Map map) {
        TreeMap treeMap = new TreeMap(myDumpComparator);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object object = map.get(k);
            if (object instanceof List) {
                object = Maps.sort((List)object);
            } else if (object instanceof Map) {
                object = Maps.sort((Map)object);
            }
            treeMap.put(k, object);
        }
        return treeMap;
    }

    public static List sort(List list) {
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            if (object instanceof List) {
                object = Maps.sort((List)object);
            } else if (object instanceof Map) {
                object = Maps.sort((Map)object);
            }
            linkedList.add(object);
        }
        Collections.sort(linkedList, myDumpComparator);
        return linkedList;
    }

    private static void dump(List list, BufferedWriter bufferedWriter, int n, String string) throws IOException {
        if (null == list || list.size() == 0) {
            return;
        }
        if (null == string) {
            string = "";
        }
        StringBuffer stringBuffer = Maps.tabBuffer(n);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer.toString());
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(list.size())};
        stringBuffer2.append(MessageFormat.format(DUMP_START_LIST, objectArray));
        Maps.writeLine(stringBuffer2, bufferedWriter);
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            Maps.dumpEntry(Integer.toString(i), e, bufferedWriter, n, "" + i);
        }
        stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer2.append(MessageFormat.format(DUMP_END_LIST, objectArray));
        Maps.writeLine(stringBuffer2, bufferedWriter);
        bufferedWriter.flush();
    }

    private static void dump(Map map, BufferedWriter bufferedWriter, int n, String string) throws IOException {
        if (null == map || map.size() == 0) {
            return;
        }
        TreeMap treeMap = new TreeMap(myDumpComparator);
        treeMap.putAll(map);
        if (null == string) {
            string = "";
        }
        StringBuffer stringBuffer = Maps.tabBuffer(n);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer.toString());
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(treeMap.size())};
        stringBuffer2.append(MessageFormat.format(DUMP_START_TABLE, objectArray));
        Maps.writeLine(stringBuffer2, bufferedWriter);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Maps.dumpEntry(k, treeMap.get(k), bufferedWriter, n, k.toString());
        }
        stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer2.append(MessageFormat.format(DUMP_END_TABLE, objectArray));
        Maps.writeLine(stringBuffer2, bufferedWriter);
        bufferedWriter.flush();
    }

    private static void dumpEntry(Object object, Object object2, BufferedWriter bufferedWriter, int n, String string) throws IOException {
        if (object2 instanceof Map) {
            Maps.dump((Map)object2, bufferedWriter, n + 1, string);
        } else if (object2 instanceof List) {
            Maps.dump((List)object2, bufferedWriter, n + 1, string);
        } else {
            StringBuffer stringBuffer = Maps.tabBuffer(n);
            stringBuffer.append(object + "=" + object2 + " (" + Maps.getSimpleClassName(object2) + ")");
            Maps.writeLine(stringBuffer, bufferedWriter);
        }
        bufferedWriter.flush();
    }

    private static StringBuffer tabBuffer(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(DUMP_TAB);
        }
        return stringBuffer;
    }

    private static void writeLine(StringBuffer stringBuffer, BufferedWriter bufferedWriter) throws IOException {
        String string = stringBuffer.toString();
        bufferedWriter.write(string, 0, string.length());
        bufferedWriter.newLine();
    }

    private static final String getSimpleClassName(Object object) {
        if (null == object) {
            return "null";
        }
        String string = object.getClass().getName();
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    private static class DumpComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (null == object) {
                return -1;
            }
            if (null == object2) {
                return 1;
            }
            if (object.equals(object2)) {
                return 0;
            }
            if (object instanceof String) {
                if (object2 instanceof String) {
                    return ((String)object).compareTo((String)object2);
                }
                return -1;
            }
            if (object2 instanceof String) {
                return 1;
            }
            if (object instanceof List) {
                if (object2 instanceof List) {
                    return 1;
                }
                if (object2 instanceof Map) {
                    return -1;
                }
                return 1;
            }
            if (object2 instanceof List) {
                return object instanceof Map ? 1 : -1;
            }
            if (object instanceof Map) {
                return object2 instanceof Map ? 1 : -1;
            }
            if (object2 instanceof Map) {
                return 1;
            }
            return object.toString().compareTo(object2.toString());
        }
    }
}

