/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util;

import com.tlabs.util.PollerHandler;

public class Poller {
    private boolean _isPolling = false;
    private long _pollingPeriod = 0L;
    private PollingThread _pollingThread;
    private Object _pollingThreadLock = new Object();
    private PollerHandler _handler = null;

    protected Poller() {
        this._pollingThread = new PollingThread();
    }

    public void setPollingPeriod(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(this.getClass().getName() + ".setPollingPeriod() : invalid value " + l);
        }
        this._pollingPeriod = l;
        if (0L == l) {
            this.stopPolling();
        }
    }

    public long getPollingPeriod() {
        return this._pollingPeriod;
    }

    public boolean isPolling() {
        return this._isPolling;
    }

    public Object poll() {
        return null == this._handler ? null : this._handler.poll();
    }

    public synchronized void startPolling(PollerHandler pollerHandler) {
        this._handler = pollerHandler;
        if (!this._pollingThread.isAlive()) {
            this._pollingThread.start();
        }
        this._pollingThread.setPollingPeriod(this._pollingPeriod);
        this._isPolling = true;
    }

    public void stopPolling() {
        if (!this._pollingThread.isAlive()) {
            throw new IllegalThreadStateException(this.getClass().getName() + ".stopPolling() : Polling Thread not started");
        }
        this._pollingThread.setPollingPeriod(0L);
        this._isPolling = false;
        this._handler = null;
    }

    public void dataPolled(Object object) {
    }

    public void dispose() {
        if (this.isPolling()) {
            this.stopPolling();
        }
        this._pollingThread.kill();
    }

    private class PollingThread
    extends Thread {
        private long _pollingPeriod = 0L;
        private boolean _isRunning = false;

        public PollingThread() {
            super("");
        }

        public void start() {
            if (!this.isAlive() && !this._isRunning) {
                this._isRunning = true;
                super.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this._isRunning) {
                Object object = Poller.this.poll();
                if (null != object && this._pollingPeriod > 0L) {
                    Poller.this.dataPolled(object);
                }
                if (!this._isRunning) continue;
                try {
                    Object object2 = Poller.this._pollingThreadLock;
                    synchronized (object2) {
                        if (0L == this._pollingPeriod) {
                            Poller.this._pollingThreadLock.wait();
                        } else {
                            Poller.this._pollingThreadLock.wait(this._pollingPeriod);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    this._isRunning = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setPollingPeriod(long l) {
            Object object = Poller.this._pollingThreadLock;
            synchronized (object) {
                this._pollingPeriod = l;
                Poller.this._pollingThreadLock.notifyAll();
            }
        }

        protected long getPollingPeriod() {
            return this._pollingPeriod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            this._isRunning = false;
            Object object = Poller.this._pollingThreadLock;
            synchronized (object) {
                this._pollingPeriod = -1L;
                Poller.this._pollingThreadLock.notifyAll();
            }
        }
    }
}

