/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util;

import com.tlabs.util.EnumerationAdapter;
import com.tlabs.util.IncludeResourceBundle;
import com.tlabs.util.ResourceParser;
import com.tlabs.util.TraceObject;
import com.tlabs.util.URLSniffer;
import com.tlabs.util.URLSnifferEvent;
import com.tlabs.util.URLSnifferListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

final class ResourceManager
extends TraceObject {
    private static final int SNIFFER_DELAY = 2000;
    private static final String RESOURCE_KEY = "=";
    private static final String DEFAULT_TOKEN = ";";
    private Map _table = new HashMap();
    private Vector _bundleStringNames = new Vector();
    private Vector _parsers = new Vector();
    private URLSniffer myURLWatcher = new URLSniffer(2000);

    protected ResourceManager() {
        super("Resource");
        this.myURLWatcher.addSnifferListener(new ResourceWatcher());
    }

    protected final boolean add(ResourceBundle resourceBundle, boolean bl) {
        if (!(resourceBundle instanceof PropertyResourceBundle) && this._bundleStringNames.contains(resourceBundle.getClass().getName())) {
            this.trace(resourceBundle + " already added");
            return false;
        }
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.put(string, resourceBundle.getObject(string));
        }
        this._bundleStringNames.addElement(resourceBundle.getClass().getName());
        if (resourceBundle instanceof IncludeResourceBundle) {
            this.addIncludes((IncludeResourceBundle)resourceBundle, bl);
        }
        this.trace("added (Bundle) " + resourceBundle);
        return true;
    }

    protected final boolean add(InputStream inputStream, boolean bl) {
        try {
            this.parseResource(inputStream);
            this.trace("Added (Stream) " + inputStream);
            return true;
        }
        catch (IOException iOException) {
            try {
                this.add(new PropertyResourceBundle(inputStream), bl);
                return true;
            }
            catch (IOException iOException2) {
                return false;
            }
        }
    }

    protected final boolean add(File file, boolean bl) {
        if (this._bundleStringNames.contains(file.getAbsolutePath())) {
            this.trace(file + " already added");
            return false;
        }
        boolean bl2 = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            bl2 = this.add(fileInputStream, bl);
            if (bl2) {
                URL uRL = file.toURL();
                this._bundleStringNames.addElement(uRL);
                this.trace("added (file) " + uRL);
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            bl2 = false;
        }
        if (bl2 && bl) {
            try {
                this.myURLWatcher.add(file);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return bl2;
    }

    public final boolean add(String string, boolean bl) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault());
            return this.add(resourceBundle, bl);
        }
        catch (Exception exception) {
            URL uRL = this.getClass().getClassLoader().getResource(string);
            if (null != uRL && this.add(uRL, bl)) {
                return true;
            }
            if (this.addParameterString(string) > 0) {
                return true;
            }
            File file = ResourceManager.getFile(string);
            if (null != file) {
                return this.add(file, bl);
            }
            try {
                return this.add(new FileInputStream(string), bl);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }
    }

    public final boolean add(URL uRL, boolean bl) {
        if (this._bundleStringNames.contains(uRL)) {
            this.trace(uRL + " already added");
            return false;
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
            if (properties.size() > 0) {
                this.getInternalMap().putAll(properties);
                this._bundleStringNames.add(uRL);
                if (bl) {
                    this.myURLWatcher.add(uRL);
                }
                this.trace("added (URL) " + uRL);
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            this.log("Cannot add Properties from URL " + uRL);
            return false;
        }
    }

    protected final void put(Object object, Object object2) {
        this.getInternalMap().put(object, object2);
    }

    protected final Map getInternalMap() {
        return this._table;
    }

    protected final Enumeration keys() {
        return new EnumerationAdapter(this._table.keySet());
    }

    protected final void addParser(ResourceParser resourceParser) {
        this._parsers.addElement(resourceParser);
    }

    private void parseResource(InputStream inputStream) throws IOException {
        Hashtable hashtable = null;
        Enumeration enumeration = this._parsers.elements();
        while (enumeration.hasMoreElements()) {
            try {
                hashtable = ((ResourceParser)enumeration.nextElement()).parseResource(inputStream);
                if (null == hashtable) continue;
                this._table.putAll(hashtable);
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (null == hashtable) {
            throw new IOException(this.getClass().getName() + " : Parse Error on " + inputStream);
        }
        this._table.putAll(hashtable);
    }

    private final boolean put(StringPair stringPair) {
        if (null != stringPair.key()) {
            this.put(stringPair.key(), stringPair.value());
            return true;
        }
        return false;
    }

    private final int addParameterString(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, DEFAULT_TOKEN);
        if (stringTokenizer.countTokens() > 1) {
            while (stringTokenizer.hasMoreTokens()) {
                if (!this.put(new StringPair(stringTokenizer.nextToken()))) continue;
                ++n;
            }
        }
        return n;
    }

    private void addIncludes(IncludeResourceBundle includeResourceBundle, boolean bl) {
        Object[] objectArray = includeResourceBundle.getIncludes();
        if (null == objectArray || objectArray.length == 0) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof ResourceBundle) {
                this.add(includeResourceBundle, bl);
                continue;
            }
            if (object instanceof String) {
                this.add((String)object, bl);
                continue;
            }
            if (object instanceof File) {
                this.add((File)object, bl);
                continue;
            }
            if (object instanceof InputStream) {
                this.add((InputStream)object, bl);
                continue;
            }
            System.out.println(this.getClass().getName() + ".addIncludes() : no way to add " + object);
        }
    }

    private static final File getFile(String string) {
        int n = string.indexOf(File.pathSeparator);
        File file = n == -1 || n == string.length() - 1 ? new File((String)null, string) : new File(string.substring(0, n - 1), string.substring(n + 1, string.length() - 1));
        return file;
    }

    private class StringPair {
        private String _key = null;
        private String _value = null;

        public StringPair(String string) {
            int n = string.indexOf(ResourceManager.RESOURCE_KEY);
            if (n != -1 && n > 0) {
                this._key = string.substring(0, n - 1);
                this._value = string.substring(n + 1, string.length() - 1);
            }
        }

        public final String value() {
            return this._value;
        }

        public final String key() {
            return this._key;
        }
    }

    private class ResourceWatcher
    implements URLSnifferListener {
        public void urlCreated(URLSnifferEvent uRLSnifferEvent) {
        }

        public void urlDeleted(URLSnifferEvent uRLSnifferEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void urlModified(URLSnifferEvent uRLSnifferEvent) {
            ResourceManager.this.log("Reloading changes in \"" + uRLSnifferEvent.getURL() + "\"");
            ResourceManager resourceManager = ResourceManager.this;
            synchronized (resourceManager) {
                ResourceManager.this._bundleStringNames.remove(uRLSnifferEvent.getURL());
                ResourceManager.this.add(uRLSnifferEvent.getURL(), true);
            }
        }
    }
}

