/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util;

import com.tlabs.util.Scheduler;
import com.tlabs.util.SchedulerTask;
import com.tlabs.util.SchedulerTaskAdapter;
import com.tlabs.util.URLSnifferEvent;
import com.tlabs.util.URLSnifferListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public final class URLSniffer
extends SchedulerTask {
    private Hashtable myListeners;
    private HashMap mySniffedURLList;
    private Scheduler myScheduler;

    public URLSniffer(int n) throws IllegalArgumentException {
        super(new Date(), (long)n, -1L, false);
        if (n < 0) {
            throw new IllegalArgumentException("Repeat delay cannot be negative (" + n + ")");
        }
        this.mySniffedURLList = new HashMap();
        this.myListeners = new Hashtable();
        this.myScheduler = new Scheduler(true);
        this.myScheduler.addTask(this);
    }

    public URLSniffer(URL uRL, int n) throws IllegalArgumentException {
        this(n);
        if (null == uRL) {
            throw new IllegalArgumentException("null URL");
        }
        this.addURL(uRL);
    }

    public synchronized void add(URL uRL) {
        if (!this.mySniffedURLList.containsKey(uRL)) {
            this.mySniffedURLList.put(uRL, URLSniffer.readChecksum(uRL));
        }
    }

    public synchronized void add(File file) throws MalformedURLException {
        this.add(file.toURL());
    }

    public synchronized void addURL(URL uRL) {
        this.add(uRL);
    }

    public synchronized void remove(URL uRL) {
        this.mySniffedURLList.remove(uRL);
    }

    public synchronized void remove(File file) throws MalformedURLException {
        this.remove(file.toURL());
    }

    public synchronized void removeURL(URL uRL) {
        this.remove(uRL);
    }

    public synchronized void clear() {
        this.mySniffedURLList.clear();
        this.myListeners.clear();
    }

    public synchronized Object execute() {
        Iterator iterator = this.mySniffedURLList.keySet().iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            Checksum checksum = (Checksum)this.mySniffedURLList.get(uRL);
            Checksum checksum2 = URLSniffer.readChecksum(uRL);
            if (null == checksum && null != checksum2) {
                this.trace(uRL.toExternalForm() + " created");
                this.fireURLCreated(uRL);
            } else if (null != checksum && null == checksum2) {
                this.trace(uRL.toExternalForm() + " deleted");
                this.fireURLDeleted(uRL);
            } else if (null == checksum2 && null == checksum) {
                this.trace(uRL.toExternalForm() + " does not exist");
            } else if (checksum2.getValue() != checksum.getValue()) {
                this.trace(uRL.toExternalForm() + " touched");
                this.fireURLTouched(uRL);
            }
            this.mySniffedURLList.put(uRL, checksum2);
        }
        return "";
    }

    public synchronized void addSnifferListener(URLSnifferListener uRLSnifferListener) {
        if (!this.myListeners.containsKey(uRLSnifferListener)) {
            URLSnifferAdapter uRLSnifferAdapter = new URLSnifferAdapter(uRLSnifferListener);
            super.addTaskListener(uRLSnifferAdapter);
            this.myListeners.put(uRLSnifferListener, uRLSnifferAdapter);
        }
    }

    public synchronized void removeSnifferListener(URLSnifferListener uRLSnifferListener) {
        if (this.myListeners.containsKey(uRLSnifferListener)) {
            super.removeTaskListener((URLSnifferAdapter)this.myListeners.remove(uRLSnifferListener));
        }
    }

    public synchronized boolean cancel() {
        if (super.cancel()) {
            if (null != this.myScheduler) {
                this.myScheduler.removeTask(this);
                this.myScheduler.dispose();
                this.myScheduler = null;
            }
            return true;
        }
        return false;
    }

    private void fireURLCreated(URL uRL) {
        URLSnifferEvent uRLSnifferEvent = new URLSnifferEvent(this, uRL, 0);
        Enumeration enumeration = this.myListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((URLSnifferAdapter)enumeration.nextElement()).urlCreated(uRLSnifferEvent);
        }
    }

    private void fireURLDeleted(URL uRL) {
        URLSnifferEvent uRLSnifferEvent = new URLSnifferEvent(this, uRL, 1);
        Enumeration enumeration = this.myListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((URLSnifferAdapter)enumeration.nextElement()).urlDeleted(uRLSnifferEvent);
        }
    }

    private void fireURLTouched(URL uRL) {
        URLSnifferEvent uRLSnifferEvent = new URLSnifferEvent(this, uRL, 2);
        Enumeration enumeration = this.myListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((URLSnifferAdapter)enumeration.nextElement()).urlModified(uRLSnifferEvent);
        }
    }

    private static Checksum readChecksum(URL uRL) {
        CRC32 cRC32 = null;
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            inputStream.read(byArray, 0, n);
            inputStream.close();
            cRC32 = new CRC32();
            cRC32.update(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            cRC32 = null;
        }
        return cRC32;
    }

    private static class URLSnifferAdapter
    extends SchedulerTaskAdapter
    implements URLSnifferListener {
        private URLSnifferListener myListener;

        public URLSnifferAdapter(URLSnifferListener uRLSnifferListener) {
            this.myListener = uRLSnifferListener;
        }

        public void urlCreated(URLSnifferEvent uRLSnifferEvent) {
            this.myListener.urlCreated(uRLSnifferEvent);
        }

        public void urlDeleted(URLSnifferEvent uRLSnifferEvent) {
            this.myListener.urlDeleted(uRLSnifferEvent);
        }

        public void urlModified(URLSnifferEvent uRLSnifferEvent) {
            this.myListener.urlModified(uRLSnifferEvent);
        }
    }
}

