/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util.debug;

import com.tlabs.util.debug.DebugFactory;
import com.tlabs.util.debug.log4j.Log4jDebug;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class Debug {
    public static final int DEFAULT_SEVERITY = 2;
    private static boolean myDebugFlag;
    public static boolean DEBUG;
    private static Map myLogStreams;
    private static Map myTraceStreams;
    private static Properties myProperties;
    public static final String FILE = "debug.file";
    public static final String LOG = "LOG";
    private static final String LOG_DOT = "LOG.";
    public static final String TRACE = "TRACE";
    private static final String TRACE_DOT = "TRACE.";
    public static final String ASSERTION = "ASSERTION";
    private static DebugFactory myDebugFactory;

    public static final void configure(Properties properties) {
        Properties properties2;
        Properties properties3 = properties2 = null == properties ? System.getProperties() : properties;
        if (null == myProperties) {
            myProperties = (Properties)properties2.clone();
            myDebugFactory.configure(properties);
            return;
        }
        if (myProperties.equals(properties2)) {
            System.out.println("Debug.configure : ignored (same properties)");
            return;
        }
        myDebugFactory.configure(properties);
        myProperties = (Properties)properties2.clone();
    }

    public static final void configure() {
        Debug.configure(null);
    }

    public static final void setDebug(boolean bl) {
        if (null == myDebugFactory) {
            if (bl) {
                System.out.println("Debug Factory not set - No debug info");
            }
            myDebugFlag = false;
        }
        if (myDebugFlag != bl) {
            myDebugFlag = bl;
        }
        DEBUG = myDebugFlag;
    }

    public static final void log(String string, int n) {
        if (Debug.enabled(LOG)) {
            myDebugFactory.log("", string, n);
        }
    }

    public static final void log(String string) {
        Debug.log(string, 2);
    }

    public static final void log(String string, String string2, int n) {
        if (Debug.enabled(LOG_DOT + string)) {
            myDebugFactory.log(string, string2, null, n);
        }
    }

    public static final void log(String string, String string2) {
        Debug.log(string, string2, 2);
    }

    public static final void log(Throwable throwable, int n) {
        if (Debug.enabled(LOG)) {
            myDebugFactory.log(null, null, throwable, n);
        }
    }

    public static final void log(Throwable throwable) {
        Debug.log(throwable, 2);
    }

    public static final void log(String string, Throwable throwable, int n) {
        if (Debug.enabled(LOG_DOT + string)) {
            myDebugFactory.log(string, null, throwable, n);
        }
    }

    public static final void log(String string, Throwable throwable) {
        Debug.log(string, throwable, 2);
    }

    public static final void log(String string, String string2, Throwable throwable, int n) {
        if (Debug.enabled(LOG_DOT + string)) {
            myDebugFactory.log(string, string2, throwable, n);
        }
    }

    public static final void log(String string, String string2, Throwable throwable) {
        Debug.log(string, string2, throwable, 2);
    }

    public static final void trace(String string) {
        if (Debug.enabled(TRACE)) {
            myDebugFactory.trace(null, string);
        }
    }

    public static final void trace(String string, String string2) {
        if (Debug.enabled(TRACE_DOT + string)) {
            myDebugFactory.trace(string, string2);
        }
    }

    public static final void trace(Throwable throwable) {
        if (Debug.enabled(TRACE)) {
            myDebugFactory.trace(null, throwable);
        }
    }

    public static final void trace(String string, Throwable throwable) {
        if (Debug.enabled(TRACE_DOT + string)) {
            myDebugFactory.trace(string, throwable);
        }
    }

    public static final void trace(String string, String string2, Throwable throwable) {
        if (Debug.enabled(TRACE_DOT + string)) {
            myDebugFactory.trace(string, string2, throwable);
        }
    }

    public static final void methodEnter(String string) {
        if (Debug.enabled(TRACE)) {
            myDebugFactory.methodEnter(null, string);
        }
    }

    public static final void methodEnter(String string, String string2) {
        if (Debug.enabled(TRACE_DOT + string)) {
            myDebugFactory.methodEnter(string, string2);
        }
    }

    public static final void methodExit(String string) {
        if (Debug.enabled(TRACE)) {
            myDebugFactory.methodExit(null, string);
        }
    }

    public static final void methodExit(String string, String string2) {
        if (Debug.enabled(TRACE_DOT + string)) {
            myDebugFactory.methodExit(string, string2);
        }
    }

    public static final void flagAsRelease() {
        if (null != myDebugFactory) {
            myDebugFactory.flagAsRelease();
        }
    }

    public static final OutputStream getLogStream(String string) {
        string = null == string ? LOG : (string.startsWith(LOG_DOT) ? string : LOG_DOT + string);
        return new LogStream(string);
    }

    public static final OutputStream getLogStream() {
        return Debug.getLogStream(LOG);
    }

    public static final OutputStream getTraceStream(String string) {
        string = null == string ? TRACE : (string.startsWith(TRACE_DOT) ? string : TRACE_DOT + string);
        return new TraceStream(string);
    }

    public static final OutputStream getTraceStream() {
        return Debug.getTraceStream(TRACE);
    }

    public static boolean traceEnabled(String string) {
        return Debug.enabled(TRACE_DOT + string);
    }

    public static boolean logEnabled(String string) {
        return Debug.enabled(LOG_DOT + string);
    }

    private static boolean enabled(String string) {
        return myDebugFlag && null != myDebugFactory && myDebugFactory.enabled(string);
    }

    static {
        DEBUG = myDebugFlag = true;
        myDebugFactory = Log4jDebug.getInstance();
        if (null == myDebugFactory) {
            myDebugFlag = false;
            DEBUG = false;
        }
        if (!myDebugFlag && null != myDebugFactory) {
            myDebugFactory.flagAsRelease();
        }
        myLogStreams = new HashMap();
        myTraceStreams = new HashMap();
        myProperties = null;
    }

    private static class TraceStream
    extends DebugOutputStream {
        public TraceStream(String string) {
            super(string);
        }

        public void writeDebug(String string, String string2) {
            Debug.trace(string, string2);
        }
    }

    private static class LogStream
    extends DebugOutputStream {
        public LogStream(String string) {
            super(string);
        }

        public void writeDebug(String string, String string2) {
            Debug.log(string, string2);
        }
    }

    private static abstract class DebugOutputStream
    extends OutputStream {
        private String myDomain;
        private StringBuffer myBuffer;

        public DebugOutputStream(String string) {
            this.myDomain = string;
            this.myBuffer = null;
        }

        public abstract void writeDebug(String var1, String var2);

        public void write(int n) {
            this.getBuffer().append((char)n);
        }

        public void flush() throws IOException {
            this.writeDebug(this.myDomain, this.getBuffer().toString());
            this.deleteBuffer();
            super.flush();
        }

        public synchronized void close() throws IOException {
            if (null != this.myBuffer) {
                this.flush();
            }
            super.close();
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StringBuffer getBuffer() {
            if (null == this.myBuffer) {
                DebugOutputStream debugOutputStream = this;
                synchronized (debugOutputStream) {
                    if (null == this.myBuffer) {
                        this.myBuffer = new StringBuffer();
                    }
                }
            }
            return this.myBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteBuffer() {
            if (null != this.myBuffer) {
                DebugOutputStream debugOutputStream = this;
                synchronized (debugOutputStream) {
                    if (null != this.myBuffer) {
                        this.myBuffer.delete(0, this.myBuffer.length());
                        this.myBuffer = null;
                    }
                }
            }
        }
    }
}

