/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.bounce.text.xml.WrappedXMLView;
import org.bounce.text.xml.XMLContext;
import org.bounce.text.xml.XMLDocument;
import org.bounce.text.xml.XMLStyleConstants;
import org.bounce.text.xml.XMLView;

public class XMLEditorKit
extends DefaultEditorKit
implements XMLStyleConstants {
    private static final long serialVersionUID = 3832623997442667569L;
    private XMLContext context = null;
    private ViewFactory factory = new XMLViewFactory();
    private JEditorPane editor = null;
    private boolean lineWrapping = false;
    private boolean wrapStyleWord = false;

    public XMLEditorKit() {
        this(false);
    }

    public void install(JEditorPane c) {
        super.install(c);
        this.editor = c;
    }

    public XMLEditorKit(boolean lineWrapping) {
        this.context = new XMLContext();
        this.lineWrapping = lineWrapping;
    }

    public boolean isLineWrapping() {
        return this.lineWrapping;
    }

    public void setLineWrappingEnabled(boolean enabled) {
        this.lineWrapping = enabled;
    }

    public boolean isWrapStyleWord() {
        return this.wrapStyleWord;
    }

    public void setWrapStyleWord(boolean enabled) {
        this.wrapStyleWord = enabled;
    }

    public String getContentType() {
        return "text/xml";
    }

    public final ViewFactory getViewFactory() {
        return this.factory;
    }

    public void setStyle(String name, Color foreground, int fontStyle) {
        this.context.setStyle(name, foreground, fontStyle);
    }

    public Document createDefaultDocument() {
        return new XMLDocument(this.editor);
    }

    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        doc.putProperty("loading", Boolean.TRUE);
        super.read(in, doc, pos);
        doc.putProperty("loading", Boolean.FALSE);
    }

    public void read(InputStream in, Document doc, int pos) throws IOException, BadLocationException {
        doc.putProperty("loading", Boolean.TRUE);
        super.read(in, doc, pos);
        doc.putProperty("loading", Boolean.FALSE);
    }

    class XMLViewFactory
    implements ViewFactory {
        XMLViewFactory() {
        }

        public View create(Element elem) {
            if (XMLEditorKit.this.lineWrapping) {
                try {
                    return new WrappedXMLView(XMLEditorKit.this.context, elem, XMLEditorKit.this.wrapStyleWord);
                }
                catch (IOException e) {
                }
            } else {
                try {
                    return new XMLView(XMLEditorKit.this.context, elem);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

