/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HITS
extends AbstractRanker {
    protected static final String AUTHORITY_KEY = "jung.algorithms.importance.AUTHORITY";
    protected static final String HUB_KEY = "jung.algorithms.importance.HUB";
    private String mKeyToUseForRanking = "jung.algorithms.importance.AUTHORITY";
    private Map mPreviousAuthorityScores;
    private Map mPreviousHubScores;

    public HITS(Graph graph, boolean useAuthorityForRanking) {
        if (!useAuthorityForRanking) {
            this.mKeyToUseForRanking = HUB_KEY;
        }
        this.initialize(graph);
    }

    public HITS(Graph graph) {
        this.initialize(graph);
    }

    protected void initialize(Graph g) {
        super.initialize(g, true, false);
        this.mPreviousAuthorityScores = new HashMap();
        this.mPreviousHubScores = new HashMap();
        Iterator vIt = g.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            this.setRankScore(currentVertex, 1.0, AUTHORITY_KEY);
            this.setRankScore(currentVertex, 1.0, HUB_KEY);
            this.mPreviousAuthorityScores.put(currentVertex, new MutableDouble(0.0));
            this.mPreviousHubScores.put(currentVertex, new MutableDouble(0.0));
        }
    }

    protected void finalizeIterations() {
        super.finalizeIterations();
        Iterator it = this.getVertices().iterator();
        while (it.hasNext()) {
            Vertex currentVertex = (Vertex)it.next();
            if (this.mKeyToUseForRanking.equals(AUTHORITY_KEY)) {
                currentVertex.removeUserDatum(HUB_KEY);
                continue;
            }
            currentVertex.removeUserDatum(AUTHORITY_KEY);
        }
    }

    public String getRankScoreKey() {
        return this.mKeyToUseForRanking;
    }

    public double getRankScore(Element v) {
        return this.getRankScore(v, this.mKeyToUseForRanking);
    }

    protected double getRankScore(Element v, String key) {
        return ((MutableDouble)v.getUserDatum(key)).doubleValue();
    }

    protected double getPreviousAuthorityScore(Element v) {
        return ((MutableDouble)this.mPreviousAuthorityScores.get(v)).doubleValue();
    }

    protected double getPreviousHubScore(Element v) {
        return ((MutableDouble)this.mPreviousHubScores.get(v)).doubleValue();
    }

    protected void setRankScore(Element v, double rankValue, String key) {
        MutableDouble value = (MutableDouble)v.getUserDatum(key);
        if (value == null) {
            v.setUserDatum(key, new MutableDouble(rankValue), UserData.SHARED);
        } else {
            value.setDoubleValue(rankValue);
        }
    }

    protected void setRankScore(Element v, double rankValue) {
        this.setRankScore(v, rankValue, this.mKeyToUseForRanking);
    }

    protected double evaluateIteration() {
        this.updatePreviousScores();
        this.updateAuthorityRankings();
        this.updateHubRankings();
        double hubMSE = 0.0;
        double authorityMSE = 0.0;
        int numVertices = this.getVertices().size();
        Iterator vIt = this.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            double currentAuthorityScore = this.getRankScore(currentVertex, AUTHORITY_KEY);
            double currentHubScore = this.getRankScore(currentVertex, HUB_KEY);
            double previousAuthorityScore = this.getPreviousAuthorityScore(currentVertex);
            double previousHubScore = this.getPreviousHubScore(currentVertex);
            hubMSE += Math.pow(currentHubScore - previousHubScore, 2.0);
            authorityMSE += Math.pow(currentAuthorityScore - previousAuthorityScore, 2.0);
        }
        hubMSE = Math.pow(hubMSE / (double)numVertices, 0.5);
        authorityMSE = Math.pow(authorityMSE / (double)numVertices, 0.5);
        return hubMSE + authorityMSE;
    }

    public void setUseAuthorityForRanking(boolean useAuthorityForRanking) {
        this.mKeyToUseForRanking = useAuthorityForRanking ? AUTHORITY_KEY : HUB_KEY;
    }

    private double computeSum(Set neighbors, String key) {
        double sum = 0.0;
        Iterator neighborIt = neighbors.iterator();
        while (neighborIt.hasNext()) {
            Vertex currentNeighbor = (Vertex)neighborIt.next();
            sum += this.getRankScore(currentNeighbor, key);
        }
        return sum;
    }

    private void normalizeRankings(double normConstant, String key) {
        Iterator vertexIt = this.getVertices().iterator();
        while (vertexIt.hasNext()) {
            Vertex v = (Vertex)vertexIt.next();
            double rankScore = this.getRankScore(v, key);
            this.setRankScore(v, rankScore / normConstant, key);
        }
    }

    protected void updateAuthorityRankings() {
        double total = 0.0;
        Iterator vertexIt = this.getVertices().iterator();
        while (vertexIt.hasNext()) {
            double currentHubSum;
            Vertex currentVertex = (Vertex)vertexIt.next();
            double newAuthorityScore = currentHubSum = this.computeSum(currentVertex.getPredecessors(), HUB_KEY);
            total += newAuthorityScore;
            this.setRankScore(currentVertex, newAuthorityScore, AUTHORITY_KEY);
        }
        this.normalizeRankings(total, AUTHORITY_KEY);
    }

    protected void updateHubRankings() {
        double total = 0.0;
        Iterator vertexIt = this.getVertices().iterator();
        while (vertexIt.hasNext()) {
            double currentAuthoritySum;
            Vertex currentVertex = (Vertex)vertexIt.next();
            double newHubScore = currentAuthoritySum = this.computeSum(currentVertex.getSuccessors(), AUTHORITY_KEY);
            total += newHubScore;
            this.setRankScore(currentVertex, newHubScore, HUB_KEY);
        }
        this.normalizeRankings(total, HUB_KEY);
    }

    protected void updatePreviousScores() {
        Iterator vIt = this.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            MutableDouble previousAuthorityScore = (MutableDouble)this.mPreviousAuthorityScores.get(currentVertex);
            double currentAuthorityScore = this.getRankScore(currentVertex, AUTHORITY_KEY);
            previousAuthorityScore.setDoubleValue(currentAuthorityScore);
            MutableDouble previousHubScore = (MutableDouble)this.mPreviousHubScores.get(currentVertex);
            double currentHubScore = this.getRankScore(currentVertex, HUB_KEY);
            previousHubScore.setDoubleValue(currentHubScore);
        }
    }
}

