/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Popup
extends javax.swing.Popup {
    public static final String POPUP_BACKGROUND = "POPUP_BACKGROUND";
    public static final String POPUP_LIGHTWEIGHT = "POPUP_LIGHTWEIGHT";
    private static final boolean MAC_OS_X = System.getProperty("os.name").indexOf("Mac OS X") != -1;
    private static URLClassLoader cl;
    private static Class nsApplicationClazz;
    private static Class nsWindowClazz;
    private static Class nsArrayClazz;
    private static Class nsRectClazz;
    private Component contents;
    private int x;
    private int y;
    private javax.swing.Popup popup;
    private Container heavyWeightContainer;
    private boolean lightWeight;
    private static BufferedImage popupBackground;
    static /* synthetic */ Class class$0;

    public Popup(Component owner, Component contents, int x, int y, javax.swing.Popup delegate) {
        this.contents = contents;
        this.popup = delegate;
        this.x = x;
        this.y = y;
        if (cl == null && MAC_OS_X) {
            try {
                ClassLoader parentCl = this.getClass().getClassLoader();
                cl = new URLClassLoader(new URL[]{new File("/System/Library/Java/").toURL()}, parentCl){

                    protected PermissionCollection getPermissions(CodeSource codesource) {
                        Permissions perms = new Permissions();
                        perms.add(new AllPermission());
                        return perms;
                    }
                };
                nsApplicationClazz = cl.loadClass("com.apple.cocoa.application.NSApplication");
                nsWindowClazz = cl.loadClass("com.apple.cocoa.application.NSWindow");
                nsArrayClazz = cl.loadClass("com.apple.cocoa.foundation.NSArray");
                nsRectClazz = cl.loadClass("com.apple.cocoa.foundation.NSRect");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        Container p = contents.getParent();
        ((JComponent)p).putClientProperty(POPUP_BACKGROUND, null);
        ((JComponent)p).putClientProperty(POPUP_LIGHTWEIGHT, null);
        this.lightWeight = true;
        while (p != null) {
            if (p instanceof JWindow || p instanceof Panel || p instanceof Window) {
                this.heavyWeightContainer = p;
                this.lightWeight = false;
                break;
            }
            p = p.getParent();
        }
    }

    public void hide() {
        Container parent = (JComponent)this.contents.getParent();
        this.popup.hide();
        if (this.heavyWeightContainer != null) {
            this.heavyWeightContainer = null;
            while (parent != null) {
                if (parent instanceof JFrame) {
                    ((JFrame)parent).update(((Component)parent).getGraphics());
                }
                parent = parent.getParent();
            }
        }
        this.contents = null;
        this.popup = null;
    }

    public javax.swing.Popup getDelegate() {
        return this.popup;
    }

    public void show() {
        boolean blur;
        boolean bl = blur = this.contents instanceof JPopupMenu && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.blur.enabled", this.contents);
        if (blur && this.heavyWeightContainer == null) {
            this.heavyWeightContainer = this.contents.getParent();
        }
        if (this.heavyWeightContainer == null) {
            this.popup.show();
            return;
        }
        SwingUtilities.invokeLater(new Thread(){

            public void run() {
                if (Popup.this.heavyWeightContainer == null) {
                    return;
                }
                Popup.this.snapshot();
                ((JComponent)Popup.this.contents.getParent()).putClientProperty(Popup.POPUP_BACKGROUND, popupBackground);
                ((JComponent)Popup.this.contents.getParent()).putClientProperty(Popup.POPUP_LIGHTWEIGHT, Popup.this.lightWeight);
                Popup.this.popup.show();
                if (MAC_OS_X && !UIManager.getBoolean("Synthetica.popup.osShadow.enabled")) {
                    Popup.this.disableMacShadow();
                }
            }
        });
    }

    private void snapshot() {
        try {
            Robot robot = new Robot();
            Dimension size = this.heavyWeightContainer.getPreferredSize();
            Rectangle rect = new Rectangle(this.x, this.y, size.width, size.height);
            popupBackground = robot.createScreenCapture(rect);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void disableMacShadow() {
        try {
            Method m = nsApplicationClazz.getDeclaredMethod("sharedApplication", new Class[0]);
            Object nsApplication = m.invoke((Object)nsApplicationClazz, new Object[0]);
            m = nsApplicationClazz.getDeclaredMethod("windows", new Class[0]);
            Object nsArray = m.invoke(nsApplication, new Object[0]);
            m = nsArrayClazz.getDeclaredMethod("reverseObjectEnumerator", new Class[0]);
            Enumeration e = (Enumeration)m.invoke(nsArray, new Object[0]);
            Rectangle r = this.heavyWeightContainer.getBounds();
            while (e.hasMoreElements()) {
                Object nsWindow = e.nextElement();
                m = nsWindowClazz.getDeclaredMethod("frame", new Class[0]);
                Object nsRect = m.invoke(nsWindow, new Object[0]);
                m = nsRectClazz.getDeclaredMethod("x", new Class[0]);
                float x = ((Float)m.invoke(nsRect, new Object[0])).floatValue();
                m = nsRectClazz.getDeclaredMethod("width", new Class[0]);
                float width = ((Float)m.invoke(nsRect, new Object[0])).floatValue();
                m = nsRectClazz.getDeclaredMethod("height", new Class[0]);
                float height = ((Float)m.invoke(nsRect, new Object[0])).floatValue();
                if ((float)r.x != x || (float)r.width != width || (float)r.height != height) continue;
                m = nsWindowClazz.getDeclaredMethod("hasShadow", new Class[0]);
                boolean hasShadow = (Boolean)m.invoke(nsWindow, new Object[0]);
                if (hasShadow) {
                    m = nsWindowClazz.getDeclaredMethod("setHasShadow", Boolean.TYPE);
                    m.invoke(nsWindow, Boolean.FALSE);
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

