/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.filechooser;

import de.javasoft.io.FileOperationEvent;
import de.javasoft.io.FileOperationListener;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class FileOperationDialog
extends JDialog
implements FileOperationListener,
Runnable {
    public static final int COPY_OPERATION = 1;
    public static final int MOVE_OPERATION = 2;
    public static final int DELETE_OPERATION = 3;
    private boolean abort;
    private JLabel folderName;
    private JLabel fileName;
    private String currentFolderName;
    private String currentFileName;
    private JProgressBar progressBar;
    private static final int xGap = 10;
    private static final int yGap = 10;
    String title = "";
    String imagePath = "";
    static /* synthetic */ Class class$0;

    public FileOperationDialog(Dialog owner, int operation) {
        super(owner);
        switch (operation) {
            case 1: {
                this.title = UIManager.getString("FileOperationDialog.copy.title");
                this.imagePath = UIManager.getString("Synthetica.fileOperationDialog.title.copyBackground");
                break;
            }
            case 2: {
                this.title = UIManager.getString("FileOperationDialog.move.title");
                this.imagePath = UIManager.getString("Synthetica.fileOperationDialog.title.moveBackground");
                break;
            }
            case 3: {
                this.title = UIManager.getString("FileOperationDialog.delete.title");
                this.imagePath = UIManager.getString("Synthetica.fileOperationDialog.title.deleteBackground");
            }
        }
        this.setTitle(this.title);
        this.setLayout(new BorderLayout());
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        JPanel topPanel = new JPanel(){
            private Image background;
            {
                this.background = new ImageIcon(SyntheticaLookAndFeel.class.getResource(FileOperationDialog.this.imagePath)).getImage();
            }

            public void paintComponent(Graphics g) {
                g.drawImage(this.background, 0, 0, null);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                int xPos = UIManager.getInt("Synthetica.fileOperationDialog.title.xPos");
                int yPos = UIManager.getInt("Synthetica.fileOperationDialog.title.yPos");
                g2.drawString(FileOperationDialog.this.title, xPos, yPos);
                g2.dispose();
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.background.getWidth(null), this.background.getHeight(null));
            }
        };
        int fontSize = UIManager.getInt("Synthetica.fileOperationDialog.title.size");
        topPanel.setFont(topPanel.getFont().deriveFont(1, fontSize));
        topPanel.setForeground(UIManager.getColor("Synthetica.fileOperationDialog.title.color"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JPanel aniPanel = new JPanel(new BorderLayout());
        panel.add((Component)aniPanel, gbc);
        gbc.insets = new Insets(0, 0, 2, 10);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JLabel folderLabel = new JLabel(UIManager.getString("FileOperationDialog.folder"));
        panel.add((Component)folderLabel, gbc);
        gbc.insets = new Insets(0, 0, 2, 0);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.folderName = new JLabel();
        panel.add((Component)this.folderName, gbc);
        gbc.insets = new Insets(0, 0, 10, 10);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JLabel fileNameLabel = new JLabel(UIManager.getString("FileOperationDialog.file"));
        panel.add((Component)fileNameLabel, gbc);
        gbc.insets = new Insets(0, 0, 10, 0);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.fileName = new JLabel();
        panel.add((Component)this.fileName, gbc);
        gbc.insets = new Insets(0, 0, 20, 0);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.progressBar = new JProgressBar(0, 50);
        panel.add((Component)this.progressBar, gbc);
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JButton cancelButton = new JButton(UIManager.getString("FileOperationDialog.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileOperationDialog.this.abort = true;
                FileOperationDialog.this.dispose();
            }
        });
        panel.add((Component)cancelButton, gbc);
        this.add((Component)topPanel, "North");
        this.add(panel);
        this.pack();
        int x = owner.getLocation().x + owner.getSize().width / 2;
        int xLoc = x - this.getSize().width / 2;
        int y = owner.getLocation().y + owner.getSize().height / 2;
        int yLoc = y - this.getSize().height / 2;
        this.setLocation(xLoc, yLoc);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FileOperationDialog.this.abort = true;
            }
        });
    }

    public boolean processFileOperationEvent(FileOperationEvent evt) {
        this.currentFolderName = evt.getFile().getParentFile().getName();
        this.currentFileName = evt.getFile().getName();
        EventQueue.invokeLater(this);
        return !this.abort;
    }

    public void run() {
        this.folderName.setText(this.currentFolderName);
        this.fileName.setText(this.currentFileName);
        this.progressBar.setValue((this.progressBar.getValue() + 1) % 50);
    }
}

