/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaTitlePane;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class ButtonPainter
extends SynthPainter {
    private static SynthPainter instance = new ButtonPainter();
    private static WeakHashMap<JButton, Object> buttons = new WeakHashMap();

    private ButtonPainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintButtonBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean pressed;
        JButton button = (JButton)sc.getComponent();
        Container parent = button.getParent();
        int state = sc.getComponentState();
        boolean hover = (state & 2) > 0;
        boolean bl = pressed = (state & 4) > 0;
        if (parent != null) {
            if (parent instanceof BasicInternalFrameTitlePane && !SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.buttons.paintBorder", button)) {
                return;
            }
            if (parent instanceof SyntheticaTitlePane && !SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.buttons.paintBorder", button)) {
                return;
            }
            if (this.isToolBarComponent(button)) {
                Insets margin = (Insets)sc.getStyle().get(sc, "Button.margin");
                Insets bMargin = button.getMargin();
                if (bMargin == null) {
                    return;
                }
                if ((bMargin.equals(margin) || !buttons.containsKey(button) && (button.getText() == null || "".equals(button.getText().trim()))) && bMargin.equals(margin)) {
                    button.setMargin(new Insets(bMargin.bottom - margin.bottom, bMargin.left - margin.left, bMargin.top - margin.top, bMargin.right - margin.right));
                }
                buttons.put(button, null);
                boolean paintBorder = SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.buttons.paintBorder", button);
                if (!(paintBorder || hover || pressed && SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.button.pressed.paintBorder", button))) {
                    return;
                }
            }
        }
        if (button.isBorderPainted() || button.getText() == null || button.getText().length() == 0) {
            Insets sInsets;
            if (!button.isBorderPainted() && !hover) {
                return;
            }
            if (!button.isContentAreaFilled()) {
                return;
            }
            Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.button.border.insets", button);
            String imagePath = "Synthetica.button";
            if (w <= 12 || h <= 12) {
                imagePath = String.valueOf(imagePath) + ".12x12";
                dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.button.12x12.border.insets", button);
            }
            imagePath = String.valueOf(imagePath) + ".border";
            if (button.isDefaultButton()) {
                imagePath = String.valueOf(imagePath) + ".default";
            }
            if (pressed) {
                imagePath = String.valueOf(imagePath) + ".pressed";
            } else if (!button.isEnabled()) {
                imagePath = String.valueOf(imagePath) + ".disabled";
            } else if (hover) {
                imagePath = String.valueOf(imagePath) + ".hover";
            }
            if (this.isToolBarComponent(button) && hover && !pressed) {
                imagePath = "Synthetica.toolBar.button.border.hover";
            } else if (this.isToolBarComponent(button) && !pressed) {
                imagePath = "Synthetica.toolBar.button.border";
            } else if (this.isToolBarComponent(button) && pressed && SyntheticaLookAndFeel.getString("Synthetica.toolBar.button.border.pressed", button) != null) {
                imagePath = "Synthetica.toolBar.button.border.pressed";
            }
            imagePath = SyntheticaLookAndFeel.getString(imagePath, button);
            if (imagePath != null) {
                int delay = 0;
                int cycles = 0;
                int type = 0;
                if (button.isDefaultButton()) {
                    cycles = SyntheticaLookAndFeel.getInt("Synthetica.button.default.animation.cycles", button, -1);
                    delay = SyntheticaLookAndFeel.getInt("Synthetica.button.default.animation.delay", button, 70);
                    type = SyntheticaLookAndFeel.getInt("Synthetica.button.default.animation.type", button, 0);
                } else if (hover) {
                    cycles = SyntheticaLookAndFeel.getInt("Synthetica.button.hover.animation.cycles", button, 1);
                    delay = SyntheticaLookAndFeel.getInt("Synthetica.button.hover.animation.delay", button, 50);
                    type = SyntheticaLookAndFeel.getInt("Synthetica.button.hover.animation.type", button, 1);
                } else {
                    cycles = SyntheticaLookAndFeel.getInt("Synthetica.button.animation.cycles", button, 1);
                    delay = SyntheticaLookAndFeel.getInt("Synthetica.button.animation.delay", button, 50);
                    type = SyntheticaLookAndFeel.getInt("Synthetica.button.animation.type", button, 2);
                }
                ImagePainter imagePainter = new ImagePainter((JComponent)button, cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.draw();
            }
            if (button.hasFocus()) {
                FocusPainter.paintFocus("focus.button", sc, g, x, y, w, h);
            }
        }
    }

    private boolean isToolBarComponent(Component c) {
        Container parent = c.getParent();
        if (parent instanceof JToolBar) {
            return true;
        }
        if (parent != null) {
            return this.isToolBarComponent(parent);
        }
        return false;
    }
}

