/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.table.JTableHeader;

public class LabelPainter
extends SynthPainter {
    private static SynthPainter instance = new LabelPainter();

    private LabelPainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintLabelBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JLabel label = (JLabel)sc.getComponent();
        Container parent = label.getParent();
        if (label.getName() != null && label.getName().startsWith("ComboBox.") && !label.isOpaque() && parent instanceof CellRendererPane && !(parent.getParent() instanceof JComboBox)) {
            Color color = g.getColor();
            g.setColor(label.getBackground());
            g.fillRect(x, y, w, h);
            g.setColor(color);
        }
        if (label.getName() != null && label.getName().startsWith("TableHeader.") && parent.getParent() instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)parent.getParent();
            label.setFont(header.getFont());
            Color color = g.getColor();
            Color gColor = SyntheticaLookAndFeel.getColor("Synthetica.tableHeader.gridColor", header);
            g.setColor(gColor);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            g.setColor(color);
            return;
        }
        if (parent instanceof CellRendererPane && parent.getParent() instanceof JComboBox) {
            JComboBox cb = (JComboBox)parent.getParent();
            boolean opaque = SyntheticaLookAndFeel.isOpaque(cb);
            Color cbBackground = cb.getBackground();
            Color textColor = null;
            Color backColor = null;
            if (!cb.isEnabled()) {
                textColor = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.disabled.textColor", cb);
                if (cbBackground == null || cbBackground instanceof ColorUIResource) {
                    backColor = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.disabled.backgroundColor", cb);
                }
            } else if (cb.hasFocus()) {
                textColor = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.focused.textColor", cb);
                if (SyntheticaLookAndFeel.get("Synthetica.comboBox.border.locked", cb) == null) {
                    backColor = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.focused.backgroundColor", cb);
                }
            } else if (!cb.isEditable()) {
                textColor = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.locked.textColor", cb);
                if (cbBackground == null || cbBackground instanceof ColorUIResource) {
                    backColor = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.locked.backgroundColor", cb);
                }
            }
            if (textColor != null) {
                label.setForeground(textColor);
            }
            String imagePath = "Synthetica.comboBox.border.locked";
            if (cb.isEnabled() && !cb.isEditable() && opaque && SyntheticaLookAndFeel.getString(imagePath, cb) != null && (cbBackground == null || cbBackground instanceof ColorUIResource)) {
                imagePath = SyntheticaLookAndFeel.getString(imagePath, cb);
                Insets sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.comboBox.border.insets", cb);
                Insets dInsets = new Insets(0, 0, 0, 0);
                ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.drawCenter();
                return;
            }
            if (backColor != null && (opaque || cb.hasFocus())) {
                Color color = g.getColor();
                g.setColor(backColor);
                g.fillRect(x, y, w, h);
                g.setColor(color);
            }
        }
    }
}

