/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class SeparatorPainter
extends SynthPainter {
    private static SynthPainter instance = new SeparatorPainter();
    static /* synthetic */ Class class$0;

    private SeparatorPainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintSeparatorBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComponent c = sc.getComponent();
        if (c.getParent() instanceof JPopupMenu) {
            Insets sInsets;
            JPopupMenu popup = (JPopupMenu)c.getParent();
            String imagePath = "Synthetica.popupMenuSeparator";
            imagePath = SyntheticaLookAndFeel.getString(imagePath, popup);
            if ((SyntheticaLookAndFeel.popupHasIcons(popup) || SyntheticaLookAndFeel.popupHasCheckRadio(popup)) && !SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(popup)) {
                int pGap = SyntheticaLookAndFeel.getInt("Synthetica.popupMenuSeparator.iconSeparatorGap", popup);
                int iGap = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.gap", popup, 24);
                int separatorWidth = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.width", popup, 1);
                x += iGap + separatorWidth - popup.getInsets().left + pGap;
            }
            Insets dInsets = sInsets = new Insets(0, 0, 0, 0);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintSeparatorForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        Insets sInsets;
        String imagePath = "Synthetica.separator";
        JComponent c = sc.getComponent();
        if (c instanceof JToolBar.Separator) {
            imagePath = String.valueOf(imagePath) + ".toolBar";
        } else if (c.getParent() != null && ((JComponent)c.getParent()).getUIClassID().equals("StatusBarUI")) {
            imagePath = String.valueOf(imagePath) + ".statusBar";
        }
        imagePath = String.valueOf(imagePath) + ".image";
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets(String.valueOf(imagePath) + ".insets", c);
        imagePath = orientation == 0 ? String.valueOf(imagePath) + ".x" : String.valueOf(imagePath) + ".y";
        imagePath = SyntheticaLookAndFeel.getString(imagePath, c);
        if (imagePath == null) {
            return;
        }
        if (c instanceof JToolBar.Separator) {
            JToolBar.Separator separator = (JToolBar.Separator)c;
            if (SyntheticaLookAndFeel.getToolbarSeparatorDimension() == null) {
                Image image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(imagePath)).getImage();
                int iWidth = image.getWidth(null);
                int iHeight = image.getHeight(null);
                int width = 0;
                int height = 0;
                Component[] componentArray = separator.getParent().getComponents();
                int n = 0;
                int n2 = componentArray.length;
                while (n < n2) {
                    Component comp = componentArray[n];
                    if (!(comp instanceof JToolBar.Separator)) {
                        if (comp.getMinimumSize().width > width) {
                            width = comp.getMinimumSize().width;
                        }
                        if (comp.getMinimumSize().height > height) {
                            height = comp.getMinimumSize().height;
                        }
                    }
                    ++n;
                }
                DimensionUIResource newSize = null;
                newSize = orientation == 1 ? new DimensionUIResource(iWidth, height) : new DimensionUIResource(width, iHeight);
                separator.setSeparatorSize(newSize);
                separator.revalidate();
            }
        }
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.draw();
    }
}

