/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JSpinner;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class SpinnerPainter
extends SynthPainter {
    private static SynthPainter instance = new SpinnerPainter();

    private SpinnerPainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintSpinnerBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JSpinner spinner = (JSpinner)sc.getComponent();
        String imagePath = "Synthetica.spinner.border";
        if (!spinner.isEnabled()) {
            imagePath = String.valueOf(imagePath) + ".disabled";
        }
        if ((imagePath = SyntheticaLookAndFeel.getString(imagePath, spinner)) != null) {
            Insets sInsets;
            Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.spinner.border.insets", spinner);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.drawBorder();
            if (spinner.isEnabled()) {
                Component c = SyntheticaLookAndFeel.findComponent("Spinner.formattedTextField", spinner);
                if (spinner.hasFocus() || c != null && c.hasFocus()) {
                    FocusPainter.paintFocus("focus.spinner", sc, g, x, y, w, h);
                }
            }
        }
    }

    public void paintSpinnerBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JSpinner spinner = (JSpinner)sc.getComponent();
        Color background = spinner.getBackground();
        if (background instanceof ColorUIResource) {
            background = sc.getStyle().getColor(sc, ColorType.BACKGROUND);
        }
        SyntheticaLookAndFeel.setChildrenOpaque(spinner, false);
        if (SyntheticaLookAndFeel.isOpaque(spinner)) {
            String key = "Synthetica.spinner.border";
            if (!spinner.isEnabled()) {
                key = String.valueOf(key) + ".disabled";
            }
            key = String.valueOf(key) + ".opaqueBackground";
            if ((background == null || background instanceof ColorUIResource) && SyntheticaLookAndFeel.getBoolean(key, spinner)) {
                String imagePath = "Synthetica.spinner.border";
                if (!spinner.isEnabled()) {
                    imagePath = String.valueOf(imagePath) + ".disabled";
                }
                if ((imagePath = SyntheticaLookAndFeel.getString(imagePath, spinner)) != null) {
                    Insets sInsets;
                    Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.spinner.border.insets", spinner);
                    ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                    imagePainter.drawCenter();
                    return;
                }
            }
            int arcWidth = SyntheticaLookAndFeel.get("Synthetica.spinner.border.arcWidth", spinner) == null ? 8 : SyntheticaLookAndFeel.getInt("Synthetica.spinner.border.arcWidth", spinner);
            int arcHeight = SyntheticaLookAndFeel.get("Synthetica.spinner.border.arcHeight", spinner) == null ? 8 : SyntheticaLookAndFeel.getInt("Synthetica.spinner.border.arcHeight", spinner);
            Graphics2D g2 = (Graphics2D)g;
            Color color = g2.getColor();
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(background);
            g2.fillRoundRect(x, y, w, h, arcWidth, arcHeight);
            g2.setRenderingHints(rh);
            g2.setColor(color);
        }
    }
}

