/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.text.JTextComponent;

class TextComponentPainter
extends SynthPainter {
    TextComponentPainter() {
    }

    protected void paintBackground(String name, SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JTextComponent tc = (JTextComponent)sc.getComponent();
        if (tc.getParent() instanceof JComboBox || tc.getName() != null && tc.getName().startsWith("Spinner")) {
            return;
        }
        boolean multiLine = "textArea".equals(name) || "textPane".equals(name) || "editorPane".equals(name);
        Color background = tc.getBackground();
        if (background instanceof ColorUIResource) {
            background = tc.isEditable() ? sc.getStyle().getColor(sc, ColorType.BACKGROUND) : SyntheticaLookAndFeel.getColor("Synthetica." + name + ".lockedColor", tc);
        }
        if (SyntheticaLookAndFeel.isOpaque(tc)) {
            String imagePath = "Synthetica." + name + ".border.locked";
            if (tc.isEnabled() && !tc.isEditable() && SyntheticaLookAndFeel.get(imagePath, tc) != null && (background == null || background instanceof ColorUIResource)) {
                Insets sInsets;
                if (multiLine) {
                    return;
                }
                imagePath = SyntheticaLookAndFeel.getString(imagePath, tc);
                Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica." + name + ".border.insets", tc);
                ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.draw();
                if (tc.hasFocus()) {
                    FocusPainter.paintFocus("focus." + name, sc, g, x, y, w, h);
                }
                return;
            }
            String key = "Synthetica." + name + ".border";
            if (!tc.isEnabled()) {
                key = String.valueOf(key) + ".disabled";
            }
            key = String.valueOf(key) + ".opaqueBackground";
            if ((background == null || background instanceof ColorUIResource) && SyntheticaLookAndFeel.getBoolean(key, tc)) {
                Insets sInsets;
                if (multiLine) {
                    name = "scrollPane";
                }
                imagePath = "Synthetica." + name + ".border";
                if (!tc.isEnabled()) {
                    imagePath = String.valueOf(imagePath) + ".disabled";
                }
                imagePath = SyntheticaLookAndFeel.getString(imagePath, tc);
                Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica." + name + ".border.insets", tc);
                if (multiLine) {
                    dInsets = new Insets(0, 0, 0, 0);
                }
                ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.drawCenter();
            } else if (multiLine) {
                Color color = g.getColor();
                g.setColor(background);
                g.fillRect(x, y, w, h);
                g.setColor(color);
            } else {
                int arcWidth = SyntheticaLookAndFeel.get("Synthetica." + name + ".border.arcWidth", tc) == null ? 8 : SyntheticaLookAndFeel.getInt("Synthetica." + name + ".border.arcWidth", tc);
                int arcHeight = SyntheticaLookAndFeel.get("Synthetica." + name + ".border.arcHeight", tc) == null ? 8 : SyntheticaLookAndFeel.getInt("Synthetica." + name + ".border.arcHeight", tc);
                Graphics2D g2 = (Graphics2D)g;
                Color color = g2.getColor();
                RenderingHints rh = g2.getRenderingHints();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(background);
                g2.fillRoundRect(x, y, w, h, arcWidth, arcHeight);
                g2.setRenderingHints(rh);
                g2.setColor(color);
            }
        }
    }

    protected void paintBorder(String name, SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        JComponent c = sc.getComponent();
        FocusPainter.installFocusListener(c);
        if (c.getParent() instanceof JComboBox || c.getName() != null && c.getName().startsWith("Spinner")) {
            return;
        }
        if (SyntheticaLookAndFeel.isOpaque(c) && c.isEnabled() && SyntheticaLookAndFeel.get("Synthetica." + name + ".border.locked", c) != null && c instanceof JTextComponent && !((JTextComponent)c).isEditable() && (c.getBackground() == null || c.getBackground() instanceof ColorUIResource)) {
            return;
        }
        String imagePath = "Synthetica." + name + ".border";
        if ((sc.getComponentState() & 8) > 0) {
            imagePath = String.valueOf(imagePath) + ".disabled";
        }
        imagePath = SyntheticaLookAndFeel.getString(imagePath, c);
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica." + name + ".border.insets", c);
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.drawBorder();
        if (c.hasFocus()) {
            FocusPainter.paintFocus("focus." + name, sc, g, x, y, w, h);
        }
    }
}

