/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class ToggleButtonPainter
extends SynthPainter {
    private static SynthPainter instance = new ToggleButtonPainter();

    private ToggleButtonPainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintToggleButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean selected;
        JToggleButton button = (JToggleButton)sc.getComponent();
        Container parent = button.getParent();
        int state = sc.getComponentState();
        if ((state & 4) > 0 && (state & 2) > 0) {
            state ^= 2;
        }
        boolean hover = (state & 2) > 0;
        boolean bl = selected = (state & 0x200) > 0;
        if (parent instanceof JToolBar && !SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.buttons.paintBorder", button) && !hover && !selected) {
            return;
        }
        if (button.isBorderPainted() || button.getText() == null || button.getText().length() == 0) {
            Insets sInsets;
            if (!(button.isBorderPainted() || hover || selected)) {
                return;
            }
            Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.toggleButton.border.insets", button);
            String imagePath = "Synthetica.toggleButton";
            imagePath = String.valueOf(imagePath) + ".border";
            if (selected) {
                imagePath = String.valueOf(imagePath) + ".selected";
            }
            if (!button.isEnabled()) {
                imagePath = String.valueOf(imagePath) + ".disabled";
            }
            if (parent instanceof JToolBar && hover && !selected) {
                imagePath = "Synthetica.toolBar.button.border.hover";
            } else if (parent instanceof JToolBar && !selected) {
                imagePath = "Synthetica.toolBar.button.border";
            } else if (parent instanceof JToolBar && selected && !hover && SyntheticaLookAndFeel.getString("Synthetica.toolBar.toggleButton.border.selected", button) != null) {
                imagePath = "Synthetica.toolBar.toggleButton.border.selected";
            } else if (parent instanceof JToolBar && selected && hover && SyntheticaLookAndFeel.getString("Synthetica.toolBar.toggleButton.border.selectedAndHover", button) != null) {
                imagePath = "Synthetica.toolBar.toggleButton.border.selectedAndHover";
            } else if (hover) {
                imagePath = String.valueOf(imagePath) + ".hover";
            }
            imagePath = SyntheticaLookAndFeel.getString(imagePath, button);
            if (imagePath == null) {
                return;
            }
            int cycles = 0;
            int delay = 0;
            int type = 0;
            if (hover) {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.hover.animation.cycles", button, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.hover.animation.delay", button, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.hover.animation.type", button, 1);
            } else {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.animation.cycles", button, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.animation.delay", button, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.animation.type", button, 2);
            }
            ImagePainter imagePainter = new ImagePainter((JComponent)button, cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
        if (button.hasFocus()) {
            FocusPainter.paintFocus("focus.toggleButton", sc, g, x, y, w, h);
        }
    }
}

