/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class ToolTipPainter
extends SynthPainter {
    private static SynthPainter instance = new ToolTipPainter();
    private static WeakHashMap<JToolTip, Object> opaqued = new WeakHashMap();

    private ToolTipPainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintToolTipBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        BufferedImage background;
        JToolTip toolTip = (JToolTip)sc.getComponent();
        int state = sc.getComponentState();
        JPanel panel = (JPanel)toolTip.getParent();
        if (!opaqued.containsKey(toolTip)) {
            opaqued.put(toolTip, null);
            toolTip.setOpaque(false);
            panel.setOpaque(false);
            panel.repaint();
        }
        if ((background = (BufferedImage)panel.getClientProperty("POPUP_BACKGROUND")) != null) {
            g.drawImage(background, x, y, null);
        }
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.toolTip.background.insets", toolTip);
        String imagePath = SyntheticaLookAndFeel.getString("Synthetica.toolTip.background", toolTip);
        int cycles = SyntheticaLookAndFeel.getInt("Synthetica.toolTip.animation.cycles", toolTip, 1);
        int delay = SyntheticaLookAndFeel.getInt("Synthetica.toolTip.animation.delay", toolTip, 50);
        int type = SyntheticaLookAndFeel.getInt("Synthetica.toolTip.animation.type", toolTip, 4);
        ImagePainter imagePainter = new ImagePainter((JComponent)toolTip, cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.draw();
    }
}

