/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaDefaultTreeCellRenderer;
import java.awt.Graphics;
import java.util.WeakHashMap;
import javax.swing.JTree;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class TreePainter
extends SynthPainter {
    private static SynthPainter instance = new TreePainter();
    private static WeakHashMap<JTree, Object> trees = new WeakHashMap();

    private TreePainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void reinitialize() {
        trees = new WeakHashMap();
    }

    public void paintTreeBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JTree tree = (JTree)sc.getComponent();
        if (!trees.containsKey(tree)) {
            trees.put(tree, null);
            TreeCellRenderer cellRenderer = tree.getCellRenderer();
            if (cellRenderer instanceof DefaultTreeCellRenderer && cellRenderer.getClass().getName().startsWith("javax.swing.plaf.synth.Synth")) {
                DefaultTreeCellRenderer defaultRenderer = (DefaultTreeCellRenderer)cellRenderer;
                SyntheticaDefaultTreeCellRenderer renderer = new SyntheticaDefaultTreeCellRenderer();
                if (defaultRenderer.getLeafIcon() == null) {
                    renderer.setLeafIcon(null);
                }
                if (defaultRenderer.getOpenIcon() == null) {
                    renderer.setOpenIcon(null);
                }
                if (defaultRenderer.getClosedIcon() == null) {
                    renderer.setClosedIcon(null);
                }
                tree.setCellRenderer(renderer);
            }
        }
    }
}

