/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.filters;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.filters.EfficientFilter;
import edu.uci.ics.jung.graph.filters.Filter;
import edu.uci.ics.jung.graph.filters.TrivialFilter;
import edu.uci.ics.jung.graph.filters.UnassembledGraph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SerialFilter
implements Filter,
EfficientFilter {
    private List filters;

    public String getName() {
        String rv = "Serial[";
        boolean first = true;
        Iterator iter = this.filters.iterator();
        while (iter.hasNext()) {
            Filter f = (Filter)iter.next();
            rv = rv + (first ? "" : ",") + f.getName();
            first = false;
        }
        rv = rv + "]";
        return rv;
    }

    public SerialFilter(Filter f1, Filter f2) {
        this.filters = new ArrayList();
        this.filters.add(f1);
        this.filters.add(f2);
    }

    public SerialFilter(List filters) {
        if (filters == null) {
            throw new IllegalArgumentException("List can not be null.");
        }
        this.filters = new LinkedList(filters);
    }

    public SerialFilter() {
        this.filters = new LinkedList();
    }

    public void append(Filter f) {
        this.filters.add(f);
    }

    public UnassembledGraph filter(Graph g) {
        UnassembledGraph ug = TrivialFilter.getInstance().filter(g);
        return this.filter(ug);
    }

    public UnassembledGraph filter(UnassembledGraph g) {
        UnassembledGraph ug = g;
        Iterator iter = this.filters.iterator();
        while (iter.hasNext()) {
            Filter f = (Filter)iter.next();
            if (f instanceof EfficientFilter) {
                EfficientFilter nfe = (EfficientFilter)f;
                ug = nfe.filter(ug);
                continue;
            }
            Graph prev = ug.assemble();
            ug = f.filter(prev);
        }
        return ug;
    }
}

